/*
 * Copyright (c) 2012, 2022, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class CurrencyNames_el extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final Object[][] data = new Object[][] {
            { "AED", "AED" },
            { "AFN", "AFN" },
            { "ALL", "ALL" },
            { "AMD", "AMD" },
            { "ANG", "ANG" },
            { "AOA", "AOA" },
            { "ARS", "ARS" },
            { "AWG", "AWG" },
            { "AZN", "AZN" },
            { "BAM", "BAM" },
            { "BBD", "BBD" },
            { "BDT", "BDT" },
            { "BGN", "BGN" },
            { "BHD", "BHD" },
            { "BIF", "BIF" },
            { "BMD", "BMD" },
            { "BND", "BND" },
            { "BOB", "BOB" },
            { "BSD", "BSD" },
            { "BTN", "BTN" },
            { "BWP", "BWP" },
            { "BYN", "BYN" },
            { "BYR", "BYR" },
            { "BZD", "BZD" },
            { "CDF", "CDF" },
            { "CHF", "CHF" },
            { "CLP", "CLP" },
            { "CNH", "CNH" },
            { "COP", "COP" },
            { "CRC", "CRC" },
            { "CUC", "CUC" },
            { "CUP", "CUP" },
            { "CVE", "CVE" },
            { "CZK", "CZK" },
            { "DJF", "DJF" },
            { "DKK", "DKK" },
            { "DOP", "DOP" },
            { "DZD", "DZD" },
            { "EGP", "EGP" },
            { "ERN", "ERN" },
            { "ETB", "ETB" },
            { "FJD", "FJD" },
            { "FKP", "FKP" },
            { "GEL", "GEL" },
            { "GHS", "GHS" },
            { "GIP", "GIP" },
            { "GMD", "GMD" },
            { "GNF", "GNF" },
            { "GRD", "\u0394\u03c1\u03c7" },
            { "GTQ", "GTQ" },
            { "GYD", "GYD" },
            { "HNL", "HNL" },
            { "HRK", "HRK" },
            { "HTG", "HTG" },
            { "HUF", "HUF" },
            { "IDR", "IDR" },
            { "IQD", "IQD" },
            { "IRR", "IRR" },
            { "ISK", "ISK" },
            { "JMD", "JMD" },
            { "JOD", "JOD" },
            { "KES", "KES" },
            { "KGS", "KGS" },
            { "KHR", "KHR" },
            { "KMF", "KMF" },
            { "KPW", "KPW" },
            { "KWD", "KWD" },
            { "KYD", "KYD" },
            { "KZT", "KZT" },
            { "LAK", "LAK" },
            { "LBP", "LBP" },
            { "LKR", "LKR" },
            { "LRD", "LRD" },
            { "LTL", "LTL" },
            { "LVL", "LVL" },
            { "LYD", "LYD" },
            { "MAD", "MAD" },
            { "MDL", "MDL" },
            { "MGA", "MGA" },
            { "MKD", "MKD" },
            { "MMK", "MMK" },
            { "MNT", "MNT" },
            { "MOP", "MOP" },
            { "MRO", "MRO" },
            { "MUR", "MUR" },
            { "MVR", "MVR" },
            { "MWK", "MWK" },
            { "MYR", "MYR" },
            { "MZN", "MZN" },
            { "NAD", "NAD" },
            { "NGN", "NGN" },
            { "NIO", "NIO" },
            { "NOK", "NOK" },
            { "NPR", "NPR" },
            { "OMR", "OMR" },
            { "PAB", "PAB" },
            { "PEN", "PEN" },
            { "PGK", "PGK" },
            { "PHP", "PHP" },
            { "PKR", "PKR" },
            { "PLN", "PLN" },
            { "PYG", "PYG" },
            { "QAR", "QAR" },
            { "RON", "RON" },
            { "RSD", "RSD" },
            { "RUB", "RUB" },
            { "RWF", "RWF" },
            { "SAR", "SAR" },
            { "SBD", "SBD" },
            { "SCR", "SCR" },
            { "SDG", "SDG" },
            { "SEK", "SEK" },
            { "SGD", "SGD" },
            { "SHP", "SHP" },
            { "SLL", "SLL" },
            { "SOS", "SOS" },
            { "SRD", "SRD" },
            { "SSP", "SSP" },
            { "STD", "STD" },
            { "SYP", "SYP" },
            { "SZL", "SZL" },
            { "THB", "\u0e3f" },
            { "TJS", "TJS" },
            { "TMT", "TMT" },
            { "TND", "TND" },
            { "TOP", "TOP" },
            { "TPE", "TPE" },
            { "TRY", "TRY" },
            { "TTD", "TTD" },
            { "TZS", "TZS" },
            { "UAH", "UAH" },
            { "UGX", "UGX" },
            { "USD", "$" },
            { "UYU", "UYU" },
            { "UZS", "UZS" },
            { "VEF", "VEF" },
            { "VUV", "VUV" },
            { "WST", "WST" },
            { "YER", "YER" },
            { "ZAR", "ZAR" },
            { "ZMW", "ZMW" },
            { "adp", "\u03a0\u03b5\u03c3\u03ad\u03c4\u03b1 \u0391\u03bd\u03b4\u03cc\u03c1\u03b1\u03c2" },
            { "aed", "\u039d\u03c4\u03b9\u03c1\u03ac\u03bc \u0397\u03bd\u03c9\u03bc\u03ad\u03bd\u03c9\u03bd \u0391\u03c1\u03b1\u03b2\u03b9\u03ba\u03ce\u03bd \u0395\u03bc\u03b9\u03c1\u03ac\u03c4\u03c9\u03bd" },
            { "afa", "\u0391\u03c6\u03b3\u03b1\u03bd\u03af \u0391\u03c6\u03b3\u03b1\u03bd\u03b9\u03c3\u03c4\u03ac\u03bd (1927\u20132002)" },
            { "afn", "\u0391\u03c6\u03b3\u03ac\u03bd\u03b9 \u0391\u03c6\u03b3\u03b1\u03bd\u03b9\u03c3\u03c4\u03ac\u03bd" },
            { "all", "\u039b\u03b5\u03ba \u0391\u03bb\u03b2\u03b1\u03bd\u03af\u03b1\u03c2" },
            { "amd", "\u039d\u03c4\u03c1\u03b1\u03bc \u0391\u03c1\u03bc\u03b5\u03bd\u03af\u03b1\u03c2" },
            { "ang", "\u0393\u03ba\u03af\u03bb\u03bd\u03c4\u03b1 \u039f\u03bb\u03bb\u03b1\u03bd\u03b4\u03b9\u03ba\u03ce\u03bd \u0391\u03bd\u03c4\u03b9\u03bb\u03bb\u03ce\u03bd" },
            { "aoa", "\u039a\u03bf\u03c5\u03ac\u03bd\u03b6\u03b1 \u0391\u03bd\u03b3\u03ba\u03cc\u03bb\u03b1\u03c2" },
            { "aok", "\u039a\u03bf\u03c5\u03ac\u03bd\u03b6\u03b1 \u0391\u03bd\u03b3\u03ba\u03cc\u03bb\u03b1\u03c2 (1977\u20131990)" },
            { "aon", "\u039d\u03ad\u03b1 \u039a\u03bf\u03c5\u03ac\u03bd\u03b6\u03b1 \u0391\u03bd\u03b3\u03ba\u03cc\u03bb\u03b1\u03c2 (1990\u20132000)" },
            { "ara", "\u03a9\u03c3\u03c4\u03c1\u03ac\u03bb \u0391\u03c1\u03b3\u03b5\u03c4\u03b9\u03bd\u03ae\u03c2" },
            { "arp", "\u03a0\u03ad\u03c3\u03bf \u0391\u03c1\u03b3\u03b5\u03bd\u03c4\u03b9\u03bd\u03ae\u03c2 (1983\u20131985)" },
            { "ars", "\u03a0\u03ad\u03c3\u03bf \u0391\u03c1\u03b3\u03b5\u03bd\u03c4\u03b9\u03bd\u03ae\u03c2" },
            { "ats", "\u03a3\u03b5\u03bb\u03af\u03bd\u03b9 \u0391\u03c5\u03c3\u03c4\u03c1\u03af\u03b1\u03c2" },
            { "aud", "\u0394\u03bf\u03bb\u03ac\u03c1\u03b9\u03bf \u0391\u03c5\u03c3\u03c4\u03c1\u03b1\u03bb\u03af\u03b1\u03c2" },
            { "awg", "\u03a6\u03bb\u03bf\u03c1\u03af\u03bd\u03b9 \u0391\u03c1\u03bf\u03cd\u03bc\u03c0\u03b1\u03c2" },
            { "azm", "\u039c\u03b1\u03bd\u03ac\u03c4 \u0391\u03b6\u03b5\u03c1\u03bc\u03c0\u03b1\u03ca\u03c4\u03b6\u03ac\u03bd (1993\u20132006)" },
            { "azn", "\u039c\u03b1\u03bd\u03ac\u03c4 \u0391\u03b6\u03b5\u03c1\u03bc\u03c0\u03b1\u03ca\u03c4\u03b6\u03ac\u03bd" },
            { "bad", "\u0394\u03b7\u03bd\u03ac\u03c1\u03b9\u03bf \u0392\u03bf\u03c3\u03bd\u03af\u03b1\u03c2-\u0395\u03c1\u03b6\u03b5\u03b3\u03bf\u03b2\u03af\u03bd\u03b7\u03c2" },
            { "bam", "\u039c\u03b5\u03c4\u03b1\u03c4\u03c1\u03ad\u03c8\u03b9\u03bc\u03bf \u039c\u03ac\u03c1\u03ba\u03bf \u0392\u03bf\u03c3\u03bd\u03af\u03b1\u03c2-\u0395\u03c1\u03b6\u03b5\u03b3\u03bf\u03b2\u03af\u03bd\u03b7\u03c2" },
            { "bbd", "\u0394\u03bf\u03bb\u03ac\u03c1\u03b9\u03bf \u039c\u03c0\u03b1\u03c1\u03bc\u03c0\u03ad\u03b9\u03bd\u03c4\u03bf\u03c2" },
            { "bdt", "\u03a4\u03ac\u03ba\u03b1 \u039c\u03c0\u03b1\u03b3\u03ba\u03bb\u03b1\u03bd\u03c4\u03ad\u03c2" },
            { "bec", "\u03a6\u03c1\u03ac\u03b3\u03ba\u03bf \u0392\u03b5\u03bb\u03b3\u03af\u03bf\u03c5 (\u03bc\u03b5\u03c4\u03b1\u03c4\u03c1\u03ad\u03c8\u03b9\u03bc\u03bf)" },
            { "bef", "\u03a6\u03c1\u03ac\u03b3\u03ba\u03bf \u0392\u03b5\u03bb\u03b3\u03af\u03bf\u03c5" },
            { "bel", "\u03a6\u03c1\u03ac\u03b3\u03ba\u03bf \u0392\u03b5\u03bb\u03b3\u03af\u03bf\u03c5 (\u03bf\u03b9\u03ba\u03bf\u03bd\u03bf\u03bc\u03b9\u03ba\u03cc)" },
            { "bgl", "\u039c\u03b5\u03c4\u03b1\u03bb\u03bb\u03b9\u03ba\u03cc \u039b\u03b5\u03b2 \u0392\u03bf\u03c5\u03bb\u03b3\u03b1\u03c1\u03af\u03b1\u03c2" },
            { "bgn", "\u039b\u03b5\u03b2 \u0392\u03bf\u03c5\u03bb\u03b3\u03b1\u03c1\u03af\u03b1\u03c2" },
            { "bhd", "\u0394\u03b7\u03bd\u03ac\u03c1\u03b9\u03bf \u039c\u03c0\u03b1\u03c7\u03c1\u03ad\u03b9\u03bd" },
            { "bif", "\u03a6\u03c1\u03ac\u03b3\u03ba\u03bf \u039c\u03c0\u03bf\u03c5\u03c1\u03bf\u03cd\u03bd\u03c4\u03b9" },
            { "bmd", "\u0394\u03bf\u03bb\u03ac\u03c1\u03b9\u03bf \u0392\u03b5\u03c1\u03bc\u03bf\u03cd\u03b4\u03c9\u03bd" },
            { "bnd", "\u0394\u03bf\u03bb\u03ac\u03c1\u03b9\u03bf \u039c\u03c0\u03c1\u03bf\u03c5\u03bd\u03ad\u03b9" },
            { "bob", "\u039c\u03c0\u03bf\u03bb\u03b9\u03b2\u03b9\u03ac\u03bd\u03bf \u0392\u03bf\u03bb\u03b9\u03b2\u03af\u03b1\u03c2" },
            { "bop", "\u03a0\u03ad\u03c3\u03bf \u0392\u03bf\u03bb\u03b9\u03b2\u03af\u03b1\u03c2" },
            { "bov", "\u039c\u03b2\u03b4\u03bf\u03bb \u0392\u03bf\u03bb\u03b9\u03b2\u03af\u03b1\u03c2" },
            { "brb", "\u039d\u03ad\u03bf \u039a\u03c1\u03bf\u03c5\u03b6\u03b9\u03ad\u03c1\u03bf \u0392\u03c1\u03b1\u03b6\u03b9\u03bb\u03af\u03b1\u03c2 (1967\u20131986)" },
            { "brc", "\u039a\u03c1\u03bf\u03c5\u03b6\u03ac\u03bd\u03c4\u03bf \u0392\u03c1\u03b1\u03b6\u03b9\u03bb\u03af\u03b1\u03c2" },
            { "bre", "\u039a\u03c1\u03bf\u03c5\u03b6\u03b9\u03ad\u03c1\u03bf \u0392\u03c1\u03b1\u03b6\u03b9\u03bb\u03af\u03b1\u03c2 (1990\u20131993)" },
            { "brl", "\u03a1\u03b5\u03ac\u03bb \u0392\u03c1\u03b1\u03b6\u03b9\u03bb\u03af\u03b1\u03c2" },
            { "brn", "\u039d\u03ad\u03bf \u039a\u03c1\u03bf\u03c5\u03b6\u03ac\u03bd\u03c4\u03bf \u0392\u03c1\u03b1\u03b6\u03b9\u03bb\u03af\u03b1\u03c2" },
            { "brr", "\u039a\u03c1\u03bf\u03c5\u03b6\u03b9\u03ad\u03c1\u03bf \u0392\u03c1\u03b1\u03b6\u03b9\u03bb\u03af\u03b1\u03c2" },
            { "bsd", "\u0394\u03bf\u03bb\u03ac\u03c1\u03b9\u03bf \u039c\u03c0\u03b1\u03c7\u03b1\u03bc\u03ce\u03bd" },
            { "btn", "\u039d\u03b3\u03ba\u03bf\u03cd\u03bb\u03c4\u03c1\u03bf\u03c5\u03bc \u039c\u03c0\u03bf\u03c5\u03c4\u03ac\u03bd" },
            { "buk", "\u039a\u03b9\u03b1\u03c4 \u0392\u03b9\u03c1\u03bc\u03b1\u03bd\u03af\u03b1\u03c2" },
            { "bwp", "\u03a0\u03bf\u03cd\u03bb\u03b1 \u039c\u03c0\u03bf\u03c4\u03c3\u03bf\u03c5\u03ac\u03bd\u03b1\u03c2" },
            { "byb", "\u039d\u03ad\u03bf \u03a1\u03bf\u03cd\u03b2\u03bb\u03b9 \u039b\u03b5\u03c5\u03ba\u03bf\u03c1\u03c9\u03c3\u03af\u03b1\u03c2 (1994\u20131999)" },
            { "byn", "\u03a1\u03bf\u03cd\u03b2\u03bb\u03b9 \u039b\u03b5\u03c5\u03ba\u03bf\u03c1\u03c9\u03c3\u03af\u03b1\u03c2" },
            { "byr", "\u03a1\u03bf\u03cd\u03b2\u03bb\u03b9 \u039b\u03b5\u03c5\u03ba\u03bf\u03c1\u03c9\u03c3\u03af\u03b1\u03c2 (2000\u20132016)" },
            { "bzd", "\u0394\u03bf\u03bb\u03ac\u03c1\u03b9\u03bf \u039c\u03c0\u03b5\u03bb\u03af\u03b6" },
            { "cad", "\u0394\u03bf\u03bb\u03ac\u03c1\u03b9\u03bf \u039a\u03b1\u03bd\u03b1\u03b4\u03ac" },
            { "cdf", "\u03a6\u03c1\u03ac\u03b3\u03ba\u03bf \u039a\u03bf\u03bd\u03b3\u03ba\u03cc" },
            { "che", "\u0395\u03c5\u03c1\u03ce WIR" },
            { "chf", "\u03a6\u03c1\u03ac\u03b3\u03ba\u03bf \u0395\u03bb\u03b2\u03b5\u03c4\u03af\u03b1\u03c2" },
            { "chw", "\u03a6\u03c1\u03ac\u03b3\u03ba\u03bf WIR" },
            { "clf", "\u039f\u03c5\u03bd\u03b9\u03b4\u03ac\u03b4\u03b5\u03c2 \u03bd\u03c4\u03b5 \u03c6\u03bf\u03bc\u03ad\u03bd\u03c4\u03bf \u03a7\u03b9\u03bb\u03ae\u03c2" },
            { "clp", "\u03a0\u03ad\u03c3\u03bf \u03a7\u03b9\u03bb\u03ae\u03c2" },
            { "cnh", "\u0393\u03bf\u03c5\u03ac\u03bd \u039a\u03af\u03bd\u03b1\u03c2 (\u03c5\u03c0\u03b5\u03c1\u03ac\u03ba\u03c4\u03b9\u03bf)" },
            { "cny", "\u0393\u03bf\u03c5\u03ac\u03bd \u039a\u03af\u03bd\u03b1\u03c2" },
            { "cop", "\u03a0\u03ad\u03c3\u03bf \u039a\u03bf\u03bb\u03bf\u03bc\u03b2\u03af\u03b1\u03c2" },
            { "crc", "\u039a\u03bf\u03bb\u03cc\u03bd \u039a\u03cc\u03c3\u03c4\u03b1 \u03a1\u03af\u03ba\u03b1" },
            { "csd", "\u03a0\u03b1\u03bb\u03b1\u03b9\u03cc \u0394\u03b7\u03bd\u03ac\u03c1\u03b9\u03bf \u03a3\u03b5\u03c1\u03b2\u03af\u03b1\u03c2" },
            { "csk", "\u03a3\u03ba\u03bb\u03b7\u03c1\u03ae \u039a\u03bf\u03c1\u03cc\u03bd\u03b1 \u03a4\u03c3\u03b5\u03c7\u03bf\u03c3\u03bb\u03bf\u03b2\u03b1\u03ba\u03af\u03b1\u03c2" },
            { "cuc", "\u039c\u03b5\u03c4\u03b1\u03c4\u03c1\u03ad\u03c8\u03b9\u03bc\u03bf \u03c0\u03ad\u03c3\u03bf \u039a\u03bf\u03cd\u03b2\u03b1\u03c2" },
            { "cup", "\u03a0\u03ad\u03c3\u03bf \u039a\u03bf\u03cd\u03b2\u03b1\u03c2" },
            { "cve", "\u0395\u03c3\u03ba\u03bf\u03cd\u03b4\u03bf \u03a0\u03c1\u03ac\u03c3\u03b9\u03bd\u03bf\u03c5 \u0391\u03ba\u03c1\u03c9\u03c4\u03b7\u03c1\u03af\u03bf\u03c5" },
            { "cyp", "\u039b\u03af\u03c1\u03b1 \u039a\u03cd\u03c0\u03c1\u03bf\u03c5" },
            { "czk", "\u039a\u03bf\u03c1\u03cc\u03bd\u03b1 \u03a4\u03c3\u03b5\u03c7\u03af\u03b1\u03c2" },
            { "ddm", "\u039f\u03c3\u03c4\u03bc\u03ac\u03c1\u03ba \u0391\u03bd\u03b1\u03c4\u03bf\u03bb\u03b9\u03ba\u03ae\u03c2 \u0393\u03b5\u03c1\u03bc\u03b1\u03bd\u03af\u03b1\u03c2" },
            { "dem", "\u039c\u03ac\u03c1\u03ba\u03bf \u0393\u03b5\u03c1\u03bc\u03b1\u03bd\u03af\u03b1\u03c2" },
            { "djf", "\u03a6\u03c1\u03ac\u03b3\u03ba\u03bf \u03a4\u03b6\u03b9\u03bc\u03c0\u03bf\u03c5\u03c4\u03af" },
            { "dkk", "\u039a\u03bf\u03c1\u03cc\u03bd\u03b1 \u0394\u03b1\u03bd\u03af\u03b1\u03c2" },
            { "dop", "\u03a0\u03ad\u03c3\u03bf \u0394\u03bf\u03bc\u03b9\u03bd\u03b9\u03ba\u03b1\u03bd\u03ae\u03c2 \u0394\u03b7\u03bc\u03bf\u03ba\u03c1\u03b1\u03c4\u03af\u03b1\u03c2" },
            { "dzd", "\u0394\u03b7\u03bd\u03ac\u03c1\u03b9\u03bf \u0391\u03bb\u03b3\u03b5\u03c1\u03af\u03b1\u03c2" },
            { "ecs", "\u03a3\u03bf\u03cd\u03ba\u03c1\u03b5 \u0395\u03ba\u03bf\u03c5\u03b1\u03b4\u03cc\u03c1" },
            { "eek", "\u039a\u03bf\u03c1\u03cc\u03bd\u03b1 \u0395\u03c3\u03b8\u03bf\u03bd\u03af\u03b1\u03c2" },
            { "egp", "\u039b\u03af\u03c1\u03b1 \u0391\u03b9\u03b3\u03cd\u03c0\u03c4\u03bf\u03c5" },
            { "ern", "\u039d\u03ac\u03ba\u03c6\u03b1 \u0395\u03c1\u03c5\u03b8\u03c1\u03b1\u03af\u03b1\u03c2" },
            { "esa", "\u03c0\u03b5\u03c3\u03ad\u03c4\u03b1 \u0399\u03c3\u03c0\u03b1\u03bd\u03af\u03b1\u03c2 (\u03bb\u03bf\u03b3\u03b1\u03c1\u03b9\u03b1\u03c3\u03bc\u03cc\u03c2 \u0391)" },
            { "esb", "\u03c0\u03b5\u03c3\u03ad\u03c4\u03b1 \u0399\u03c3\u03c0\u03b1\u03bd\u03af\u03b1\u03c2 (\u03bc\u03b5\u03c4\u03b1\u03c4\u03c1\u03ad\u03c8\u03b9\u03bc\u03bf\u03c2 \u03bb\u03bf\u03b3\u03b1\u03c1\u03b9\u03b1\u03c3\u03bc\u03cc\u03c2)" },
            { "esp", "\u03a0\u03b5\u03c3\u03ad\u03c4\u03b1 \u0399\u03c3\u03c0\u03b1\u03bd\u03af\u03b1\u03c2" },
            { "etb", "\u039c\u03c0\u03b9\u03c1 \u0391\u03b9\u03b8\u03b9\u03bf\u03c0\u03af\u03b1\u03c2" },
            { "eur", "\u0395\u03c5\u03c1\u03ce" },
            { "fim", "\u039c\u03ac\u03c1\u03ba\u03bf \u03a6\u03b9\u03bd\u03bb\u03b1\u03bd\u03b4\u03af\u03b1\u03c2" },
            { "fjd", "\u0394\u03bf\u03bb\u03ac\u03c1\u03b9\u03bf \u03a6\u03af\u03c4\u03b6\u03b9" },
            { "fkp", "\u039b\u03af\u03c1\u03b1 \u039d\u03ae\u03c3\u03c9\u03bd \u03a6\u03cc\u03ba\u03bb\u03b1\u03bd\u03c4" },
            { "frf", "\u03a6\u03c1\u03ac\u03b3\u03ba\u03bf \u0393\u03b1\u03bb\u03bb\u03af\u03b1\u03c2" },
            { "gbp", "\u039b\u03af\u03c1\u03b1 \u03a3\u03c4\u03b5\u03c1\u03bb\u03af\u03bd\u03b1 \u0392\u03c1\u03b5\u03c4\u03b1\u03bd\u03af\u03b1\u03c2" },
            { "gek", "\u039a\u03bf\u03cd\u03c0\u03bf\u03bd \u039b\u03ac\u03c1\u03b9 \u0393\u03b5\u03c9\u03c1\u03b3\u03af\u03b1\u03c2" },
            { "gel", "\u039b\u03ac\u03c1\u03b9 \u0393\u03b5\u03c9\u03c1\u03b3\u03af\u03b1\u03c2" },
            { "ghc", "\u03a3\u03ad\u03bd\u03c4\u03b9 \u0393\u03ba\u03ac\u03bd\u03b1\u03c2 (1979\u20132007)" },
            { "ghs", "\u03a3\u03ad\u03bd\u03c4\u03b9 \u0393\u03ba\u03ac\u03bd\u03b1\u03c2" },
            { "gip", "\u039b\u03af\u03c1\u03b1 \u0393\u03b9\u03b2\u03c1\u03b1\u03bb\u03c4\u03ac\u03c1" },
            { "gmd", "\u039d\u03c4\u03b1\u03bb\u03ac\u03c3\u03b9 \u0393\u03ba\u03ac\u03bc\u03c0\u03b9\u03b1\u03c2" },
            { "gnf", "\u03a6\u03c1\u03ac\u03b3\u03ba\u03bf \u0393\u03bf\u03c5\u03b9\u03bd\u03ad\u03b1\u03c2" },
            { "gns", "\u03a3\u03c5\u03bb\u03af \u0393\u03bf\u03c5\u03b9\u03bd\u03ad\u03b1\u03c2" },
            { "gqe", "\u0395\u03ba\u03b3\u03bf\u03c5\u03ad\u03bb\u03b5 \u0399\u03c3\u03b7\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae\u03c2 \u0393\u03bf\u03c5\u03b9\u03bd\u03ad\u03b1\u03c2" },
            { "grd", "\u0394\u03c1\u03b1\u03c7\u03bc\u03ae \u0395\u03bb\u03bb\u03ac\u03b4\u03b1\u03c2" },
            { "gtq", "\u039a\u03bf\u03c5\u03b5\u03c4\u03c3\u03ac\u03bb \u0393\u03bf\u03c5\u03b1\u03c4\u03b5\u03bc\u03ac\u03bb\u03b1\u03c2" },
            { "gwe", "\u0393\u03ba\u03b9\u03bd\u03ad\u03b1 \u0395\u03c3\u03ba\u03bf\u03cd\u03b4\u03bf \u03a0\u03bf\u03c1\u03c4\u03bf\u03b3\u03b1\u03bb\u03af\u03b1\u03c2" },
            { "gwp", "\u03a0\u03ad\u03c3\u03bf \u0393\u03bf\u03c5\u03b9\u03bd\u03ad\u03b1\u03c2-\u039c\u03c0\u03b9\u03c3\u03ac\u03bf\u03c5" },
            { "gyd", "\u0394\u03bf\u03bb\u03ac\u03c1\u03b9\u03bf \u0393\u03bf\u03c5\u03b9\u03ac\u03bd\u03b1\u03c2" },
            { "hkd", "\u0394\u03bf\u03bb\u03ac\u03c1\u03b9\u03bf \u03a7\u03bf\u03bd\u03b3\u03ba \u039a\u03bf\u03bd\u03b3\u03ba" },
            { "hnl", "\u039b\u03b5\u03bc\u03c0\u03af\u03c1\u03b1 \u039f\u03bd\u03b4\u03bf\u03cd\u03c1\u03b1\u03c2" },
            { "hrd", "\u0394\u03b7\u03bd\u03ac\u03c1\u03b9\u03bf \u039a\u03c1\u03bf\u03b1\u03c4\u03af\u03b1\u03c2" },
            { "hrk", "\u039a\u03bf\u03cd\u03bd\u03b1 \u039a\u03c1\u03bf\u03b1\u03c4\u03af\u03b1\u03c2" },
            { "htg", "\u0393\u03ba\u03bf\u03c5\u03c1\u03bd\u03c4 \u0391\u03ca\u03c4\u03ae\u03c2" },
            { "huf", "\u03a6\u03b9\u03bf\u03c1\u03af\u03bd\u03b9 \u039f\u03c5\u03b3\u03b3\u03b1\u03c1\u03af\u03b1\u03c2" },
            { "idr", "\u03a1\u03bf\u03c5\u03c0\u03af\u03b1 \u0399\u03bd\u03b4\u03bf\u03bd\u03b7\u03c3\u03af\u03b1\u03c2" },
            { "iep", "\u039b\u03af\u03c1\u03b1 \u0399\u03c1\u03bb\u03b1\u03bd\u03b4\u03af\u03b1\u03c2" },
            { "ilp", "\u039b\u03af\u03c1\u03b1 \u0399\u03c3\u03c1\u03b1\u03ae\u03bb" },
            { "ilr", "\u03c0\u03b1\u03bb\u03b9\u03cc \u03c3\u03b5\u03ba\u03ad\u03bb \u0399\u03c3\u03c1\u03b1\u03ae\u03bb" },
            { "ils", "\u039d\u03ad\u03bf \u03a3\u03ad\u03ba\u03b5\u03bb \u0399\u03c3\u03c1\u03b1\u03ae\u03bb" },
            { "inr", "\u03a1\u03bf\u03c5\u03c0\u03af\u03b1 \u0399\u03bd\u03b4\u03af\u03b1\u03c2" },
            { "iqd", "\u0394\u03b7\u03bd\u03ac\u03c1\u03b9\u03bf \u0399\u03c1\u03ac\u03ba" },
            { "irr", "\u03a1\u03b9\u03ac\u03bb \u0399\u03c1\u03ac\u03bd" },
            { "isj", "\u03a0\u03b1\u03bb\u03b9\u03ac \u03ba\u03bf\u03c1\u03cc\u03bd\u03b1 \u0399\u03c3\u03bb\u03b1\u03bd\u03b4\u03af\u03b1\u03c2" },
            { "isk", "\u039a\u03bf\u03c1\u03cc\u03bd\u03b1 \u0399\u03c3\u03bb\u03b1\u03bd\u03b4\u03af\u03b1\u03c2" },
            { "itl", "\u039b\u03b9\u03c1\u03ad\u03c4\u03b1 \u0399\u03c4\u03b1\u03bb\u03af\u03b1\u03c2" },
            { "jmd", "\u0394\u03bf\u03bb\u03ac\u03c1\u03b9\u03bf \u03a4\u03b6\u03b1\u03bc\u03ac\u03b9\u03ba\u03b1\u03c2" },
            { "jod", "\u0394\u03b7\u03bd\u03ac\u03c1\u03b9\u03bf \u0399\u03bf\u03c1\u03b4\u03b1\u03bd\u03af\u03b1\u03c2" },
            { "jpy", "\u0393\u03b9\u03b5\u03bd \u0399\u03b1\u03c0\u03c9\u03bd\u03af\u03b1\u03c2" },
            { "kes", "\u03a3\u03b5\u03bb\u03af\u03bd\u03b9 \u039a\u03ad\u03bd\u03c5\u03b1\u03c2" },
            { "kgs", "\u03a3\u03bf\u03bc \u039a\u03b9\u03c1\u03b3\u03b9\u03b6\u03af\u03b1\u03c2" },
            { "khr", "\u03a1\u03af\u03b5\u03bb \u039a\u03b1\u03bc\u03c0\u03cc\u03c4\u03b6\u03b7\u03c2" },
            { "kmf", "\u03a6\u03c1\u03ac\u03b3\u03ba\u03bf \u039a\u03bf\u03bc\u03bf\u03c1\u03ce\u03bd" },
            { "kpw", "\u0393\u03bf\u03c5\u03cc\u03bd \u0392\u03cc\u03c1\u03b5\u03b9\u03b1\u03c2 \u039a\u03bf\u03c1\u03ad\u03b1\u03c2" },
            { "krw", "\u0393\u03bf\u03c5\u03cc\u03bd \u039d\u03cc\u03c4\u03b9\u03b1\u03c2 \u039a\u03bf\u03c1\u03ad\u03b1\u03c2" },
            { "kwd", "\u0394\u03b7\u03bd\u03ac\u03c1\u03b9\u03bf \u039a\u03bf\u03c5\u03b2\u03ad\u03b9\u03c4" },
            { "kyd", "\u0394\u03bf\u03bb\u03ac\u03c1\u03b9\u03bf \u039d\u03ae\u03c3\u03c9\u03bd \u039a\u03ad\u03b9\u03bc\u03b1\u03bd" },
            { "kzt", "\u03a4\u03ad\u03bd\u03b3\u03ba\u03b5 \u039a\u03b1\u03b6\u03b1\u03ba\u03c3\u03c4\u03ac\u03bd" },
            { "lak", "\u039a\u03b9\u03c0 \u039b\u03ac\u03bf\u03c2" },
            { "lbp", "\u039b\u03af\u03c1\u03b1 \u039b\u03b9\u03b2\u03ac\u03bd\u03bf\u03c5" },
            { "lkr", "\u03a1\u03bf\u03c5\u03c0\u03af\u03b1 \u03a3\u03c1\u03b9 \u039b\u03ac\u03bd\u03ba\u03b1" },
            { "lrd", "\u0394\u03bf\u03bb\u03ac\u03c1\u03b9\u03bf \u039b\u03b9\u03b2\u03b5\u03c1\u03af\u03b1\u03c2" },
            { "lsl", "\u039b\u03cc\u03c4\u03b9 \u039b\u03b5\u03c3\u03cc\u03c4\u03bf" },
            { "ltl", "\u039b\u03af\u03c4\u03b1 \u039b\u03b9\u03b8\u03bf\u03c5\u03b1\u03bd\u03af\u03b1\u03c2" },
            { "ltt", "\u03a4\u03b1\u03bb\u03cc\u03bd\u03b1\u03c2 \u039b\u03b9\u03b8\u03bf\u03c5\u03b1\u03bd\u03af\u03b1\u03c2" },
            { "luc", "\u039c\u03b5\u03c4\u03b1\u03c4\u03c1\u03ad\u03c8\u03b9\u03bc\u03bf \u03a6\u03c1\u03ac\u03b3\u03ba\u03bf \u039b\u03bf\u03c5\u03be\u03b5\u03bc\u03b2\u03bf\u03cd\u03c1\u03b3\u03bf\u03c5" },
            { "luf", "\u03a6\u03c1\u03ac\u03b3\u03ba\u03bf \u039b\u03bf\u03c5\u03be\u03b5\u03bc\u03b2\u03bf\u03cd\u03c1\u03b3\u03bf\u03c5" },
            { "lul", "\u039f\u03b9\u03ba\u03bf\u03bd\u03bf\u03bc\u03b9\u03ba\u03cc \u03a6\u03c1\u03ac\u03b3\u03ba\u03bf \u039b\u03bf\u03c5\u03be\u03b5\u03bc\u03b2\u03bf\u03cd\u03c1\u03b3\u03bf\u03c5" },
            { "lvl", "\u039b\u03b1\u03c4\u03c2 \u039b\u03b5\u03c4\u03bf\u03bd\u03af\u03b1\u03c2" },
            { "lvr", "\u03a1\u03bf\u03cd\u03b2\u03bb\u03b9 \u039b\u03b5\u03c4\u03bf\u03bd\u03af\u03b1\u03c2" },
            { "lyd", "\u0394\u03b7\u03bd\u03ac\u03c1\u03b9\u03bf \u039b\u03b9\u03b2\u03cd\u03b7\u03c2" },
            { "mad", "\u039d\u03c4\u03b9\u03c1\u03ac\u03bc \u039c\u03b1\u03c1\u03cc\u03ba\u03bf\u03c5" },
            { "maf", "\u03a6\u03c1\u03ac\u03b3\u03ba\u03bf \u039c\u03b1\u03c1\u03cc\u03ba\u03bf\u03c5" },
            { "mdl", "\u039b\u03ad\u03bf\u03c5 \u039c\u03bf\u03bb\u03b4\u03b1\u03b2\u03af\u03b1\u03c2" },
            { "mga", "\u0391\u03c1\u03b9\u03ac\u03c1\u03b9 \u039c\u03b1\u03b4\u03b1\u03b3\u03b1\u03c3\u03ba\u03ac\u03c1\u03b7\u03c2" },
            { "mgf", "\u03a6\u03c1\u03ac\u03b3\u03ba\u03bf \u039c\u03b1\u03b4\u03b1\u03b3\u03b1\u03c3\u03ba\u03ac\u03c1\u03b7\u03c2" },
            { "mkd", "\u0394\u03b7\u03bd\u03ac\u03c1\u03b9\u03bf \u03a0\u0393\u0394\u039c" },
            { "mlf", "\u03a6\u03c1\u03ac\u03b3\u03ba\u03bf \u039c\u03b1\u03bb\u03af" },
            { "mmk", "\u039a\u03b9\u03ac\u03c4 \u039c\u03b9\u03b1\u03bd\u03bc\u03ac\u03c1" },
            { "mnt", "\u03a4\u03bf\u03c5\u03b3\u03ba\u03c1\u03af\u03ba \u039c\u03bf\u03b3\u03b3\u03bf\u03bb\u03af\u03b1\u03c2" },
            { "mop", "\u03a0\u03b1\u03c4\u03ac\u03ba\u03b1 \u039c\u03b1\u03ba\u03ac\u03bf" },
            { "mro", "\u039f\u03c5\u03b3\u03ba\u03af\u03b3\u03b9\u03b1 \u039c\u03b1\u03c5\u03c1\u03b9\u03c4\u03b1\u03bd\u03af\u03b1\u03c2 (1973\u20132017)" },
            { "mru", "\u039f\u03c5\u03b3\u03ba\u03af\u03b3\u03b9\u03b1 \u039c\u03b1\u03c5\u03c1\u03b9\u03c4\u03b1\u03bd\u03af\u03b1\u03c2" },
            { "mtl", "\u039b\u03b9\u03c1\u03ad\u03c4\u03b1 \u039c\u03ac\u03bb\u03c4\u03b1\u03c2" },
            { "mtp", "\u039b\u03af\u03c1\u03b1 \u039c\u03ac\u03bb\u03c4\u03b1\u03c2" },
            { "mur", "\u03a1\u03bf\u03c5\u03c0\u03af\u03b1 \u039c\u03b1\u03c5\u03c1\u03b9\u03ba\u03af\u03bf\u03c5" },
            { "mvr", "\u03a1\u03bf\u03c5\u03c6\u03af\u03b3\u03b9\u03b1 \u039c\u03b1\u03bb\u03b4\u03af\u03b2\u03c9\u03bd" },
            { "mwk", "\u039a\u03bf\u03c5\u03ac\u03c4\u03c3\u03b1 \u039c\u03b1\u03bb\u03ac\u03bf\u03c5\u03b9" },
            { "mxn", "\u03a0\u03ad\u03c3\u03bf \u039c\u03b5\u03be\u03b9\u03ba\u03bf\u03cd" },
            { "mxp", "\u0391\u03c3\u03b7\u03bc\u03ad\u03bd\u03b9\u03bf \u03a0\u03ad\u03c3\u03bf \u039c\u03b5\u03be\u03b9\u03ba\u03bf\u03cd (1861\u20131992)" },
            { "myr", "\u03a1\u03b9\u03bd\u03b3\u03ba\u03af\u03c4 \u039c\u03b1\u03bb\u03b1\u03b9\u03c3\u03af\u03b1\u03c2" },
            { "mze", "\u0395\u03c3\u03ba\u03bf\u03cd\u03b4\u03bf \u039c\u03bf\u03b6\u03b1\u03bc\u03b2\u03af\u03ba\u03b7\u03c2" },
            { "mzm", "\u03a0\u03b1\u03bb\u03b1\u03b9\u03cc \u039c\u03b5\u03c4\u03b9\u03ba\u03ac\u03bb \u039c\u03bf\u03b6\u03b1\u03bc\u03b2\u03af\u03ba\u03b7\u03c2" },
            { "mzn", "\u039c\u03b5\u03c4\u03b9\u03ba\u03ac\u03bb \u039c\u03bf\u03b6\u03b1\u03bc\u03b2\u03af\u03ba\u03b7\u03c2" },
            { "nad", "\u0394\u03bf\u03bb\u03ac\u03c1\u03b9\u03bf \u039d\u03b1\u03bc\u03af\u03bc\u03c0\u03b9\u03b1\u03c2" },
            { "ngn", "\u039d\u03ac\u03b9\u03c1\u03b1 \u039d\u03b9\u03b3\u03b7\u03c1\u03af\u03b1\u03c2" },
            { "nic", "\u039a\u03cc\u03c1\u03b4\u03bf\u03b2\u03b1 \u039d\u03b9\u03ba\u03b1\u03c1\u03ac\u03b3\u03bf\u03c5\u03b1\u03c2" },
            { "nio", "\u03a7\u03c1\u03c5\u03c3\u03ae \u039a\u03cc\u03c1\u03b4\u03bf\u03b2\u03b1 \u039d\u03b9\u03ba\u03b1\u03c1\u03ac\u03b3\u03bf\u03c5\u03b1\u03c2" },
            { "nlg", "\u0393\u03ba\u03af\u03bb\u03bd\u03c4\u03b1 \u039f\u03bb\u03bb\u03b1\u03bd\u03b4\u03af\u03b1\u03c2" },
            { "nok", "\u039a\u03bf\u03c1\u03cc\u03bd\u03b1 \u039d\u03bf\u03c1\u03b2\u03b7\u03b3\u03af\u03b1\u03c2" },
            { "npr", "\u03a1\u03bf\u03c5\u03c0\u03af\u03b1 \u039d\u03b5\u03c0\u03ac\u03bb" },
            { "nzd", "\u0394\u03bf\u03bb\u03ac\u03c1\u03b9\u03bf \u039d\u03ad\u03b1\u03c2 \u0396\u03b7\u03bb\u03b1\u03bd\u03b4\u03af\u03b1\u03c2" },
            { "omr", "\u03a1\u03b9\u03ac\u03bb \u039f\u03bc\u03ac\u03bd" },
            { "pab", "\u039c\u03c0\u03b1\u03bb\u03bc\u03c0\u03cc\u03b1 \u03a0\u03b1\u03bd\u03b1\u03bc\u03ac" },
            { "pei", "\u038a\u03bd\u03c4\u03b9 \u03a0\u03b5\u03c1\u03bf\u03cd" },
            { "pen", "\u03a3\u03bf\u03bb \u03a0\u03b5\u03c1\u03bf\u03cd" },
            { "pes", "\u03a3\u03bf\u03bb \u03a0\u03b5\u03c1\u03bf\u03cd (1863\u20131965)" },
            { "pgk", "\u039a\u03af\u03bd\u03b1 \u03a0\u03b1\u03c0\u03bf\u03cd\u03b1\u03c2 \u039d\u03ad\u03b1\u03c2 \u0393\u03bf\u03c5\u03b9\u03bd\u03ad\u03b1\u03c2" },
            { "php", "\u03a0\u03ad\u03c3\u03bf \u03a6\u03b9\u03bb\u03b9\u03c0\u03c0\u03af\u03bd\u03c9\u03bd" },
            { "pkr", "\u03a1\u03bf\u03c5\u03c0\u03af\u03b1 \u03a0\u03b1\u03ba\u03b9\u03c3\u03c4\u03ac\u03bd" },
            { "pln", "\u0396\u03bb\u03cc\u03c4\u03b9 \u03a0\u03bf\u03bb\u03c9\u03bd\u03af\u03b1\u03c2" },
            { "plz", "\u0396\u03bb\u03cc\u03c4\u03c5 \u03a0\u03bf\u03bb\u03c9\u03bd\u03af\u03b1\u03c2 (1950\u20131995)" },
            { "pte", "\u0395\u03c3\u03ba\u03bf\u03cd\u03b4\u03bf \u03a0\u03bf\u03c1\u03c4\u03bf\u03b3\u03b1\u03bb\u03af\u03b1\u03c2" },
            { "pyg", "\u0393\u03ba\u03bf\u03c5\u03b1\u03c1\u03b1\u03bd\u03af \u03a0\u03b1\u03c1\u03b1\u03b3\u03bf\u03c5\u03ac\u03b7\u03c2" },
            { "qar", "\u03a1\u03b9\u03ac\u03bb \u039a\u03b1\u03c4\u03ac\u03c1" },
            { "rhd", "\u0394\u03bf\u03bb\u03ac\u03c1\u03b9\u03bf \u03a1\u03bf\u03b4\u03b5\u03c3\u03af\u03b1\u03c2" },
            { "rol", "\u039b\u03ad\u03b9 \u03a1\u03bf\u03c5\u03bc\u03b1\u03bd\u03af\u03b1\u03c2" },
            { "ron", "\u039b\u03ad\u03bf\u03c5 \u03a1\u03bf\u03c5\u03bc\u03b1\u03bd\u03af\u03b1\u03c2" },
            { "rsd", "\u0394\u03b7\u03bd\u03ac\u03c1\u03b9\u03bf \u03a3\u03b5\u03c1\u03b2\u03af\u03b1\u03c2" },
            { "rub", "\u03a1\u03bf\u03cd\u03b2\u03bb\u03b9 \u03a1\u03c9\u03c3\u03af\u03b1\u03c2" },
            { "rur", "\u03a1\u03bf\u03cd\u03b2\u03bb\u03b9 \u03a1\u03c9\u03c3\u03af\u03b1\u03c2 (1991\u20131998)" },
            { "rwf", "\u03a6\u03c1\u03ac\u03b3\u03ba\u03bf \u03a1\u03bf\u03c5\u03ac\u03bd\u03c4\u03b1\u03c2" },
            { "sar", "\u03a1\u03b9\u03ac\u03bb \u03a3\u03b1\u03bf\u03c5\u03b4\u03b9\u03ba\u03ae\u03c2 \u0391\u03c1\u03b1\u03b2\u03af\u03b1\u03c2" },
            { "sbd", "\u0394\u03bf\u03bb\u03ac\u03c1\u03b9\u03bf \u039d\u03ae\u03c3\u03c9\u03bd \u03a3\u03bf\u03bb\u03bf\u03bc\u03ce\u03bd\u03c4\u03bf\u03c2" },
            { "scr", "\u03a1\u03bf\u03c5\u03c0\u03af\u03b1 \u03a3\u03b5\u03cb\u03c7\u03b5\u03bb\u03bb\u03ce\u03bd" },
            { "sdd", "\u0394\u03b7\u03bd\u03ac\u03c1\u03b9\u03bf \u03a3\u03bf\u03c5\u03b4\u03ac\u03bd" },
            { "sdg", "\u039b\u03af\u03c1\u03b1 \u03a3\u03bf\u03c5\u03b4\u03ac\u03bd" },
            { "sdp", "\u03a0\u03b1\u03bb\u03b1\u03b9\u03ac \u039b\u03af\u03c1\u03b1 \u03a3\u03bf\u03c5\u03b4\u03ac\u03bd" },
            { "sek", "\u039a\u03bf\u03c1\u03cc\u03bd\u03b1 \u03a3\u03bf\u03c5\u03b7\u03b4\u03af\u03b1\u03c2" },
            { "sgd", "\u0394\u03bf\u03bb\u03ac\u03c1\u03b9\u03bf \u03a3\u03b9\u03b3\u03ba\u03b1\u03c0\u03bf\u03cd\u03c1\u03b7\u03c2" },
            { "shp", "\u039b\u03af\u03c1\u03b1 \u0391\u03b3\u03af\u03b1\u03c2 \u0395\u03bb\u03ad\u03bd\u03b7\u03c2" },
            { "sit", "\u03a4\u03cc\u03bb\u03b1\u03c1 \u03a3\u03bb\u03bf\u03b2\u03b5\u03bd\u03af\u03b1\u03c2" },
            { "skk", "\u039a\u03bf\u03c1\u03cc\u03bd\u03b1 \u03a3\u03bb\u03bf\u03b2\u03b5\u03bd\u03af\u03b1\u03c2" },
            { "sll", "\u039b\u03b5\u03cc\u03bd\u03b5 \u03a3\u03b9\u03ad\u03c1\u03b1 \u039b\u03b5\u03cc\u03bd\u03b5" },
            { "sos", "\u03a3\u03b5\u03bb\u03af\u03bd\u03b9 \u03a3\u03bf\u03bc\u03b1\u03bb\u03af\u03b1\u03c2" },
            { "srd", "\u0394\u03bf\u03bb\u03ac\u03c1\u03b9\u03bf \u03a3\u03bf\u03c5\u03c1\u03b9\u03bd\u03ac\u03bc" },
            { "srg", "\u0393\u03ba\u03af\u03bb\u03bd\u03c4\u03b1 \u03a3\u03bf\u03c5\u03c1\u03b9\u03bd\u03ac\u03bc" },
            { "ssp", "\u039b\u03af\u03c1\u03b1 \u039d\u03cc\u03c4\u03b9\u03bf\u03c5 \u03a3\u03bf\u03c5\u03b4\u03ac\u03bd" },
            { "std", "\u039d\u03c4\u03cc\u03bc\u03c0\u03c1\u03b1 \u03a3\u03ac\u03bf \u03a4\u03bf\u03bc\u03ad \u03ba\u03b1\u03b9 \u03a0\u03c1\u03af\u03bd\u03c3\u03b9\u03c0\u03b5 (1977\u20132017)" },
            { "stn", "\u039d\u03c4\u03cc\u03bc\u03c0\u03c1\u03b1 \u03a3\u03ac\u03bf \u03a4\u03bf\u03bc\u03ad \u03ba\u03b1\u03b9 \u03a0\u03c1\u03af\u03bd\u03c3\u03b9\u03c0\u03b5" },
            { "sur", "\u03a3\u03bf\u03b2\u03b9\u03b5\u03c4\u03b9\u03ba\u03cc \u03a1\u03bf\u03cd\u03b2\u03bb\u03b9" },
            { "svc", "\u039a\u03bf\u03bb\u03cc\u03bd \u0395\u03bb \u03a3\u03b1\u03bb\u03b2\u03b1\u03b4\u03cc\u03c1" },
            { "syp", "\u039b\u03af\u03c1\u03b1 \u03a3\u03c5\u03c1\u03af\u03b1\u03c2" },
            { "szl", "\u039b\u03b9\u03bb\u03b1\u03bd\u03b3\u03ba\u03ad\u03bd\u03b9 \u03a3\u03bf\u03c5\u03b1\u03b6\u03b9\u03bb\u03ac\u03bd\u03b4\u03b7\u03c2" },
            { "thb", "\u039c\u03c0\u03b1\u03c4 \u03a4\u03b1\u03ca\u03bb\u03ac\u03bd\u03b4\u03b7\u03c2" },
            { "tjr", "\u03a1\u03bf\u03cd\u03b2\u03bb\u03b9 \u03a4\u03b1\u03c4\u03b6\u03b9\u03ba\u03b9\u03c3\u03c4\u03ac\u03bd" },
            { "tjs", "\u03a3\u03bf\u03bc\u03cc\u03bd\u03b9 \u03a4\u03b1\u03c4\u03b6\u03b9\u03ba\u03b9\u03c3\u03c4\u03ac\u03bd" },
            { "tmm", "\u039c\u03b1\u03bd\u03ac\u03c4 \u03a4\u03bf\u03c5\u03c1\u03ba\u03bc\u03b5\u03bd\u03b9\u03c3\u03c4\u03ac\u03bd" },
            { "tmt", "\u039c\u03ac\u03bd\u03b1\u03c4 \u03a4\u03bf\u03c5\u03c1\u03ba\u03bc\u03b5\u03bd\u03b9\u03c3\u03c4\u03ac\u03bd" },
            { "tnd", "\u0394\u03b7\u03bd\u03ac\u03c1\u03b9\u03bf \u03a4\u03c5\u03bd\u03b7\u03c3\u03af\u03b1\u03c2" },
            { "top", "\u03a0\u03b1\u03ac\u03b3\u03ba\u03b1 \u03a4\u03cc\u03bd\u03b3\u03ba\u03b1" },
            { "tpe", "\u0395\u03c3\u03ba\u03bf\u03cd\u03b4\u03bf \u03a4\u03b9\u03bc\u03cc\u03c1" },
            { "trl", "\u03a0\u03b1\u03bb\u03b9\u03ac \u039b\u03af\u03c1\u03b1 \u03a4\u03bf\u03c5\u03c1\u03ba\u03af\u03b1\u03c2" },
            { "try", "\u039b\u03af\u03c1\u03b1 \u03a4\u03bf\u03c5\u03c1\u03ba\u03af\u03b1\u03c2" },
            { "ttd", "\u0394\u03bf\u03bb\u03ac\u03c1\u03b9\u03bf \u03a4\u03c1\u03b9\u03bd\u03b9\u03bd\u03c4\u03ac\u03bd\u03c4 \u03ba\u03b1\u03b9 \u03a4\u03bf\u03bc\u03c0\u03ac\u03b3\u03ba\u03bf" },
            { "twd", "\u039d\u03ad\u03bf \u03b4\u03bf\u03bb\u03ac\u03c1\u03b9\u03bf \u03a4\u03b1\u03ca\u03b2\u03ac\u03bd" },
            { "tzs", "\u03a3\u03b5\u03bb\u03af\u03bd\u03b9 \u03a4\u03b1\u03bd\u03b6\u03b1\u03bd\u03af\u03b1\u03c2" },
            { "uah", "\u0393\u03c1\u03af\u03b2\u03bd\u03b1 \u039f\u03c5\u03ba\u03c1\u03b1\u03bd\u03af\u03b1\u03c2" },
            { "uak", "\u039a\u03b1\u03c1\u03bc\u03c0\u03bf\u03b2\u03b1\u03bd\u03ad\u03c4\u03c2 \u039f\u03c5\u03ba\u03c1\u03b1\u03bd\u03af\u03b1\u03c2" },
            { "ugs", "\u03a3\u03b5\u03bb\u03af\u03bd\u03b9 \u039f\u03c5\u03b3\u03ba\u03ac\u03bd\u03c4\u03b1\u03c2 (1966\u20131987)" },
            { "ugx", "\u03a3\u03b5\u03bb\u03af\u03bd\u03b9 \u039f\u03c5\u03b3\u03ba\u03ac\u03bd\u03c4\u03b1\u03c2" },
            { "usd", "\u0394\u03bf\u03bb\u03ac\u03c1\u03b9\u03bf \u0397\u03a0\u0391" },
            { "usn", "\u0394\u03bf\u03bb\u03ac\u03c1\u03b9\u03bf \u0397\u03a0\u0391 (\u03b5\u03c0\u03cc\u03bc\u03b5\u03bd\u03b7 \u03b7\u03bc\u03ad\u03c1\u03b1)" },
            { "uss", "\u0394\u03bf\u03bb\u03ac\u03c1\u03b9\u03bf \u0397\u03a0\u0391 (\u03af\u03b4\u03b9\u03b1 \u03b7\u03bc\u03ad\u03c1\u03b1)" },
            { "uyp", "\u03a0\u03ad\u03c3\u03bf \u039f\u03c5\u03c1\u03bf\u03c5\u03b3\u03bf\u03c5\u03ac\u03b7\u03c2 (1975\u20131993)" },
            { "uyu", "\u03a0\u03ad\u03c3\u03bf \u039f\u03c5\u03c1\u03bf\u03c5\u03b3\u03bf\u03c5\u03ac\u03b7\u03c2" },
            { "uzs", "\u03a3\u03bf\u03bc \u039f\u03c5\u03b6\u03bc\u03c0\u03b5\u03ba\u03b9\u03c3\u03c4\u03ac\u03bd" },
            { "veb", "\u039c\u03c0\u03bf\u03bb\u03b9\u03b2\u03ac\u03c1 \u0392\u03b5\u03bd\u03b5\u03b6\u03bf\u03c5\u03ad\u03bb\u03b1\u03c2 (1871\u20132008)" },
            { "vef", "\u039c\u03c0\u03bf\u03bb\u03b9\u03b2\u03ac\u03c1 \u0392\u03b5\u03bd\u03b5\u03b6\u03bf\u03c5\u03ad\u03bb\u03b1\u03c2" },
            { "vnd", "\u039d\u03c4\u03bf\u03bd\u03b3\u03ba \u0392\u03b9\u03b5\u03c4\u03bd\u03ac\u03bc" },
            { "vuv", "\u0392\u03b1\u03c4\u03bf\u03cd \u0392\u03b1\u03bd\u03bf\u03c5\u03ac\u03c4\u03bf\u03c5" },
            { "wst", "\u03a4\u03ac\u03bb\u03b1 \u03a3\u03b1\u03bc\u03cc\u03b1" },
            { "xaf", "\u03a6\u03c1\u03ac\u03b3\u03ba\u03bf CFA \u039a\u03b5\u03bd\u03c4\u03c1\u03b9\u03ba\u03ae\u03c2 \u0391\u03c6\u03c1\u03b9\u03ba\u03ae\u03c2" },
            { "xba", "\u0395\u03c5\u03c1\u03c9\u03c0\u03b1\u03ca\u03ba\u03ae \u03a3\u03cd\u03bd\u03b8\u03b5\u03c4\u03b7 \u039c\u03bf\u03bd\u03ac\u03b4\u03b1" },
            { "xbb", "\u0395\u03c5\u03c1\u03c9\u03c0\u03b1\u03ca\u03ba\u03ae \u039d\u03bf\u03bc\u03b9\u03c3\u03bc\u03b1\u03c4\u03b9\u03ba\u03ae \u039c\u03bf\u03bd\u03ac\u03b4\u03b1" },
            { "xbc", "\u0395\u03c5\u03c1\u03c9\u03c0\u03b1\u03ca\u03ba\u03ae \u03bc\u03bf\u03bd\u03ac\u03b4\u03b1 \u03bb\u03bf\u03b3\u03b1\u03c1\u03b9\u03b1\u03c3\u03bc\u03bf\u03cd (XBC)" },
            { "xbd", "\u0395\u03c5\u03c1\u03c9\u03c0\u03b1\u03ca\u03ba\u03ae \u03bc\u03bf\u03bd\u03ac\u03b4\u03b1 \u03bb\u03bf\u03b3\u03b1\u03c1\u03b9\u03b1\u03c3\u03bc\u03bf\u03cd (XBD)" },
            { "xcd", "\u0394\u03bf\u03bb\u03ac\u03c1\u03b9\u03bf \u0391\u03bd\u03b1\u03c4\u03bf\u03bb\u03b9\u03ba\u03ae\u03c2 \u039a\u03b1\u03c1\u03b1\u03ca\u03b2\u03b9\u03ba\u03ae\u03c2" },
            { "xdr", "\u0395\u03b9\u03b4\u03b9\u03ba\u03ac \u0394\u03b9\u03ba\u03b1\u03b9\u03ce\u03bc\u03b1\u03c4\u03b1 \u0391\u03bd\u03ac\u03bb\u03b7\u03c8\u03b7\u03c2" },
            { "xeu", "\u0395\u03c5\u03c1\u03c9\u03c0\u03b1\u03ca\u03ba\u03ae \u03a3\u03c5\u03bd\u03b1\u03bb\u03bb\u03b1\u03b3\u03bc\u03b1\u03c4\u03b9\u03ba\u03ae \u039c\u03bf\u03bd\u03ac\u03b4\u03b1" },
            { "xfo", "\u03a7\u03c1\u03c5\u03c3\u03cc \u03a6\u03c1\u03ac\u03b3\u03ba\u03bf \u0393\u03b1\u03bb\u03bb\u03af\u03b1\u03c2" },
            { "xfu", "UIC-\u03a6\u03c1\u03ac\u03b3\u03ba\u03bf \u0393\u03b1\u03bb\u03bb\u03af\u03b1\u03c2" },
            { "xof", "\u03a6\u03c1\u03ac\u03b3\u03ba\u03bf CFA \u0394\u03c5\u03c4\u03b9\u03ba\u03ae\u03c2 \u0391\u03c6\u03c1\u03b9\u03ba\u03ae\u03c2" },
            { "xpf", "\u03a6\u03c1\u03ac\u03b3\u03ba\u03bf CFP" },
            { "xxx", "\u0386\u03b3\u03bd\u03c9\u03c3\u03c4\u03bf \u03bd\u03cc\u03bc\u03b9\u03c3\u03bc\u03b1" },
            { "ydd", "\u0394\u03b7\u03bd\u03ac\u03c1\u03b9\u03bf \u03a5\u03b5\u03bc\u03ad\u03bd\u03b7\u03c2" },
            { "yer", "\u03a1\u03b9\u03ac\u03bb \u03a5\u03b5\u03bc\u03ad\u03bd\u03b7\u03c2" },
            { "yud", "\u039c\u03b5\u03c4\u03b1\u03bb\u03bb\u03b9\u03ba\u03cc \u0394\u03b7\u03bd\u03ac\u03c1\u03b9\u03bf \u0393\u03b9\u03bf\u03c5\u03b3\u03ba\u03bf\u03c3\u03bb\u03b1\u03b2\u03af\u03b1\u03c2" },
            { "yum", "\u039d\u03ad\u03bf \u0394\u03b7\u03bd\u03ac\u03c1\u03b9\u03bf \u0393\u03b9\u03bf\u03c5\u03b3\u03ba\u03bf\u03c3\u03bb\u03b1\u03b2\u03af\u03b1\u03c2" },
            { "yun", "\u039c\u03b5\u03c4\u03b1\u03c4\u03c1\u03ad\u03c8\u03b9\u03bc\u03bf \u0394\u03b7\u03bd\u03ac\u03c1\u03b9\u03bf \u0393\u03b9\u03bf\u03c5\u03b3\u03ba\u03bf\u03c3\u03bb\u03b1\u03b2\u03af\u03b1\u03c2" },
            { "zal", "\u03a1\u03b1\u03bd\u03c4 \u039d\u03cc\u03c4\u03b9\u03b1\u03c2 \u0391\u03c6\u03c1\u03b9\u03ba\u03ae\u03c2 (\u03bf\u03b9\u03ba\u03bf\u03bd\u03bf\u03bc\u03b9\u03ba\u03cc)" },
            { "zar", "\u03a1\u03b1\u03bd\u03c4 \u039d\u03cc\u03c4\u03b9\u03b1\u03c2 \u0391\u03c6\u03c1\u03b9\u03ba\u03ae\u03c2" },
            { "zmk", "\u039a\u03bf\u03c5\u03ac\u03bd\u03b6\u03b1 \u0396\u03b1\u0390\u03c1 (1968\u20132012)" },
            { "zmw", "\u039a\u03bf\u03c5\u03ac\u03c4\u03c3\u03b1 \u0396\u03ac\u03bc\u03c0\u03b9\u03b1\u03c2" },
            { "zrn", "\u039d\u03ad\u03bf \u0396\u03b1\u0390\u03c1 \u0396\u03b1\u0390\u03c1" },
            { "zrz", "\u0396\u03b1\u0390\u03c1 \u0396\u03b1\u0390\u03c1" },
            { "zwd", "\u0394\u03bf\u03bb\u03ac\u03c1\u03b9\u03bf \u0396\u03b9\u03bc\u03c0\u03ac\u03bc\u03c0\u03bf\u03c5\u03b5" },
            { "zwl", "\u0394\u03bf\u03bb\u03ac\u03c1\u03b9\u03bf \u0396\u03b9\u03bc\u03c0\u03ac\u03bc\u03c0\u03bf\u03c5\u03b5 (2009)" },
        };
        return data;
    }
}
