/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.websocket.spec.application.closing;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.websocket.common.client.WebSocketCommonClient;
import com.sun.ts.tests.websocket.common.util.IOUtil;
import com.sun.ts.tests.websocket.spec.application.closing.WSCCloseSessionServer;
import java.io.IOException;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class WSCClientIT
extends WebSocketCommonClient {
    private static final long serialVersionUID = 3037319902828702665L;

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"wsc_spec_application_closing_web.war");
        archive.addClasses(new Class[]{WSCCloseSessionServer.class});
        archive.addClasses(new Class[]{IOUtil.class});
        return archive;
    }

    public WSCClientIT() throws Exception {
        this.setContextRoot("wsc_spec_application_closing_web");
    }

    @Test
    public void connectionHasBeenClosedWithStatus1006AfterTimeoutTest() throws Exception {
        boolean closed = false;
        String[] messages = WSCCloseSessionServer.MESSAGES;
        this.logExceptionOnInvocation(false);
        try {
            this.invoke("closesession", (Object)messages[0], messages[0], false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.logExceptionOnInvocation(false);
            TestUtil.sleepSec((int)5);
            this.invokeAgain("ok", "ok", true);
        }
        catch (Exception e) {
            closed = true;
            WSCClientIT.logTrace("Connection has been closed as expected:", WSCClientIT.getCauseMessage(e));
        }
        WSCClientIT.assertTrue(closed, "The connection has not been closed");
        this.invoke("closesession", (Object)messages[1], "1006");
        WSCClientIT.logMsg("After invalidation of HTTP session, connection has been closed with expected status 1006");
    }
}

