/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.websocket.ee.jakarta.websocket.remoteendpoint.usercoder;

import com.sun.ts.tests.websocket.common.util.IOUtil;
import jakarta.websocket.MessageHandler;
import jakarta.websocket.OnError;
import jakarta.websocket.OnMessage;
import jakarta.websocket.OnOpen;
import jakarta.websocket.Session;
import jakarta.websocket.server.ServerEndpoint;
import java.io.IOException;
import java.nio.ByteBuffer;

@ServerEndpoint(value="/echo")
public class WSCEchoServer
implements MessageHandler.Whole<ByteBuffer> {
    private static final System.Logger logger = System.getLogger(WSCEchoServer.class.getName());
    Session session;

    @OnOpen
    public void onOpen(Session session) {
        session.addMessageHandler((MessageHandler)this);
        this.session = session;
    }

    @OnMessage
    public String onMessage(String msg) {
        return msg;
    }

    @OnError
    public void onError(Session session, Throwable t) throws IOException {
        logger.log(System.Logger.Level.INFO, "@OnError in " + this.getClass().getName());
        t.printStackTrace();
        String message = "Exception: " + IOUtil.printStackTrace(t);
        session.getBasicRemote().sendText(message);
    }

    public void onMessage(ByteBuffer message) {
        try {
            this.session.getBasicRemote().sendText(IOUtil.byteBufferToString(message));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

