/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.websocket.api.jakarta.websocket.closereason;

import jakarta.websocket.CloseReason;
import org.junit.jupiter.api.Test;

public class WSClientIT {
    private static final System.Logger logger = System.getLogger(WSClientIT.class.getName());
    final CloseReason.CloseCodes[] codes = new CloseReason.CloseCodes[]{CloseReason.CloseCodes.CANNOT_ACCEPT, CloseReason.CloseCodes.CLOSED_ABNORMALLY, CloseReason.CloseCodes.GOING_AWAY, CloseReason.CloseCodes.NORMAL_CLOSURE, CloseReason.CloseCodes.NOT_CONSISTENT, CloseReason.CloseCodes.NO_EXTENSION, CloseReason.CloseCodes.NO_STATUS_CODE, CloseReason.CloseCodes.PROTOCOL_ERROR, CloseReason.CloseCodes.RESERVED, CloseReason.CloseCodes.SERVICE_RESTART, CloseReason.CloseCodes.TLS_HANDSHAKE_FAILURE, CloseReason.CloseCodes.TOO_BIG, CloseReason.CloseCodes.TRY_AGAIN_LATER, CloseReason.CloseCodes.UNEXPECTED_CONDITION, CloseReason.CloseCodes.VIOLATED_POLICY};
    final String[] codes_string = new String[]{"CANNOT_ACCEPT", "CLOSED_ABNORMALLY", "GOING_AWAY", "NORMAL_CLOSURE", "NOT_CONSISTENT", "NO_EXTENSION", "NO_STATUS_CODE", "PROTOCOL_ERROR", "RESERVED", "SERVICE_RESTART", "TLS_HANDSHAKE_FAILURE", "TOO_BIG", "TRY_AGAIN_LATER", "UNEXPECTED_CONDITION", "VIOLATED_POLICY"};
    final int[] codes_number = new int[]{1003, 1006, 1001, 1000, 1007, 1010, 1005, 1002, 1004, 1012, 1015, 1009, 1013, 1011, 1008};
    final String[] tck_codes_reason = new String[]{"TCK_CANNOT_ACCEPT", "TCK_CLOSED_ABNORMALLY", "TCK_GOING_AWAY", "TCK_NORMAL_CLOSURE", "TCK_NOT_CONSISTENT", "TCK_NO_EXTENSION", "TCK_NO_STATUS_CODE", "TCK_PROTOCOL_ERROR", "TCK_RESERVED", "TCK_SERVICE_RESTART", "TCK_TLS_HANDSHAKE_FAILURE", "TCK_TOO_BIG", "TCK_TRY_AGAIN_LATER", "TCK_UNEXPECTED_CONDITION", "TCK_VIOLATED_POLICY"};

    @Test
    public void getCodeTest() throws Exception {
        boolean passed = true;
        int size = this.codes_number.length;
        for (int i = 0; i < size; ++i) {
            if (this.codes[i].getCode() == this.codes_number[i]) continue;
            passed = false;
            logger.log(System.Logger.Level.ERROR, "Expecting CloseCodes' number " + this.codes_number[i] + "; got " + this.codes[i].getCode());
        }
        if (!passed) {
            throw new Exception("Test failed");
        }
    }

    @Test
    public void getCodeTest1() throws Exception {
        boolean passed = true;
        int size = this.codes_number.length;
        for (int i = 0; i < size; ++i) {
            if (this.codes[i].getCode() == this.codes_number[i]) continue;
            passed = false;
            logger.log(System.Logger.Level.ERROR, "Expecting CloseCode' number " + this.codes_number[i] + "; got " + this.codes[i].getCode());
        }
        if (!passed) {
            throw new Exception("Test failed");
        }
    }

    @Test
    public void valueOfTest() throws Exception {
        boolean passed = true;
        int size = this.codes_number.length;
        for (int i = 0; i < size; ++i) {
            if (CloseReason.CloseCodes.valueOf((String)this.codes_string[i]).equals((Object)this.codes[i])) continue;
            passed = false;
            logger.log(System.Logger.Level.ERROR, "Expecting CloseCodes " + this.codes[i] + "; got " + CloseReason.CloseCodes.valueOf((String)this.codes_string[i]));
        }
        if (!passed) {
            throw new Exception("Test failed");
        }
    }

    @Test
    public void valuesTest() throws Exception {
        int i;
        boolean passed = true;
        CloseReason.CloseCodes[] close_codes = CloseReason.CloseCodes.values();
        int size = close_codes.length;
        boolean[] passed_array = new boolean[size];
        for (i = 0; i < size; ++i) {
            passed_array[i] = false;
            for (int j = 0; j < size && !close_codes[i].equals((Object)this.codes[j]); ++j) {
            }
            passed_array[i] = true;
            logger.log(System.Logger.Level.INFO, "Expected CloseCodes " + this.codes[i] + " returned");
            logger.log(System.Logger.Level.INFO, "Expected CloseCodes " + this.codes[i] + " returned");
        }
        for (i = 0; i < size; ++i) {
            if (passed_array[i]) continue;
            passed = false;
        }
        if (!passed) {
            throw new Exception("Test failed");
        }
    }

    @Test
    public void constructorTest() throws Exception {
        boolean passed = true;
        int size = this.codes_number.length;
        for (int i = 0; i < size; ++i) {
            CloseReason closereason = new CloseReason((CloseReason.CloseCode)this.codes[i], this.tck_codes_reason[i]);
            if (!closereason.getCloseCode().equals(this.codes[i])) {
                passed = false;
                logger.log(System.Logger.Level.ERROR, "Expected CloseCodes " + this.codes[i] + ", returned" + closereason.getCloseCode());
            }
            if (closereason.getReasonPhrase().equals(this.tck_codes_reason[i])) continue;
            passed = false;
            logger.log(System.Logger.Level.ERROR, "Expected reason phrase " + this.tck_codes_reason[i] + ", returned" + closereason.getReasonPhrase());
        }
        if (!passed) {
            throw new Exception("Test failed");
        }
    }

    @Test
    public void getCloseCodeTest() throws Exception {
        boolean passed = true;
        int size = this.codes_number.length;
        for (int i = 0; i < size; ++i) {
            CloseReason.CloseCode tmp = CloseReason.CloseCodes.getCloseCode((int)this.codes_number[i]);
            if (tmp.equals(this.codes[i])) continue;
            passed = false;
            logger.log(System.Logger.Level.ERROR, "Expected CloseCode " + this.codes[i] + ", returned" + tmp);
        }
        if (!passed) {
            throw new Exception("Test failed");
        }
    }

    public void cleanup() {
    }
}

