/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.relationship.unionexone;

import com.sun.ts.lib.harness.Status;
import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.relationship.unionexone.Uni1X1Person;
import ee.jakarta.tck.persistence.core.relationship.unionexone.Uni1X1Project;
import java.util.Properties;

public class Client
extends PMClientBase {
    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        this.logTrace("setup");
        try {
            super.setup(args, p);
            this.removeTestData();
        }
        catch (Exception e) {
            this.logErr("Exception: ", e);
            throw new Exception("Setup failed:", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uni1X1Test1() throws Exception {
        this.logTrace("Begin uni1X1Test1");
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            Uni1X1Project project = new Uni1X1Project(1L, "JavaEE", 500.0f);
            Uni1X1Person person = new Uni1X1Person(1L, "Duke");
            person.setProject(project);
            this.getEntityManager().persist((Object)person);
            this.logTrace("persisted Person and Project");
            Uni1X1Person newPerson = (Uni1X1Person)this.getEntityManager().find(Uni1X1Person.class, (Object)1L);
            if (newPerson.getProject().getName().equals("JavaEE")) {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in rollback:", re);
            }
        }
        if (!pass) {
            throw new Exception("uni1X1Test1 failed");
        }
    }

    public void cleanup() throws Exception {
        this.logTrace("cleanup");
        this.removeTestData();
        this.logTrace("cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        this.logTrace("removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM UNI1X1PERSON").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM UNI1X1PROJECT").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Exception encountered while removing entities:", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in removeTestData:", re);
            }
        }
    }
}

