/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.markup.gen.files;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.mylyn.docs.intent.markup.builder.operation.DocumentAggregator;
import org.eclipse.mylyn.docs.intent.markup.gen.files.Html;
import org.eclipse.mylyn.docs.intent.markup.markup.Document;
import org.eclipse.mylyn.docs.intent.markup.markup.MarkupPackage;
import org.eclipse.mylyn.docs.intent.markup.resource.wikimedia.WikimediaResourceFactory;
import org.eclipse.mylyn.docs.intent.markup.wikigen.WikigenPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WikiGen {
    private WikiGen() {
    }

    public static void main(String[] args) {
        try {
            if (args.length < 2) {
                System.out.println("Arguments not valid : {folder, uri1 uri2 ...}.");
            } else if (args.length >= 2) {
                Authenticator.setDefault(new Authenticator(){

                    protected PasswordAuthentication getPasswordAuthentication() {
                        return new PasswordAuthentication("login", "password".toCharArray());
                    }
                });
                ResourceSetImpl set = new ResourceSetImpl();
                set.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new WikimediaResourceFactory());
                List<Document> docPassedByArg = WikiGen.getDocsToGenerate(args, (ResourceSet)set);
                Document docToGenerate = null;
                if (docPassedByArg.size() > 1) {
                    DocumentAggregator merger = new DocumentAggregator(docPassedByArg);
                    docToGenerate = merger.merge();
                    Resource newRes = set.createResource(URI.createURI((String)"http://wiki.eclipse.org/index"));
                    newRes.getContents().add((Object)docToGenerate);
                } else {
                    docToGenerate = docPassedByArg.get(0);
                }
                File folder = new File(args[0]);
                ArrayList<String> arguments = new ArrayList<String>();
                int i = 2;
                while (i < args.length) {
                    arguments.add(args[i]);
                    ++i;
                }
                Html generator = new Html((EObject)docToGenerate, folder, (List)Lists.newArrayList()){

                    public void registerResourceFactories(ResourceSet set) {
                        super.registerResourceFactories(set);
                        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("*", new WikimediaResourceFactory());
                        set.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new WikimediaResourceFactory());
                    }

                    public void registerPackages(ResourceSet resourceSet) {
                        super.registerPackages(resourceSet);
                        resourceSet.getPackageRegistry().put((Object)"http://www.eclipse.org/intent/markup/0.7", (Object)MarkupPackage.eINSTANCE);
                        resourceSet.getPackageRegistry().put((Object)"http://www.eclipse.org/intent/markup/generator/0.7", (Object)WikigenPackage.eINSTANCE);
                    }
                };
                generator.doGenerate((Monitor)new BasicMonitor.Printing(System.out));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static List<Document> getDocsToGenerate(String[] args, ResourceSet set) {
        ArrayList result = Lists.newArrayList();
        int i = 1;
        while (i < args.length) {
            URI uri = URI.createURI((String)args[i]);
            System.out.println("Getting:" + uri);
            Resource res = set.getResource(uri, true);
            result.addAll(Lists.newArrayList((Iterable)Iterables.filter((Iterable)res.getContents(), Document.class)));
            ++i;
        }
        return result;
    }
}

