/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.collab.common.internal.logger;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.mylyn.docs.intent.collab.common.logger.IIntentLogger;
import org.eclipse.mylyn.docs.intent.collab.common.logger.IntentLogger;

public class IntentLoggerDescriptor {
    public static final String LOGGER_CLASS_NAME = "class";
    private final IConfigurationElement element;
    private String extensionClassName;
    private IIntentLogger extension;

    public IntentLoggerDescriptor(IConfigurationElement configuration) {
        this.element = configuration;
        this.extensionClassName = configuration.getAttribute(LOGGER_CLASS_NAME);
    }

    public IIntentLogger createLogger() {
        try {
            this.extension = (IIntentLogger)this.element.createExecutableExtension(LOGGER_CLASS_NAME);
        }
        catch (CoreException e) {
            IntentLogger.getInstance().log(IIntentLogger.LogType.ERROR, "Could not create logger " + this.extensionClassName, e);
        }
        return this.extension;
    }

    public String getExtensionClassName() {
        return this.extensionClassName;
    }
}

