/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.client.compiler;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.mylyn.docs.intent.client.compiler.errors.AbstractRuntimeCompilationException;
import org.eclipse.mylyn.docs.intent.client.compiler.errors.CompilationErrorType;
import org.eclipse.mylyn.docs.intent.client.compiler.errors.CompilationException;
import org.eclipse.mylyn.docs.intent.client.compiler.errors.InvalidReferenceException;
import org.eclipse.mylyn.docs.intent.client.compiler.errors.InvalidValueException;
import org.eclipse.mylyn.docs.intent.client.compiler.errors.PackageNotFoundResolveException;
import org.eclipse.mylyn.docs.intent.client.compiler.errors.PackageRegistrationException;
import org.eclipse.mylyn.docs.intent.client.compiler.errors.ResolveException;
import org.eclipse.mylyn.docs.intent.client.compiler.generator.modelgeneration.ModelingUnitGenerator;
import org.eclipse.mylyn.docs.intent.client.compiler.generator.modelgeneration.StructuralFeatureGenerator;
import org.eclipse.mylyn.docs.intent.client.compiler.generator.modellinking.ModelingUnitLinkResolver;
import org.eclipse.mylyn.docs.intent.client.compiler.utils.IntentCompilerInformationHolder;
import org.eclipse.mylyn.docs.intent.client.compiler.validator.GeneratedElementValidator;
import org.eclipse.mylyn.docs.intent.collab.repository.Repository;
import org.eclipse.mylyn.docs.intent.collab.repository.RepositoryConnectionException;
import org.eclipse.mylyn.docs.intent.core.compiler.UnresolvedContributionHolder;
import org.eclipse.mylyn.docs.intent.core.compiler.UnresolvedReferenceHolder;
import org.eclipse.mylyn.docs.intent.core.genericunit.UnitInstruction;
import org.eclipse.mylyn.docs.intent.core.modelingunit.ModelingUnit;
import org.eclipse.mylyn.docs.intent.core.modelingunit.ModelingUnitInstructionReference;
import org.eclipse.mylyn.docs.intent.core.modelingunit.ResourceDeclaration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelingUnitCompiler {
    private static final boolean EPACKAGE_DECLARATION_ONLY = true;
    private static final boolean ALL_MODELING_UNITS_EXCEPT_EPACKAGES_DECLARATION = false;
    private final ModelingUnitGenerator modelingUnitGenerator;
    private final IntentCompilerInformationHolder informationHolder;
    private final ModelingUnitLinkResolver linkResolver;
    private Repository repository;
    private Monitor progressMonitor;

    public ModelingUnitCompiler(Repository repository, ModelingUnitLinkResolver linkResolver, IntentCompilerInformationHolder informationHolder, Monitor progressMonitor) {
        this.repository = repository;
        this.informationHolder = informationHolder;
        this.modelingUnitGenerator = new ModelingUnitGenerator(linkResolver, informationHolder, progressMonitor);
        this.linkResolver = linkResolver;
        this.progressMonitor = progressMonitor;
    }

    public IntentCompilerInformationHolder compile(List<ModelingUnit> modelingUnits) {
        if (!this.progressMonitor.isCanceled()) {
            this.informationHolder.initialize();
        }
        if (!this.progressMonitor.isCanceled()) {
            this.compileAllWithMode(modelingUnits, true);
        }
        if (!this.progressMonitor.isCanceled()) {
            this.compileAllWithMode(modelingUnits, false);
        }
        if (!this.progressMonitor.isCanceled()) {
            for (String unresolvedName : this.informationHolder.getAllUnresolvedContributionsNames()) {
                for (UnresolvedContributionHolder unresolvedContributionHolder : this.informationHolder.getUnresolvedContributions(unresolvedName)) {
                    if (unresolvedContributionHolder.isResolved()) continue;
                    this.informationHolder.registerCompilationExceptionAsCompilationStatus(new CompilationException((UnitInstruction)unresolvedContributionHolder.getReferencedContribution(), CompilationErrorType.INVALID_REFRENCE_ERROR, "The element " + unresolvedName + " cannot be resolved. This contribution instruction will be ignored. "));
                }
            }
        }
        return IntentCompilerInformationHolder.getInstance();
    }

    protected void compileAllWithMode(List<ModelingUnit> modelingUnits, boolean generateOnlyEPackages) {
        this.modelingUnitGenerator.clearResourceDeclarations();
        for (ModelingUnit modelingUnitToCompile : modelingUnits) {
            if (this.progressMonitor.isCanceled()) continue;
            this.compileModelingUnit(modelingUnitToCompile, generateOnlyEPackages);
        }
        if (!this.progressMonitor.isCanceled()) {
            this.resolveLinks();
        }
        if (!this.progressMonitor.isCanceled()) {
            this.mapResourceDeclarationToGeneratedObjects();
        }
        if (!this.progressMonitor.isCanceled()) {
            this.validateGeneratedElement();
        }
    }

    protected void mapResourceDeclarationToGeneratedObjects() {
        List<ResourceDeclaration> resourcesDeclarations = this.modelingUnitGenerator.getResourceDeclarations();
        for (ResourceDeclaration resource : resourcesDeclarations) {
            if (resource.getContent().isEmpty()) {
                this.informationHolder.addResource(resource);
            }
            for (ModelingUnitInstructionReference newContainedElementRefrence : resource.getContent()) {
                try {
                    EObject newContainedElement = this.linkResolver.resolveReferenceinElementList((UnitInstruction)resource, null, newContainedElementRefrence.getIntentHref());
                    this.informationHolder.addResourceToGeneratedElementMapping(resource, newContainedElement);
                }
                catch (InvalidReferenceException e) {
                    this.informationHolder.registerCompilationExceptionAsCompilationStatus(new CompilationException((UnitInstruction)resource, CompilationErrorType.INVALID_REFRENCE_ERROR, e.getMessage()));
                }
            }
        }
    }

    protected List<EObject> compileModelingUnit(ModelingUnit modelingUnitToCompile, boolean generateOnlyEPackages) {
        ArrayList<EObject> generatedObjects = new ArrayList<EObject>();
        AbstractRuntimeCompilationException thrownException = null;
        CompilationErrorType compilationErrorType = null;
        this.informationHolder.setCurrentImportedPackages(this.getImportedPackages(modelingUnitToCompile, generateOnlyEPackages));
        try {
            this.modelingUnitGenerator.setGenerateOnlyEPackages(generateOnlyEPackages);
            this.modelingUnitGenerator.generate(modelingUnitToCompile);
            return generatedObjects;
        }
        catch (ResolveException e) {
            thrownException = e;
        }
        catch (PackageNotFoundResolveException e) {
            thrownException = e;
            compilationErrorType = CompilationErrorType.PACKAGE_NOT_FOUND_ERROR;
        }
        catch (PackageRegistrationException e) {
            thrownException = e;
            compilationErrorType = CompilationErrorType.PACKAGE_REGISTRATION_ERROR;
        }
        catch (InvalidReferenceException e) {
            thrownException = e;
            compilationErrorType = CompilationErrorType.INVALID_REFRENCE_ERROR;
        }
        catch (InvalidValueException e) {
            thrownException = e;
            compilationErrorType = CompilationErrorType.INVALID_VALUE_ERROR;
        }
        CompilationException compilationException = new CompilationException(thrownException.getInvalidInstruction(), compilationErrorType, thrownException.getMessage());
        compilationException.setStackTrace(thrownException.getStackTrace());
        return generatedObjects;
    }

    @Deprecated
    protected List<String> getImportedPackages(ModelingUnit modelingUnitToCompile, boolean generateOnlyEPackages) {
        ArrayList<String> importedPackages = new ArrayList<String>();
        try {
            importedPackages.add(EcorePackage.eINSTANCE.getNsURI());
            for (String ePackage : this.repository.getPackageRegistry().keySet()) {
                importedPackages.add(ePackage);
            }
        }
        catch (RepositoryConnectionException repositoryConnectionException) {}
        return importedPackages;
    }

    protected void resolveLinks() {
        for (EObject elementContainingUnresolvedReference : this.informationHolder.getCurrentCreatedElements()) {
            for (UnresolvedReferenceHolder referenceHolder : this.informationHolder.getUnresolvedReferencesByGeneratedElement(elementContainingUnresolvedReference)) {
                ArrayList<Object> referenceValue = new ArrayList<Object>();
                try {
                    try {
                        EObject referencedElement = this.linkResolver.resolveReferenceinElementList(referenceHolder.getInstructionContainer(), null, referenceHolder.getTextualReference());
                        referenceValue.add(referencedElement);
                    }
                    catch (InvalidReferenceException invalidReferenceException) {
                        referenceValue.add(this.linkResolver.resolveEClassifierUsingPackage(referenceHolder.getInstructionContainer(), this.informationHolder.getCurrentImportedPackages(), referenceHolder.getTextualReference()));
                    }
                    StructuralFeatureGenerator.setFeatureValueInElement(elementContainingUnresolvedReference, referenceHolder.getConcernedFeature(), referenceValue);
                }
                catch (ResolveException e) {
                    this.informationHolder.registerCompilationExceptionAsCompilationStatus(new CompilationException(e.getInvalidInstruction(), CompilationErrorType.INVALID_REFRENCE_ERROR, e.getMessage()));
                }
            }
        }
    }

    protected void validateGeneratedElement() {
        for (EObject generatedElement : Sets.newLinkedHashSet(this.informationHolder.getCurrentCreatedElements())) {
            GeneratedElementValidator validator = new GeneratedElementValidator(this.informationHolder.getInstructionByCreatedElement(generatedElement), generatedElement);
            try {
                Diagnostic diagnostic = validator.validate();
                this.informationHolder.registerDiagnosticAsCompilationStatusList(generatedElement, diagnostic);
            }
            catch (CompilationException e) {
                this.informationHolder.registerCompilationExceptionAsCompilationStatus(e);
            }
        }
    }
}

