/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager.configuration;

import io.smallrye.common.expression.Expression;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Supplier;
import java.util.logging.ErrorManager;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import org.jboss.logmanager.LogContext;
import org.jboss.logmanager.Logger;
import org.jboss.logmanager.StandardOutputStreams;
import org.jboss.logmanager.configuration.ContextConfiguration;
import org.jboss.logmanager.configuration.ObjectBuilder;
import org.jboss.logmanager.configuration.filters.FilterExpressions;
import org.jboss.logmanager.filters.AcceptAllFilter;
import org.jboss.logmanager.filters.DenyAllFilter;

public class PropertyContextConfiguration
extends ContextConfiguration {
    private static final String[] EMPTY_STRINGS = new String[0];
    private final Properties properties;

    private PropertyContextConfiguration(LogContext logContext, Properties properties) {
        super(logContext);
        this.properties = properties;
    }

    public static PropertyContextConfiguration configure(LogContext logContext, Properties properties) {
        PropertyContextConfiguration config = new PropertyContextConfiguration(Objects.requireNonNull(logContext), Objects.requireNonNull(properties));
        config.doConfigure();
        return config;
    }

    private void doConfigure() {
        for (String pojoName : this.getStringCsvArray("pojos")) {
            this.configurePojos(pojoName);
        }
        this.configureLogger("");
        for (String loggerName : this.getStringCsvArray("loggers")) {
            this.configureLogger(loggerName);
        }
        for (String handlerName : this.getStringCsvArray("handlers")) {
            this.configureHandler(handlerName);
        }
        for (String filterName : this.getStringCsvArray("filters")) {
            this.configureFilter(filterName);
        }
        for (String formatterName : this.getStringCsvArray("formatters")) {
            this.configureFormatter(formatterName);
        }
        for (String errorManagerName : this.getStringCsvArray("errorManagers")) {
            this.configureErrorManager(errorManagerName);
        }
    }

    private void configureLogger(String loggerName) {
        String useParentFiltersString;
        String[] handlerNames;
        String filterName;
        Logger logger2 = this.getContext().getLogger(loggerName);
        String levelName = this.getStringProperty(PropertyContextConfiguration.getKey("logger", loggerName, "level"));
        if (levelName != null) {
            logger2.setLevel(Level.parse(levelName));
        }
        if ((filterName = this.getStringProperty(PropertyContextConfiguration.getKey("logger", loggerName, "filter"))) != null && this.configureFilter(filterName)) {
            logger2.setFilter(this.getFilter(filterName));
        }
        for (String name : handlerNames = this.getStringCsvArray(PropertyContextConfiguration.getKey("logger", loggerName, "handlers"))) {
            if (!this.configureHandler(name)) continue;
            logger2.addHandler(this.getHandler(name));
        }
        String useParentHandlersString = this.getStringProperty(PropertyContextConfiguration.getKey("logger", loggerName, "useParentHandlers"));
        if (useParentHandlersString != null) {
            logger2.setUseParentHandlers(PropertyContextConfiguration.resolveBooleanExpression(useParentHandlersString));
        }
        if ((useParentFiltersString = this.getStringProperty(PropertyContextConfiguration.getKey("logger", loggerName, "useParentFilters"))) != null && logger2 instanceof Logger) {
            logger2.setUseParentFilters(PropertyContextConfiguration.resolveBooleanExpression(useParentHandlersString));
        }
    }

    private boolean configureHandler(String handlerName) {
        String[] handlerNames;
        String errorManagerName;
        String formatterName;
        String levelName;
        String filter;
        if (this.hasHandler(handlerName)) {
            return true;
        }
        String className = this.getStringProperty(PropertyContextConfiguration.getKey("handler", handlerName), true, false);
        if (className == null) {
            StandardOutputStreams.printError("Handler %s is not defined%n", handlerName);
            return false;
        }
        ObjectBuilder<Handler> handlerBuilder = ObjectBuilder.of(this, Handler.class, className).setModuleName(this.getStringProperty(PropertyContextConfiguration.getKey("handler", handlerName, "module"))).addPostConstructMethods(this.getStringCsvArray(PropertyContextConfiguration.getKey("handler", handlerName, "postConfiguration")));
        this.configureProperties(handlerBuilder, "handler", handlerName);
        String encoding = this.getStringProperty(PropertyContextConfiguration.getKey("handler", handlerName, "encoding"));
        if (encoding != null) {
            handlerBuilder.addProperty("encoding", encoding);
        }
        if ((filter = this.getStringProperty(PropertyContextConfiguration.getKey("handler", handlerName, "filter"))) != null && this.configureFilter(filter)) {
            handlerBuilder.addDefinedProperty("filter", Filter.class, (Supplier)this.getFilters().get(filter));
        }
        if ((levelName = this.getStringProperty(PropertyContextConfiguration.getKey("handler", handlerName, "level"))) != null) {
            handlerBuilder.addProperty("level", levelName);
        }
        if ((formatterName = this.getStringProperty(PropertyContextConfiguration.getKey("handler", handlerName, "formatter"))) != null && this.configureFormatter(formatterName)) {
            handlerBuilder.addDefinedProperty("formatter", Formatter.class, this.getFormatters().get(formatterName));
        }
        if ((errorManagerName = this.getStringProperty(PropertyContextConfiguration.getKey("handler", handlerName, "errorManager"))) != null && this.configureErrorManager(errorManagerName)) {
            handlerBuilder.addDefinedProperty("errorManager", ErrorManager.class, (Supplier)this.getErrorManagers().get(errorManagerName));
        }
        if ((handlerNames = this.getStringCsvArray(PropertyContextConfiguration.getKey("handler", handlerName, "handlers"))).length > 0) {
            ArrayList<Supplier> subhandlers = new ArrayList<Supplier>();
            for (String name : handlerNames) {
                if (!this.configureHandler(name)) continue;
                subhandlers.add(this.getHandlers().get(name));
            }
            handlerBuilder.addDefinedProperty("handlers", Handler[].class, () -> {
                if (subhandlers.isEmpty()) {
                    return new Handler[0];
                }
                Handler[] result = new Handler[subhandlers.size()];
                int i = 0;
                for (Supplier supplier : subhandlers) {
                    result[i++] = (Handler)supplier.get();
                }
                return result;
            });
        }
        this.addHandler(handlerName, handlerBuilder.build());
        return true;
    }

    private boolean configureFormatter(String formatterName) {
        if (this.hasFilter(formatterName)) {
            return true;
        }
        String className = this.getStringProperty(PropertyContextConfiguration.getKey("formatter", formatterName), true, false);
        if (className == null) {
            StandardOutputStreams.printError("Formatter %s is not defined%n", formatterName);
            return false;
        }
        ObjectBuilder<Formatter> formatterBuilder = ObjectBuilder.of(this, Formatter.class, className).setModuleName(this.getStringProperty(PropertyContextConfiguration.getKey("formatter", formatterName, "module"))).addPostConstructMethods(this.getStringCsvArray(PropertyContextConfiguration.getKey("formatter", formatterName, "postConfiguration")));
        this.configureProperties(formatterBuilder, "formatter", formatterName);
        this.addFormatter(formatterName, formatterBuilder.build());
        return true;
    }

    private boolean configureErrorManager(String errorManagerName) {
        if (this.hasErrorManager(errorManagerName)) {
            return true;
        }
        String className = this.getStringProperty(PropertyContextConfiguration.getKey("errorManager", errorManagerName), true, false);
        if (className == null) {
            StandardOutputStreams.printError("Error manager %s is not defined%n", errorManagerName);
            return false;
        }
        ObjectBuilder<ErrorManager> errorManagerBuilder = ObjectBuilder.of(this, ErrorManager.class, className).setModuleName(this.getStringProperty(PropertyContextConfiguration.getKey("errorManager", errorManagerName, "module"))).addPostConstructMethods(this.getStringCsvArray(PropertyContextConfiguration.getKey("errorManager", errorManagerName, "postConfiguration")));
        this.configureProperties(errorManagerBuilder, "errorManager", errorManagerName);
        this.addErrorManager(errorManagerName, errorManagerBuilder.build());
        return true;
    }

    private boolean configureFilter(String filterName) {
        if (this.hasFilter(filterName)) {
            return true;
        }
        String filterValue = this.getStringProperty(PropertyContextConfiguration.getKey("filter", filterName), true, false);
        if (filterValue == null) {
            this.addFilter(filterName, () -> FilterExpressions.parse(this.getContext(), filterName));
        } else if (AcceptAllFilter.class.getName().equals(filterValue)) {
            this.addFilter(filterName, AcceptAllFilter::getInstance);
        } else if (DenyAllFilter.class.getName().equals(filterValue)) {
            this.addFilter(filterName, DenyAllFilter::getInstance);
        } else {
            ObjectBuilder<Filter> filterBuilder = ObjectBuilder.of(this, Filter.class, filterValue).setModuleName(this.getStringProperty(PropertyContextConfiguration.getKey("filter", filterName, "module"))).addPostConstructMethods(this.getStringCsvArray(PropertyContextConfiguration.getKey("filter", filterName, "postConfiguration")));
            this.configureProperties(filterBuilder, "errorManager", filterName);
            this.addFilter(filterName, filterBuilder.build());
        }
        return true;
    }

    private void configurePojos(String pojoName) {
        if (this.hasObject(pojoName)) {
            return;
        }
        String className = this.getStringProperty(PropertyContextConfiguration.getKey("pojo", pojoName), true, false);
        if (className == null) {
            StandardOutputStreams.printError("POJO %s is not defined%n", pojoName);
            return;
        }
        ObjectBuilder<Object> pojoBuilder = ObjectBuilder.of(this, Object.class, className).setModuleName(this.getStringProperty(PropertyContextConfiguration.getKey("pojo", pojoName, "module"))).addPostConstructMethods(this.getStringCsvArray(PropertyContextConfiguration.getKey("pojo", pojoName, "postConfiguration")));
        this.configureProperties(pojoBuilder, "pojo", pojoName);
        this.addObject(pojoName, pojoBuilder.build());
    }

    private String getStringProperty(String key) {
        return this.getStringProperty(key, true, true);
    }

    private String getStringProperty(String key, boolean trim, boolean resolveExpression) {
        String value = this.properties.getProperty(key);
        if (resolveExpression && value != null) {
            value = PropertyContextConfiguration.resolveExpression(value);
        } else if (value != null && trim) {
            value = value.trim();
        }
        return value;
    }

    private String[] getStringCsvArray(String key) {
        String property = this.properties.getProperty(key, "");
        if (property == null) {
            return EMPTY_STRINGS;
        }
        String value = property.trim();
        if (value.length() == 0) {
            return EMPTY_STRINGS;
        }
        return value.split("\\s*,\\s*");
    }

    private void configureProperties(ObjectBuilder<?> builder, String prefix, String name) {
        String[] propertyNames;
        String[] constructorPropertyNames;
        for (String propertyName : constructorPropertyNames = this.getStringCsvArray(PropertyContextConfiguration.getKey(prefix, name, "constructorProperties"))) {
            String valueString = this.getStringProperty(PropertyContextConfiguration.getKey(prefix, name, propertyName), false, true);
            if (valueString == null) continue;
            builder.addConstructorProperty(propertyName, valueString);
        }
        for (String propertyName : propertyNames = this.getStringCsvArray(PropertyContextConfiguration.getKey(prefix, name, "properties"))) {
            String valueString = this.getStringProperty(PropertyContextConfiguration.getKey(prefix, name, propertyName), false, true);
            if (valueString == null) continue;
            builder.addProperty(propertyName, valueString);
        }
    }

    private static String getKey(String prefix, String objectName) {
        return objectName.length() > 0 ? prefix + "." + objectName : prefix;
    }

    private static String getKey(String prefix, String objectName, String key) {
        return objectName.length() > 0 ? prefix + "." + objectName + "." + key : prefix + "." + key;
    }

    private static boolean resolveBooleanExpression(String possibleExpression) {
        String value = PropertyContextConfiguration.resolveExpression(possibleExpression);
        return !value.toLowerCase(Locale.ROOT).equals("false");
    }

    private static String resolveExpression(String possibleExpression) {
        EnumSet<Expression.Flag> flags = EnumSet.noneOf(Expression.Flag.class);
        Expression expression = Expression.compile(possibleExpression, flags);
        return expression.evaluateWithPropertiesAndEnvironment(false);
    }
}

