/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager;

import io.smallrye.common.constraint.Assert;
import io.smallrye.common.ref.Reference;
import io.smallrye.common.ref.References;
import java.lang.invoke.ConstantBootstraps;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.security.AccessController;
import java.security.Permission;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.LoggingPermission;
import org.jboss.logmanager.CopyOnWriteMap;
import org.jboss.logmanager.CopyOnWriteWeakMap;
import org.jboss.logmanager.Level;
import org.jboss.logmanager.LogContextInitializer;
import org.jboss.logmanager.LogContextSelector;
import org.jboss.logmanager.Logger;
import org.jboss.logmanager.LoggerNode;

public final class LogContext
implements AutoCloseable {
    private static final LogContext SYSTEM_CONTEXT = new LogContext(false, LogContext.discoverDefaultInitializer());
    static final Permission CREATE_CONTEXT_PERMISSION = new RuntimePermission("createLogContext", null);
    static final Permission SET_CONTEXT_SELECTOR_PERMISSION = new RuntimePermission("setLogContextSelector", null);
    static final Permission CONTROL_PERMISSION = new LoggingPermission("control", null);
    private final LoggerNode rootLogger;
    private final boolean strong;
    private final LogContextInitializer initializer;
    private final Set<LoggerNode> pinnedSet;
    private volatile Map<Logger.AttachmentKey<?>, Object> attachments;
    private static final VarHandle attachmentHandle = ConstantBootstraps.fieldVarHandle(MethodHandles.lookup(), "attachments", VarHandle.class, LogContext.class, Map.class);
    private final AtomicReference<Map<String, Reference<java.util.logging.Level, Void>>> levelMapReference;
    private final Set<AutoCloseable> closeHandlers;
    final ReentrantLock treeLock = new ReentrantLock();
    public static final LogContextSelector DEFAULT_LOG_CONTEXT_SELECTOR;
    private static volatile LogContextSelector logContextSelector;

    private static LogContextInitializer discoverDefaultInitializer() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            return AccessController.doPrivileged(LogContext::discoverDefaultInitializer0);
        }
        return LogContext.discoverDefaultInitializer0();
    }

    private static LogContextInitializer discoverDefaultInitializer0() {
        ServiceLoader<LogContextInitializer> loader = ServiceLoader.load(LogContextInitializer.class, LogContext.class.getClassLoader());
        Iterator<LogContextInitializer> iterator = loader.iterator();
        return iterator.hasNext() ? iterator.next() : LogContextInitializer.DEFAULT;
    }

    LogContext(boolean strong, LogContextInitializer initializer) {
        this.initializer = initializer;
        this.strong = strong || initializer.useStrongReferences();
        this.levelMapReference = new AtomicReference<HashMap<String, Reference<java.util.logging.Level, Void>>>(LazyHolder.INITIAL_LEVEL_MAP);
        this.rootLogger = new LoggerNode(this);
        this.closeHandlers = new LinkedHashSet<AutoCloseable>();
        this.attachments = Map.of();
        this.pinnedSet = this.strong ? Set.of() : ConcurrentHashMap.newKeySet();
    }

    public static LogContext create(boolean strong) {
        return LogContext.create(strong, LogContextInitializer.DEFAULT);
    }

    public static LogContext create(boolean strong, LogContextInitializer initializer) {
        Assert.checkNotNullParam("initializer", initializer);
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(CREATE_CONTEXT_PERMISSION);
        }
        return new LogContext(strong, initializer);
    }

    public static LogContext create() {
        return LogContext.create(false);
    }

    public static LogContext create(LogContextInitializer initializer) {
        return LogContext.create(false, initializer);
    }

    public <V> V getAttachment(Logger.AttachmentKey<V> key) {
        Assert.checkNotNullParam("key", key);
        return (V)this.attachments.get(key);
    }

    public <V> V attach(Logger.AttachmentKey<V> key, V value) throws SecurityException {
        V old;
        HashMap newAttachments;
        Map<Logger.AttachmentKey<?>, Object> oldAttachments;
        LogContext.checkAccess();
        Assert.checkNotNullParam("key", key);
        Assert.checkNotNullParam("value", value);
        do {
            oldAttachments = this.attachments;
            newAttachments = new HashMap(oldAttachments);
            old = newAttachments.put(key, value);
        } while (!attachmentHandle.compareAndSet(this, oldAttachments, Map.copyOf(newAttachments)));
        return old;
    }

    public <V> V attachIfAbsent(Logger.AttachmentKey<V> key, V value) throws SecurityException {
        HashMap newAttachments;
        Map<Logger.AttachmentKey<?>, Object> oldAttachments;
        LogContext.checkAccess();
        Assert.checkNotNullParam("key", key);
        Assert.checkNotNullParam("value", value);
        do {
            if ((oldAttachments = this.attachments).containsKey(key)) {
                return (V)oldAttachments.get(key);
            }
            newAttachments = new HashMap(oldAttachments);
            newAttachments.put(key, value);
        } while (!attachmentHandle.compareAndSet(this, oldAttachments, Map.copyOf(newAttachments)));
        return null;
    }

    public <V> V detach(Logger.AttachmentKey<V> key) throws SecurityException {
        Object result;
        Map newAttachments;
        Map<Logger.AttachmentKey<?>, Object> oldAttachments;
        LogContext.checkAccess();
        Assert.checkNotNullParam("key", key);
        do {
            if ((result = (oldAttachments = this.attachments).get(key)) == null) {
                return null;
            }
            int size = oldAttachments.size();
            if (size == 1) {
                newAttachments = Map.of();
                continue;
            }
            newAttachments = new HashMap(oldAttachments);
            newAttachments.remove(key);
        } while (!attachmentHandle.compareAndSet(this, oldAttachments, Map.copyOf(newAttachments)));
        return (V)result;
    }

    public Logger getLogger(String name) {
        return this.rootLogger.getOrCreate(name).createLogger();
    }

    public Logger getLoggerIfExists(String name) {
        LoggerNode node = this.rootLogger.getIfExists(name);
        return node == null ? null : node.createLogger();
    }

    public <V> V getAttachment(String loggerName, Logger.AttachmentKey<V> key) {
        LoggerNode node = this.rootLogger.getIfExists(loggerName);
        if (node == null) {
            return null;
        }
        return node.getAttachment(key);
    }

    public java.util.logging.Level getLevelForName(String name) throws IllegalArgumentException {
        java.util.logging.Level level;
        Map<String, Reference<java.util.logging.Level, Void>> map;
        Reference<java.util.logging.Level, Void> levelRef;
        if (name != null && (levelRef = (map = this.levelMapReference.get()).get(name)) != null && (level = levelRef.get()) != null) {
            return level;
        }
        throw new IllegalArgumentException("Unknown level \"" + name + "\"");
    }

    public void registerLevel(java.util.logging.Level level) {
        this.registerLevel(level, false);
    }

    public void registerLevel(java.util.logging.Level level, boolean strong) {
        HashMap<String, Reference<java.util.logging.Level, Void>> newLevelMap;
        Map<String, Reference<java.util.logging.Level, Void>> oldLevelMap;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(CONTROL_PERMISSION);
        }
        do {
            oldLevelMap = this.levelMapReference.get();
            newLevelMap = new HashMap<String, Reference<java.util.logging.Level, Void>>(oldLevelMap.size());
            for (Map.Entry<String, Reference<java.util.logging.Level, Void>> entry : oldLevelMap.entrySet()) {
                String name = entry.getKey();
                Reference<java.util.logging.Level, Void> levelRef = entry.getValue();
                if (levelRef.get() == null) continue;
                newLevelMap.put(name, levelRef);
            }
            newLevelMap.put(level.getName(), References.create(strong ? Reference.Type.STRONG : Reference.Type.WEAK, level, null));
        } while (!this.levelMapReference.compareAndSet(oldLevelMap, newLevelMap));
    }

    public void unregisterLevel(java.util.logging.Level level) {
        HashMap<String, Reference<java.util.logging.Level, Void>> newLevelMap;
        Map<String, Reference<java.util.logging.Level, Void>> oldLevelMap;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(CONTROL_PERMISSION);
        }
        do {
            Reference<java.util.logging.Level, Void> oldRef;
            if ((oldRef = (oldLevelMap = this.levelMapReference.get()).get(level.getName())) == null || oldRef.get() != level) {
                return;
            }
            newLevelMap = new HashMap<String, Reference<java.util.logging.Level, Void>>(oldLevelMap.size());
            for (Map.Entry<String, Reference<java.util.logging.Level, Void>> entry : oldLevelMap.entrySet()) {
                String name = entry.getKey();
                Reference<java.util.logging.Level, Void> levelRef = entry.getValue();
                java.util.logging.Level oldLevel = levelRef.get();
                if (oldLevel == null || oldLevel == level) continue;
                newLevelMap.put(name, levelRef);
            }
            newLevelMap.put(level.getName(), References.create(Reference.Type.WEAK, level, null));
        } while (!this.levelMapReference.compareAndSet(oldLevelMap, newLevelMap));
    }

    public static LogContext getSystemLogContext() {
        return SYSTEM_CONTEXT;
    }

    public static LogContext getLogContext() {
        return logContextSelector.getLogContext();
    }

    public static void setLogContextSelector(LogContextSelector newSelector) {
        if (newSelector == null) {
            throw new NullPointerException("newSelector is null");
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(SET_CONTEXT_SELECTOR_PERMISSION);
        }
        logContextSelector = newSelector;
    }

    public static LogContextSelector getLogContextSelector() {
        return logContextSelector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws Exception {
        this.treeLock.lock();
        try {
            this.recursivelyClose(this.rootLogger);
            for (AutoCloseable handler : this.closeHandlers) {
                handler.close();
            }
            Map oldAttachments = attachmentHandle.getAndSet(this, Map.of());
            for (Object value : oldAttachments.values()) {
                if (!(value instanceof AutoCloseable)) continue;
                try {
                    ((AutoCloseable)value).close();
                }
                catch (Exception exception) {}
            }
            if (!this.pinnedSet.isEmpty()) {
                this.pinnedSet.clear();
            }
        }
        finally {
            this.treeLock.unlock();
        }
    }

    public Enumeration<String> getLoggerNames() {
        return this.rootLogger.getLoggerNames();
    }

    public void addCloseHandler(AutoCloseable closeHandler) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(CONTROL_PERMISSION);
        }
        this.treeLock.lock();
        try {
            this.closeHandlers.add(closeHandler);
        }
        finally {
            this.treeLock.unlock();
        }
    }

    public Set<AutoCloseable> getCloseHandlers() {
        this.treeLock.lock();
        try {
            LinkedHashSet<AutoCloseable> linkedHashSet = new LinkedHashSet<AutoCloseable>(this.closeHandlers);
            return linkedHashSet;
        }
        finally {
            this.treeLock.unlock();
        }
    }

    public void setCloseHandlers(Collection<AutoCloseable> closeHandlers) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(CONTROL_PERMISSION);
        }
        this.treeLock.lock();
        try {
            this.closeHandlers.clear();
            this.closeHandlers.addAll(closeHandlers);
        }
        finally {
            this.treeLock.unlock();
        }
    }

    private static SecurityException accessDenied() {
        return new SecurityException("Log context modification access denied");
    }

    static void checkAccess() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(CONTROL_PERMISSION);
        }
    }

    LoggerNode getRootLoggerNode() {
        return this.rootLogger;
    }

    ConcurrentMap<String, LoggerNode> createChildMap() {
        return this.strong ? new CopyOnWriteMap() : new CopyOnWriteWeakMap();
    }

    boolean pin(LoggerNode node) {
        return !this.strong && this.pinnedSet.add(node);
    }

    boolean unpin(LoggerNode node) {
        return !this.strong && this.pinnedSet.remove(node);
    }

    LogContextInitializer getInitializer() {
        return this.initializer;
    }

    private void recursivelyClose(LoggerNode loggerNode) {
        assert (this.treeLock.isHeldByCurrentThread());
        for (LoggerNode child : loggerNode.getChildren()) {
            this.recursivelyClose(child);
        }
        loggerNode.close();
    }

    static {
        logContextSelector = DEFAULT_LOG_CONTEXT_SELECTOR = new LogContextSelector(){

            @Override
            public LogContext getLogContext() {
                return SYSTEM_CONTEXT;
            }
        };
    }

    private static final class LazyHolder {
        private static final HashMap<String, Reference<java.util.logging.Level, Void>> INITIAL_LEVEL_MAP;

        private LazyHolder() {
        }

        private static void addStrong(Map<String, Reference<java.util.logging.Level, Void>> map, java.util.logging.Level level) {
            map.put(level.getName().toUpperCase(), References.create(Reference.Type.STRONG, level, null));
        }

        static {
            HashMap<String, Reference<java.util.logging.Level, Void>> map = new HashMap<String, Reference<java.util.logging.Level, Void>>();
            LazyHolder.addStrong(map, java.util.logging.Level.OFF);
            LazyHolder.addStrong(map, java.util.logging.Level.ALL);
            LazyHolder.addStrong(map, java.util.logging.Level.SEVERE);
            LazyHolder.addStrong(map, java.util.logging.Level.WARNING);
            LazyHolder.addStrong(map, java.util.logging.Level.CONFIG);
            LazyHolder.addStrong(map, java.util.logging.Level.INFO);
            LazyHolder.addStrong(map, java.util.logging.Level.FINE);
            LazyHolder.addStrong(map, java.util.logging.Level.FINER);
            LazyHolder.addStrong(map, java.util.logging.Level.FINEST);
            LazyHolder.addStrong(map, Level.FATAL);
            LazyHolder.addStrong(map, Level.ERROR);
            LazyHolder.addStrong(map, Level.WARN);
            LazyHolder.addStrong(map, Level.INFO);
            LazyHolder.addStrong(map, Level.DEBUG);
            LazyHolder.addStrong(map, Level.TRACE);
            INITIAL_LEVEL_MAP = map;
        }
    }
}

