/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.util;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import java.util.Objects;
import java.util.function.Supplier;

public final class LifecycleStatus {
    private final Promise<Void> startupTracker = Promise.promise();
    private final Promise<Void> shutdownTracker = Promise.promise();
    private Status state = Status.STOPPED;

    private synchronized void setState(Status newState) {
        this.state = newState;
    }

    public void addOnStartedHandler(Handler<AsyncResult<Void>> handler) {
        if (handler != null) {
            this.startupTracker.future().onComplete(handler);
        }
    }

    public void addOnStoppedHandler(Handler<AsyncResult<Void>> handler) {
        if (handler != null) {
            this.shutdownTracker.future().onComplete(handler);
        }
    }

    public synchronized boolean setStarting() {
        if (this.state != Status.STOPPED) {
            return false;
        }
        this.setState(Status.STARTING);
        return true;
    }

    public synchronized boolean isStarting() {
        return this.state == Status.STARTING;
    }

    public synchronized boolean setStarted() {
        if (this.state != Status.STOPPED && this.state != Status.STARTING) {
            return false;
        }
        this.setState(Status.STARTED);
        this.startupTracker.complete();
        return true;
    }

    public synchronized boolean isStarted() {
        return this.state == Status.STARTED;
    }

    public synchronized boolean setStopping() {
        if (this.state != Status.STARTING && this.state != Status.STARTED) {
            return false;
        }
        this.setState(Status.STOPPING);
        return true;
    }

    public synchronized Future<Void> runStopAttempt(Supplier<Future<Void>> stopAction) {
        Objects.requireNonNull(stopAction);
        if (this.isStopped()) {
            return Future.succeededFuture();
        }
        Promise<Void> result = Promise.promise();
        this.addOnStoppedHandler(result);
        if (this.setStopping()) {
            stopAction.get().onComplete(this::setStopped);
        }
        return result.future();
    }

    public synchronized boolean isStopping() {
        return this.state == Status.STOPPING;
    }

    public synchronized boolean setStopped() {
        return this.setStopped(Future.succeededFuture());
    }

    public synchronized boolean setStopped(AsyncResult<Void> outcome) {
        if (this.state == Status.STOPPED) {
            return false;
        }
        this.setState(Status.STOPPED);
        this.shutdownTracker.handle(outcome);
        return true;
    }

    public synchronized boolean isStopped() {
        return this.state == Status.STOPPED;
    }

    public static enum Status {
        STOPPED,
        STARTING,
        STARTED,
        STOPPING;

    }
}

