/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.client.amqp.connection;

import io.opentracing.Tracer;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.proton.ProtonClientOptions;
import io.vertx.proton.ProtonLink;
import io.vertx.proton.ProtonMessageHandler;
import io.vertx.proton.ProtonQoS;
import io.vertx.proton.ProtonReceiver;
import io.vertx.proton.ProtonSender;
import java.util.Optional;
import org.apache.qpid.proton.amqp.Symbol;
import org.eclipse.hono.client.amqp.config.ClientConfigProperties;
import org.eclipse.hono.client.amqp.connection.ConnectionLifecycle;
import org.eclipse.hono.client.amqp.connection.impl.HonoConnectionImpl;

public interface HonoConnection
extends ConnectionLifecycle<HonoConnection> {
    public static HonoConnection newConnection(Vertx vertx, ClientConfigProperties clientConfigProperties) {
        return new HonoConnectionImpl(vertx, clientConfigProperties);
    }

    public static HonoConnection newConnection(Vertx vertx, ClientConfigProperties clientConfigProperties, Tracer tracer) {
        HonoConnectionImpl connection = new HonoConnectionImpl(vertx, clientConfigProperties);
        Optional.ofNullable(tracer).ifPresent(connection::setTracer);
        return connection;
    }

    public Vertx getVertx();

    public Tracer getTracer();

    public ClientConfigProperties getConfig();

    @Override
    public Future<HonoConnection> connect();

    public Future<HonoConnection> connect(ProtonClientOptions var1);

    @Override
    public void disconnect();

    public void shutdown();

    public void shutdown(Handler<AsyncResult<Void>> var1);

    public boolean isShutdown();

    public String getRemoteContainerId();

    public String getContainerId();

    public boolean supportsCapability(Symbol var1);

    public <T> Future<T> executeOnContext(Handler<Promise<T>> var1);

    public Future<ProtonSender> createSender(String var1, ProtonQoS var2, Handler<String> var3);

    public Future<ProtonReceiver> createReceiver(String var1, ProtonQoS var2, ProtonMessageHandler var3, Handler<String> var4);

    public Future<ProtonReceiver> createReceiver(String var1, ProtonQoS var2, ProtonMessageHandler var3, int var4, Handler<String> var5);

    public Future<ProtonReceiver> createReceiver(String var1, ProtonQoS var2, ProtonMessageHandler var3, int var4, boolean var5, Handler<String> var6);

    public void closeAndFree(ProtonLink<?> var1, Handler<Void> var2);

    public void closeAndFree(ProtonLink<?> var1, long var2, Handler<Void> var4);
}

