/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.client.amqp.config;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import org.eclipse.hono.client.amqp.config.AuthenticatingClientOptions;
import org.eclipse.hono.config.AbstractConfig;
import org.eclipse.hono.util.Strings;

public class AuthenticatingClientConfigProperties
extends AbstractConfig {
    private String credentialsPath = null;
    private String host = "localhost";
    private boolean hostnameVerificationRequired = true;
    private String password = null;
    private int port = 5671;
    private String serverRole = "unknown";
    private boolean tlsEnabled = false;
    private String username = null;
    private boolean hostConfigured = false;

    public AuthenticatingClientConfigProperties() {
    }

    public AuthenticatingClientConfigProperties(AuthenticatingClientConfigProperties otherProperties) {
        super(otherProperties);
        this.credentialsPath = otherProperties.credentialsPath;
        this.host = otherProperties.host;
        this.hostnameVerificationRequired = otherProperties.hostnameVerificationRequired;
        this.password = otherProperties.password;
        this.port = otherProperties.port;
        this.serverRole = otherProperties.serverRole;
        this.tlsEnabled = otherProperties.tlsEnabled;
        this.username = otherProperties.username;
    }

    public AuthenticatingClientConfigProperties(AuthenticatingClientOptions options) {
        super(options.genericOptions());
        this.setCredentialsPath(options.credentialsPath().orElse(null));
        options.host().ifPresent(this::setHost);
        this.setHostnameVerificationRequired(options.hostnameVerificationRequired());
        this.setPassword(options.password().orElse(null));
        this.setPort(options.port());
        this.setServerRole(options.serverRole());
        this.setTlsEnabled(options.tlsEnabled());
        this.setUsername(options.username().orElse(null));
    }

    public final String getHost() {
        return this.host;
    }

    public final void setHost(String host) {
        this.host = Objects.requireNonNull(host);
        this.hostConfigured = true;
    }

    public boolean isHostConfigured() {
        return this.hostConfigured;
    }

    public final int getPort() {
        return this.port;
    }

    public final void setPort(int port) {
        if (!this.isValidPort(port)) {
            throw new IllegalArgumentException("invalid port number");
        }
        this.port = port;
    }

    public final String getUsername() {
        if (Strings.isNullOrEmpty(this.username)) {
            this.loadCredentials();
        }
        return this.username;
    }

    public final void setUsername(String username) {
        this.username = username;
    }

    public final String getPassword() {
        if (Strings.isNullOrEmpty(this.password)) {
            this.loadCredentials();
        }
        return this.password;
    }

    public final void setPassword(String password) {
        this.password = password;
    }

    public final String getCredentialsPath() {
        return this.credentialsPath;
    }

    public final void setCredentialsPath(String path) {
        this.credentialsPath = path;
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="The path that the credentials are read from is determined from configuration properties that\nare supposed to be passed in during startup of the component only.\n")
    private void loadCredentials() {
        if (Strings.isNullOrEmpty(this.username) && Strings.isNullOrEmpty(this.password) && !Strings.isNullOrEmpty(this.credentialsPath)) {
            try (FileInputStream fis = new FileInputStream(this.credentialsPath);){
                this.LOG.info("loading credentials for [{}:{}, role: {}] from [{}]", this.host, this.port, this.serverRole, this.credentialsPath);
                Properties props = new Properties();
                props.load(fis);
                this.username = props.getProperty("username");
                this.password = Optional.ofNullable(props.getProperty("password")).orElse(null);
            }
            catch (IOException e) {
                this.LOG.warn("could not load client credentials for [{}:{}, role: {}] from file [{}]", this.host, this.port, this.serverRole, this.credentialsPath, e);
            }
        }
    }

    public final boolean isHostnameVerificationRequired() {
        return this.hostnameVerificationRequired;
    }

    public final void setHostnameVerificationRequired(boolean hostnameVerificationRequired) {
        this.hostnameVerificationRequired = hostnameVerificationRequired;
    }

    public final boolean isTlsEnabled() {
        return this.tlsEnabled || this.getTrustOptions() != null;
    }

    public final void setTlsEnabled(boolean enabled) {
        this.tlsEnabled = enabled;
    }

    public final void setServerRoleIfUnknown(String defaultRoleName) {
        if ("unknown".equals(this.serverRole)) {
            this.setServerRole(defaultRoleName);
        }
    }

    public final void setServerRole(String roleName) {
        this.serverRole = Objects.requireNonNull(roleName);
    }

    public final String getServerRole() {
        return this.serverRole;
    }
}

