/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.util;

import java.util.Map;
import java.util.Optional;
import org.eclipse.hono.util.CacheDirective;

public class RequestResponseResult<T> {
    private final int status;
    private final T payload;
    private final CacheDirective cacheDirective;
    private final Map<String, Object> responseProperties;

    public RequestResponseResult(int status, T payload, CacheDirective cacheDirective, Map<String, Object> responseProperties) {
        this.status = status;
        this.payload = payload;
        this.cacheDirective = cacheDirective;
        this.responseProperties = Optional.ofNullable(responseProperties).filter(props -> !props.isEmpty()).map(Map::copyOf).orElse(Map.of());
    }

    public final int getStatus() {
        return this.status;
    }

    public final T getPayload() {
        return this.payload;
    }

    public final CacheDirective getCacheDirective() {
        return this.cacheDirective;
    }

    public final Map<String, Object> getResponseProperties() {
        return this.responseProperties;
    }

    public final boolean isOk() {
        return 200 == this.status;
    }

    public final boolean isNotFound() {
        return 404 == this.status;
    }

    public final boolean isError() {
        return this.status >= 400 && this.status < 600;
    }
}

