/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.client.util;

import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.healthchecks.HealthCheckHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.eclipse.hono.client.util.ServiceClient;
import org.eclipse.hono.util.Lifecycle;
import org.eclipse.hono.util.MessagingClient;
import org.eclipse.hono.util.MessagingType;
import org.eclipse.hono.util.TenantObject;

public final class MessagingClientProvider<T extends MessagingClient & Lifecycle>
implements Lifecycle,
ServiceClient {
    public static final MessagingType DEFAULT_MESSAGING_TYPE = MessagingType.kafka;
    private final Map<MessagingType, T> clientImplementations = new HashMap<MessagingType, T>();
    private final AtomicBoolean startCalled = new AtomicBoolean();
    private final AtomicBoolean stopCalled = new AtomicBoolean();

    private void requireClientsConfigured() {
        if (!this.containsImplementations()) {
            throw new IllegalStateException("no messaging client configured");
        }
    }

    public boolean containsImplementations() {
        return !this.clientImplementations.isEmpty();
    }

    public MessagingClientProvider<T> setClient(T client) {
        Objects.requireNonNull(client);
        Objects.requireNonNull(client.getMessagingType(), "client messaging type is null");
        this.clientImplementations.put(client.getMessagingType(), client);
        return this;
    }

    public T getClient(TenantObject tenant) {
        Objects.requireNonNull(tenant);
        this.requireClientsConfigured();
        return (T)Optional.ofNullable(tenant.getProperty("ext", JsonObject.class)).map(ext -> ext.getString("messaging-type")).map(type -> (MessagingClient)this.clientImplementations.get((Object)MessagingType.valueOf(type))).orElseGet(this::getDefaultImplementation);
    }

    public T getClientOrDefault(String messagingType) {
        this.requireClientsConfigured();
        return (T)Optional.ofNullable(messagingType).map(MessagingType::valueOf).map(this.clientImplementations::get).orElseGet(this::getDefaultImplementation);
    }

    public T getClient(MessagingType messagingType) {
        Objects.requireNonNull(messagingType);
        this.requireClientsConfigured();
        return (T)((MessagingClient)this.clientImplementations.get((Object)messagingType));
    }

    public List<T> getClients() {
        return new ArrayList<T>(this.clientImplementations.values());
    }

    private T getDefaultImplementation() {
        if (this.clientImplementations.size() == 1) {
            return (T)((MessagingClient)this.clientImplementations.values().iterator().next());
        }
        return (T)((MessagingClient)this.clientImplementations.get((Object)DEFAULT_MESSAGING_TYPE));
    }

    @Override
    public void registerReadinessChecks(HealthCheckHandler readinessHandler) {
        this.clientImplementations.values().stream().filter(arg_0 -> MessagingClientProvider.lambda$registerReadinessChecks$2(ServiceClient.class, arg_0)).map(arg_0 -> MessagingClientProvider.lambda$registerReadinessChecks$3(ServiceClient.class, arg_0)).forEach(client -> client.registerReadinessChecks(readinessHandler));
    }

    @Override
    public void registerLivenessChecks(HealthCheckHandler livenessHandler) {
        this.clientImplementations.values().stream().filter(arg_0 -> MessagingClientProvider.lambda$registerLivenessChecks$5(ServiceClient.class, arg_0)).map(arg_0 -> MessagingClientProvider.lambda$registerLivenessChecks$6(ServiceClient.class, arg_0)).forEach(client -> client.registerLivenessChecks(livenessHandler));
    }

    @Override
    public Future<Void> start() {
        if (!this.startCalled.compareAndSet(false, true)) {
            return Future.succeededFuture();
        }
        this.requireClientsConfigured();
        List futures = this.clientImplementations.values().stream().map(rec$ -> ((Lifecycle)rec$).start()).collect(Collectors.toList());
        return Future.all(futures).mapEmpty();
    }

    @Override
    public Future<Void> stop() {
        if (!this.stopCalled.compareAndSet(false, true)) {
            return Future.succeededFuture();
        }
        List futures = this.clientImplementations.values().stream().map(rec$ -> ((Lifecycle)rec$).stop()).collect(Collectors.toList());
        return Future.all(futures).mapEmpty();
    }

    private static /* synthetic */ ServiceClient lambda$registerLivenessChecks$6(Class rec$, Object x$0) {
        return (ServiceClient)rec$.cast(x$0);
    }

    private static /* synthetic */ boolean lambda$registerLivenessChecks$5(Class rec$, Object x$0) {
        return rec$.isInstance(x$0);
    }

    private static /* synthetic */ ServiceClient lambda$registerReadinessChecks$3(Class rec$, Object x$0) {
        return (ServiceClient)rec$.cast(x$0);
    }

    private static /* synthetic */ boolean lambda$registerReadinessChecks$2(Class rec$, Object x$0) {
        return rec$.isInstance(x$0);
    }
}

