/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.impl;

import io.vertx.codegen.annotations.Nullable;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.Json;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.MIMEHeader;
import io.vertx.ext.web.ParsedHeaderValues;
import io.vertx.ext.web.RequestBody;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.impl.RoutingContextInternal;

public class RequestBodyImpl
implements RequestBody {
    private final RoutingContext ctx;
    private Buffer body;
    private String string;
    private JsonObject jsonObject;
    private JsonArray jsonArray;

    public RequestBodyImpl(RoutingContext ctx) {
        this.ctx = ctx;
    }

    public void setBuffer(Buffer body) {
        this.body = body;
        this.string = null;
        this.jsonObject = null;
        this.jsonArray = null;
    }

    @Override
    public @Nullable String asString() {
        if (this.body == null) {
            return null;
        }
        if (this.string == null) {
            String charset;
            MIMEHeader contentType;
            ParsedHeaderValues parsedHeaders = this.ctx.parsedHeaders();
            if (parsedHeaders != null && (contentType = parsedHeaders.contentType()) != null && (charset = contentType.parameter("charset")) != null) {
                this.string = this.body.toString(charset);
                return this.string;
            }
            this.string = this.body.toString();
        }
        return this.string;
    }

    @Override
    public @Nullable String asString(String encoding) {
        if (this.body == null) {
            return null;
        }
        return this.body.toString(encoding);
    }

    @Override
    public @Nullable JsonObject asJsonObject(int maxAllowedLength) {
        if (this.body == null) {
            return null;
        }
        if (this.jsonObject == null) {
            if (maxAllowedLength >= 0 && this.body.length() > maxAllowedLength) {
                throw new IllegalStateException("RoutingContext body size exceeds the allowed limit");
            }
            this.jsonObject = (JsonObject)Json.decodeValue(this.body);
        }
        return this.jsonObject;
    }

    @Override
    public @Nullable JsonArray asJsonArray(int maxAllowedLength) {
        if (this.body == null) {
            return null;
        }
        if (this.jsonArray == null) {
            if (maxAllowedLength >= 0 && this.body.length() > maxAllowedLength) {
                throw new IllegalStateException("RoutingContext body size exceeds the allowed limit");
            }
            this.jsonArray = (JsonArray)Json.decodeValue(this.body);
        }
        return this.jsonArray;
    }

    @Override
    public <R> @Nullable R asPojo(Class<R> clazz, int maxAllowedLength) {
        if (this.body == null) {
            return null;
        }
        if (maxAllowedLength >= 0 && this.body.length() > maxAllowedLength) {
            throw new IllegalStateException("RoutingContext body size exceeds the allowed limit");
        }
        return Json.decodeValue(this.body, clazz);
    }

    @Override
    public @Nullable Buffer buffer() {
        return this.body;
    }

    @Override
    public int length() {
        if (this.body == null) {
            return -1;
        }
        return this.body.length();
    }

    @Override
    public boolean available() {
        return ((RoutingContextInternal)this.ctx).seenHandler(2);
    }
}

