/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.authentication.AuthenticationProvider;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.AuthenticationHandler;
import io.vertx.ext.web.handler.ChainAuthHandler;
import io.vertx.ext.web.handler.HttpException;
import io.vertx.ext.web.handler.impl.AuthenticationHandlerImpl;
import io.vertx.ext.web.handler.impl.AuthenticationHandlerInternal;
import java.util.ArrayList;
import java.util.List;

public class ChainAuthHandlerImpl
extends AuthenticationHandlerImpl<AuthenticationProvider>
implements ChainAuthHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ChainAuthHandler.class);
    private final List<AuthenticationHandlerInternal> handlers = new ArrayList<AuthenticationHandlerInternal>();
    private final boolean all;
    private int willRedirect = -1;

    public ChainAuthHandlerImpl(boolean all) {
        super(null);
        this.all = all;
    }

    @Override
    public boolean performsRedirect() {
        return this.willRedirect != -1;
    }

    @Override
    public synchronized ChainAuthHandler add(AuthenticationHandler other) {
        if (this.performsRedirect()) {
            throw new IllegalStateException("Cannot add a handler after a handler known to perform a HTTP redirect: " + this.handlers.get(this.willRedirect));
        }
        AuthenticationHandlerInternal otherInternal = (AuthenticationHandlerInternal)other;
        if (otherInternal.performsRedirect()) {
            this.willRedirect = this.handlers.size();
        }
        this.handlers.add(otherInternal);
        return this;
    }

    @Override
    public void authenticate(RoutingContext context, Handler<AsyncResult<User>> handler) {
        if (this.handlers.size() == 0) {
            handler.handle(Future.failedFuture("No providers in the auth chain."));
        } else {
            this.iterate(0, context, null, null, handler);
        }
    }

    private void iterate(int idx, RoutingContext ctx, User result, Throwable exception, Handler<AsyncResult<User>> handler) {
        if (idx >= this.handlers.size()) {
            if (this.all) {
                if (exception == null) {
                    handler.handle(Future.succeededFuture(result));
                } else {
                    handler.handle(Future.failedFuture(exception));
                }
            } else {
                handler.handle(Future.failedFuture(exception));
            }
            return;
        }
        AuthenticationHandlerInternal authHandler = this.handlers.get(idx);
        authHandler.authenticate(ctx, res -> {
            if (res.failed()) {
                if (!this.all && res.cause() instanceof HttpException) {
                    HttpException ex = (HttpException)res.cause();
                    switch (ex.getStatusCode()) {
                        case 302: 
                        case 400: 
                        case 401: 
                        case 403: {
                            this.iterate(idx + 1, ctx, null, ex, handler);
                            return;
                        }
                    }
                }
                handler.handle(Future.failedFuture(res.cause()));
                return;
            }
            if (this.all) {
                this.iterate(idx + 1, ctx, (User)res.result(), null, handler);
            } else {
                handler.handle(Future.succeededFuture(res.result()));
            }
        });
    }

    @Override
    public boolean setAuthenticateHeader(RoutingContext ctx) {
        boolean added = false;
        for (AuthenticationHandlerInternal authHandler : this.handlers) {
            if (this.all && added) {
                LOG.warn("Multiple WWW-Authenticate headers will be suppressed on a ALL chain");
                break;
            }
            added |= authHandler.setAuthenticateHeader(ctx);
        }
        return added;
    }
}

