/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config;

import io.smallrye.config.Converters;
import io.smallrye.config.common.MapBackedConfigSource;
import io.smallrye.config.common.utils.StringUtil;
import java.io.Serializable;
import java.security.AccessController;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class EnvConfigSource
extends MapBackedConfigSource {
    private static final long serialVersionUID = -4525015934376795496L;
    private static final int DEFAULT_ORDINAL = 300;

    protected EnvConfigSource() {
        this(300);
    }

    protected EnvConfigSource(int ordinal) {
        this(EnvConfigSource.getEnvProperties(), ordinal);
    }

    public EnvConfigSource(Map<String, String> propertyMap, int ordinal) {
        super("EnvConfigSource", propertyMap, EnvConfigSource.getEnvOrdinal(propertyMap, ordinal));
    }

    @Override
    public String getValue(String propertyName) {
        return EnvConfigSource.getValue(propertyName, this.getProperties());
    }

    private static String getValue(String name, Map<String, String> properties) {
        if (name == null) {
            return null;
        }
        String value = properties.get(name);
        if (value != null) {
            return value;
        }
        String sanitizedName = StringUtil.replaceNonAlphanumericByUnderscores(name);
        value = properties.get(sanitizedName);
        if (value != null) {
            return value;
        }
        return properties.get(sanitizedName.toUpperCase());
    }

    private static Map<String, String> getEnvProperties() {
        return Collections.unmodifiableMap(AccessController.doPrivileged(() -> new HashMap<String, String>(System.getenv())));
    }

    private static int getEnvOrdinal(Map<String, String> properties, int ordinal) {
        String value = EnvConfigSource.getValue("config_ordinal", properties);
        if (value != null) {
            return Converters.INTEGER_CONVERTER.convert(value);
        }
        return ordinal;
    }

    Object writeReplace() {
        return new Ser();
    }

    static final class Ser
    implements Serializable {
        private static final long serialVersionUID = 6812312718645271331L;

        Ser() {
        }

        Object readResolve() {
            return new EnvConfigSource();
        }
    }
}

