/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.vertx;

import io.fabric8.kubernetes.client.http.AsyncBody;
import io.fabric8.kubernetes.client.http.HttpRequest;
import io.fabric8.kubernetes.client.http.HttpResponse;
import io.fabric8.kubernetes.client.http.StandardHttpHeaders;
import io.fabric8.kubernetes.client.http.StandardHttpRequest;
import io.fabric8.kubernetes.client.vertx.InputStreamReadStream;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.RequestOptions;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

class VertxHttpRequest {
    final Vertx vertx;
    private final RequestOptions options;
    private StandardHttpRequest request;

    public VertxHttpRequest(Vertx vertx, RequestOptions options, StandardHttpRequest request) {
        this.vertx = vertx;
        this.options = options;
        this.request = request;
    }

    public CompletableFuture<HttpResponse<AsyncBody>> consumeBytes(HttpClient client, AsyncBody.Consumer<List<ByteBuffer>> consumer) {
        Function<HttpClientResponse, HttpResponse> responseHandler = resp -> {
            resp.pause();
            AsyncBody result = new AsyncBody((HttpClientResponse)resp){
                final CompletableFuture done = new CompletableFuture();
                final /* synthetic */ HttpClientResponse val$resp;
                {
                    this.val$resp = httpClientResponse;
                }

                @Override
                public void consume() {
                    this.val$resp.fetch(1L);
                }

                @Override
                public CompletableFuture<Void> done() {
                    return this.done;
                }

                @Override
                public void cancel() {
                    this.val$resp.handler((Handler)null);
                    this.val$resp.endHandler((Handler)null);
                    this.val$resp.request().reset();
                    this.done.cancel(false);
                }
            };
            resp.handler(buffer -> {
                try {
                    consumer.consume(Arrays.asList(ByteBuffer.wrap(buffer.getBytes())), result);
                }
                catch (Exception e) {
                    resp.request().reset();
                    result.done().completeExceptionally(e);
                }
            }).endHandler(end -> result.done().complete(null));
            return new VertxHttpResponse(result, (HttpClientResponse)resp, this.request);
        };
        return client.request(this.options).compose(request -> {
            Future<HttpClientResponse> fut;
            StandardHttpRequest.BodyContent body = this.request.body();
            if (body != null) {
                if (body instanceof StandardHttpRequest.StringBodyContent) {
                    Buffer buffer = Buffer.buffer(((StandardHttpRequest.StringBodyContent)body).getContent());
                    fut = request.send(buffer);
                } else if (body instanceof StandardHttpRequest.ByteArrayBodyContent) {
                    Buffer buffer = Buffer.buffer(((StandardHttpRequest.ByteArrayBodyContent)body).getContent());
                    fut = request.send(buffer);
                } else if (body instanceof StandardHttpRequest.InputStreamBodyContent) {
                    StandardHttpRequest.InputStreamBodyContent bodyContent = (StandardHttpRequest.InputStreamBodyContent)body;
                    InputStream is = bodyContent.getContent();
                    InputStreamReadStream stream = new InputStreamReadStream(this, is, (HttpClientRequest)request);
                    fut = request.send(stream);
                } else {
                    fut = Future.failedFuture("Unsupported body content");
                }
            } else {
                fut = request.send();
            }
            return fut.map(responseHandler);
        }).toCompletionStage().toCompletableFuture();
    }

    static Map<String, List<String>> toHeadersMap(MultiMap multiMap) {
        LinkedHashMap<String, List<String>> headers = new LinkedHashMap<String, List<String>>();
        multiMap.names().forEach(k -> headers.put((String)k, multiMap.getAll((String)k)));
        return headers;
    }

    private static final class VertxHttpResponse
    extends StandardHttpHeaders
    implements HttpResponse<AsyncBody> {
        private final AsyncBody result;
        private final HttpClientResponse resp;
        private final HttpRequest request;

        private VertxHttpResponse(AsyncBody result, HttpClientResponse resp, HttpRequest request) {
            super(VertxHttpRequest.toHeadersMap(resp.headers()));
            this.result = result;
            this.resp = resp;
            this.request = request;
        }

        @Override
        public int code() {
            return this.resp.statusCode();
        }

        @Override
        public AsyncBody body() {
            return this.result;
        }

        @Override
        public HttpRequest request() {
            return this.request;
        }

        @Override
        public Optional<HttpResponse<?>> previousResponse() {
            return Optional.empty();
        }
    }
}

