/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.util;

import junit.framework.TestCase;
import org.eclipse.handly.util.TextRange;

public class TextRangeTest
extends TestCase {
    public void test1() {
        TextRange r = new TextRange(3, 7);
        TextRangeTest.assertEquals((int)3, (int)r.getOffset());
        TextRangeTest.assertEquals((int)7, (int)r.getLength());
        TextRangeTest.assertEquals((int)10, (int)r.getEndOffset());
        TextRangeTest.assertFalse((boolean)r.isEmpty());
        TextRangeTest.assertFalse((boolean)r.covers(2));
        TextRangeTest.assertTrue((boolean)r.covers(3));
        TextRangeTest.assertTrue((boolean)r.covers(10));
        TextRangeTest.assertFalse((boolean)r.covers(11));
        TextRangeTest.assertFalse((boolean)r.strictlyCovers(2));
        TextRangeTest.assertTrue((boolean)r.strictlyCovers(3));
        TextRangeTest.assertTrue((boolean)r.strictlyCovers(9));
        TextRangeTest.assertFalse((boolean)r.strictlyCovers(10));
    }

    public void test2() {
        TextRange r = new TextRange(0, 0);
        TextRangeTest.assertTrue((boolean)r.isEmpty());
    }

    public void test3() {
        TextRange r = new TextRange(3, 0);
        TextRangeTest.assertTrue((boolean)r.isEmpty());
    }

    public void test4() {
        try {
            new TextRange(-1, 3);
            TextRangeTest.fail();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        try {
            new TextRange(3, -1);
            TextRangeTest.fail();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void test5() {
        TextRange r = new TextRange(3, 7);
        TextRangeTest.assertEquals((Object)r, (Object)r);
        TextRangeTest.assertEquals((Object)new TextRange(3, 7), (Object)r);
        TextRangeTest.assertFalse((boolean)r.equals((Object)new TextRange(0, 7)));
        TextRangeTest.assertFalse((boolean)r.equals(new Object()));
        TextRangeTest.assertFalse((boolean)r.equals(null));
    }

    public void test6() {
        TextRange r = new TextRange(3, 7);
        int hash = r.hashCode();
        TextRangeTest.assertEquals((int)hash, (int)r.hashCode());
        TextRangeTest.assertEquals((int)hash, (int)new TextRange(3, 7).hashCode());
    }
}

