/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.model.impl.support;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.handly.model.impl.support.ISourceFileImplSupport;
import org.eclipse.handly.model.impl.support.WorkingCopyInfo;

abstract class WorkingCopyHelper {
    private final ISourceFileImplSupport sourceFile;

    static boolean becomeWorkingCopy(final ISourceFileImplSupport sourceFile, final WorkingCopyInfo info, final IProgressMonitor monitor) throws CoreException {
        WorkingCopyHelper helper = new WorkingCopyHelper(sourceFile){

            @Override
            WorkingCopyInfo doAcquireWorkingCopy() {
                return sourceFile.getElementManager_().putWorkingCopyInfoIfAbsent(sourceFile, info);
            }

            @Override
            boolean isCanceled() {
                if (monitor == null) {
                    return false;
                }
                return monitor.isCanceled();
            }
        };
        WorkingCopyInfo existingInfo = helper.acquireWorkingCopy();
        if (existingInfo == null) {
            boolean success = false;
            try {
                info.initTask.execute(monitor);
                success = true;
            }
            finally {
                if (!success) {
                    sourceFile.releaseWorkingCopy_();
                }
            }
        }
        return existingInfo == null;
    }

    static boolean acquireExistingWorkingCopy(final ISourceFileImplSupport sourceFile, final IProgressMonitor monitor) {
        WorkingCopyHelper helper = new WorkingCopyHelper(sourceFile){

            @Override
            WorkingCopyInfo doAcquireWorkingCopy() {
                return sourceFile.getElementManager_().getWorkingCopyInfo(sourceFile);
            }

            @Override
            boolean isCanceled() {
                if (monitor == null) {
                    return false;
                }
                return monitor.isCanceled();
            }
        };
        WorkingCopyInfo existingInfo = helper.acquireWorkingCopy();
        return existingInfo != null;
    }

    private WorkingCopyHelper(ISourceFileImplSupport sourceFile) {
        if (sourceFile == null) {
            throw new IllegalArgumentException();
        }
        this.sourceFile = sourceFile;
    }

    WorkingCopyInfo acquireWorkingCopy() {
        WorkingCopyInfo info;
        boolean success;
        do {
            if (this.isCanceled()) {
                throw new OperationCanceledException();
            }
            info = this.doAcquireWorkingCopy();
            if (info == null) {
                return null;
            }
            success = false;
            try {
                success = this.waitForInit(info);
            }
            finally {
                if (!success) {
                    this.sourceFile.releaseWorkingCopy_();
                }
            }
        } while (!success);
        return info;
    }

    abstract WorkingCopyInfo doAcquireWorkingCopy();

    boolean isCanceled() {
        return false;
    }

    private boolean waitForInit(WorkingCopyInfo info) {
        int i = 0;
        while (i < 10) {
            if (this.isCanceled()) {
                throw new OperationCanceledException();
            }
            try {
                return info.initTask.wasSuccessful(10L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
            }
            catch (TimeoutException timeoutException) {
                // empty catch block
            }
            ++i;
        }
        return false;
    }
}

