/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.core.dom;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.aspectj.org.eclipse.jdt.core.dom.AST;
import org.aspectj.org.eclipse.jdt.core.dom.ASTNode;
import org.aspectj.org.eclipse.jdt.core.dom.Javadoc;
import org.aspectj.org.eclipse.jdt.core.dom.Name;
import org.aspectj.org.eclipse.jdt.core.dom.PointcutDeclaration;
import org.aspectj.org.eclipse.jdt.core.dom.SimpleName;
import org.aspectj.org.eclipse.jdt.core.dom.SimplePropertyDescriptor;
import org.aspectj.org.eclipse.jdt.core.dom.Type;
import org.aspectj.org.eclipse.jdt.core.dom.TypeDeclaration;

public class AjTypeDeclaration
extends TypeDeclaration {
    public static final SimplePropertyDescriptor ASPECT_PROPERTY = new SimplePropertyDescriptor(TypeDeclaration.class, "aspect", Boolean.TYPE, true);
    protected static List ajPROPERTY_DESCRIPTORS_2_0;
    protected static List ajPROPERTY_DESCRIPTORS_3_0;
    private boolean isAspect = false;

    public AjTypeDeclaration(AST ast) {
        super(ast);
    }

    @Override
    ASTNode clone0(AST target) {
        AjTypeDeclaration result = new AjTypeDeclaration(target);
        result.setSourceRange(this.getStartPosition(), this.getLength());
        result.setJavadoc((Javadoc)ASTNode.copySubtree(target, this.getJavadoc()));
        if (this.ast.apiLevel == 2) {
            result.internalSetModifiers(this.getModifiers());
            result.setSuperclass((Name)ASTNode.copySubtree(target, this.getSuperclass()));
            result.superInterfaces().addAll(ASTNode.copySubtrees(target, this.superInterfaces()));
        }
        result.setInterface(this.isInterface());
        result.setAspect(this.isAspect());
        result.setName((SimpleName)this.getName().clone(target));
        if (this.ast.apiLevel >= 3) {
            result.modifiers().addAll(ASTNode.copySubtrees(target, this.modifiers()));
            result.typeParameters().addAll(ASTNode.copySubtrees(target, this.typeParameters()));
            result.setSuperclassType((Type)ASTNode.copySubtree(target, this.getSuperclassType()));
            result.superInterfaceTypes().addAll(ASTNode.copySubtrees(target, this.superInterfaceTypes()));
        }
        result.bodyDeclarations().addAll(ASTNode.copySubtrees(target, this.bodyDeclarations()));
        return result;
    }

    @Override
    boolean internalGetSetBooleanProperty(SimplePropertyDescriptor property, boolean get, boolean value) {
        if (property == ASPECT_PROPERTY) {
            if (get) {
                return this.isAspect();
            }
            this.setAspect(value);
            return false;
        }
        return super.internalGetSetBooleanProperty(property, get, value);
    }

    public static List propertyDescriptors(int apiLevel) {
        if (apiLevel == 2) {
            return ajPROPERTY_DESCRIPTORS_2_0;
        }
        return ajPROPERTY_DESCRIPTORS_3_0;
    }

    public boolean isAspect() {
        return this.isAspect;
    }

    public void setAspect(boolean isAspect) {
        this.preValueChange(ASPECT_PROPERTY);
        this.isAspect = isAspect;
        this.postValueChange(ASPECT_PROPERTY);
    }

    public PointcutDeclaration[] getPointcuts() {
        List bd = this.bodyDeclarations();
        int pointcutCount = 0;
        ListIterator it = bd.listIterator();
        while (it.hasNext()) {
            if (!(it.next() instanceof PointcutDeclaration)) continue;
            ++pointcutCount;
        }
        PointcutDeclaration[] pointcuts = new PointcutDeclaration[pointcutCount];
        int next = 0;
        ListIterator it2 = bd.listIterator();
        while (it2.hasNext()) {
            Object decl = it2.next();
            if (!(decl instanceof PointcutDeclaration)) continue;
            pointcuts[next++] = (PointcutDeclaration)decl;
        }
        return pointcuts;
    }

    public ASTNode.NodeList getSuperInterfaceNames() {
        return this.superInterfaceNames;
    }

    public ASTNode.NodeList getTypeParameters() {
        return this.typeParameters;
    }

    static {
        ArrayList temporary = new ArrayList();
        AjTypeDeclaration.createPropertyList(TypeDeclaration.class, temporary);
        temporary.addAll(PROPERTY_DESCRIPTORS_2_0);
        AjTypeDeclaration.addProperty(ASPECT_PROPERTY, temporary);
        ajPROPERTY_DESCRIPTORS_2_0 = AjTypeDeclaration.reapPropertyList(temporary);
        temporary.clear();
        AjTypeDeclaration.createPropertyList(TypeDeclaration.class, temporary);
        temporary.addAll(PROPERTY_DESCRIPTORS_3_0);
        AjTypeDeclaration.addProperty(ASPECT_PROPERTY, temporary);
        ajPROPERTY_DESCRIPTORS_3_0 = AjTypeDeclaration.reapPropertyList(temporary);
    }
}

