/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.launcher.debug.model;

import fr.inria.aoste.timesquare.launcher.debug.model.CCSLDebugElement;
import fr.inria.aoste.timesquare.launcher.debug.model.ICCSLDebugTarget;
import fr.inria.aoste.timesquare.launcher.debug.model.ISimulationInterface;
import fr.inria.aoste.timesquare.launcher.debug.model.StateEngine;
import fr.inria.aoste.timesquare.launcher.debug.model.ThreadInterface;
import fr.inria.aoste.timesquare.launcher.debug.model.values.CCSLAssertVariable;
import fr.inria.aoste.timesquare.launcher.debug.model.values.CCSLClockVariable;
import fr.inria.aoste.timesquare.launcher.debug.model.values.CCSLIntVariable;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDisconnect;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IVariable;

public final class CCSLDebugThread
extends CCSLDebugElement
implements IThread,
Runnable,
ThreadInterface,
IDisconnect {
    private final ISimulationInterface sim;
    private static final boolean isStepping = false;
    private final IVariable[] variables;
    private final CCSLIntVariable stepVar;
    private final CCSLIntVariable stepView;
    private final CCSLClockVariable stepclock;
    private final CCSLAssertVariable stepsassert;
    Thread theThread = null;
    private int exitValue = 1;
    ThreadStart th = null;
    private static int count = 0;
    private int num = count++;
    boolean disconnected = false;

    public CCSLDebugThread(ICCSLDebugTarget target, ISimulationInterface sim) {
        super(target);
        assert (sim != null);
        this.sim = sim;
        this.stepVar = new CCSLIntVariable(target, "Next Step To Compute");
        this.stepView = new CCSLIntVariable(target, "Visible Step");
        this.stepclock = new CCSLClockVariable(target, "Clocks");
        this.stepsassert = new CCSLAssertVariable(target, "Assert");
        this.variables = new IVariable[]{this.stepVar, this.stepView, this.stepclock, this.stepsassert};
    }

    IVariable[] getVariables() {
        return this.variables;
    }

    int getCurrentStep() {
        return this.sim.getCurrentStepIndice();
    }

    public IBreakpoint[] getBreakpoints() {
        System.out.println("getBreakpoints");
        return new IBreakpoint[0];
    }

    public boolean canResume() {
        return this.isRunnable();
    }

    public boolean canSuspend() {
        return this.isRun();
    }

    public boolean canStepInto() {
        return this.isRunnable();
    }

    public boolean canStepOver() {
        return this.isRunnable();
    }

    public boolean canStepReturn() {
        return false;
    }

    public boolean canTerminate() {
        return !this.isFinish() && this.isInitialize();
    }

    private boolean isInitialize() {
        return this.sim.getStateEngine() != StateEngine.init;
    }

    private boolean isFinish() {
        if (this.sim != null) {
            return this.sim.getStateEngine().isFinish();
        }
        return false;
    }

    private boolean isTerminateStatus() {
        if (this.sim != null) {
            return this.sim.getStateEngine().isTerminate();
        }
        return false;
    }

    public boolean isSuspended() {
        return this.getDebugTarget().isSuspended();
    }

    public void resume() throws DebugException {
        this.setRunStart();
        if (this.sim.getStateEngine().isTerminate()) {
            this.terminate();
            return;
        }
        this.theThread = new ThreadRun();
        this.theThread.start();
    }

    public void suspend() throws DebugException {
        this.sim.stopstep();
    }

    public boolean isRun() {
        if (this.sim != null) {
            return this.sim.getStateEngine().isRunning();
        }
        return false;
    }

    public boolean isRunnable() {
        if (this.sim != null) {
            return this.sim.getStateEngine().isRunnable();
        }
        return false;
    }

    public boolean isStepping() {
        return false;
    }

    public void setRunStart() {
        this.fireEvent(new DebugEvent((Object)this, 2));
    }

    public void setRunFinish() {
        this.fireEvent(new DebugEvent((Object)this, 2));
    }

    public void updateVar() {
        try {
            if (this.isTerminated()) {
                this.stepVar.setValue("---");
            } else {
                this.stepVar.setValue(this.getCurrentStep());
            }
            this.stepView.setValue(this.sim.getViewStepIndice());
            this.stepclock.setValue(this.sim.getStepview());
            this.stepsassert.setValue(this.sim.getStepview());
            if (this.sim.getStateEngine().isFinish()) {
                this.terminate();
            } else {
                this.fireEvent(new DebugEvent((Object)this, 2));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void endofStep() throws DebugException {
        if (this.theThread != null && this.theThread.isAlive()) {
            this.theThread = null;
        }
        if (this.isTerminated()) {
            this.stepVar.setValue("---");
        } else {
            this.stepVar.setValue(this.getCurrentStep());
        }
        this.stepView.setValue(this.sim.getViewStepIndice());
        this.stepclock.setValue(this.sim.getStepview());
        this.stepsassert.setValue(this.sim.getStepview());
        if (this.isTerminateStatus()) {
            this.fireEvent(new DebugEvent((Object)this, 2));
        } else {
            this.fireEvent(new DebugEvent((Object)this, 2));
        }
    }

    public void stepInto() throws DebugException {
        try {
            this.setRunStart();
            if (this.isTerminateStatus()) {
                this.terminate();
                return;
            }
            this.theThread = new ThreadStep();
            this.theThread.start();
        }
        catch (Throwable e) {
            this.abort("Error in myStep", e);
        }
    }

    public void stepOver() throws DebugException {
        try {
            this.setRunStart();
            if (this.isTerminateStatus()) {
                this.terminate();
                return;
            }
            this.theThread = new ThreadStepN(10);
            this.theThread.start();
        }
        catch (Throwable e) {
            this.abort("Error in myStep", e);
        }
    }

    public void stepReturn() throws DebugException {
    }

    @Override
    public int getExitValue() {
        return this.exitValue;
    }

    @Override
    public void run() {
        super.fireCreationEvent();
        System.out.println("CCSL Thread run");
        try {
            this.th = new ThreadStart();
            this.th.start();
            this.th.join();
            this.exitValue = 0;
        }
        catch (Exception ce) {
            System.err.println("CCSL Thread abnormal ending " + ce);
            super.fireTerminateEvent();
            this.exitValue = -1;
        }
    }

    public void joinThreadStart() throws InterruptedException {
        if (this.th != null) {
            this.th.join();
        }
    }

    public final String getName() throws DebugException {
        return "CCSLDebugThread [" + this.num + "]";
    }

    public final int getPriority() throws DebugException {
        return 0;
    }

    public final IStackFrame[] getStackFrames() {
        if (this.isSuspended()) {
            return this.getDebugTarget().getStackFrames();
        }
        return new IStackFrame[0];
    }

    public final IStackFrame getTopStackFrame() throws DebugException {
        IStackFrame[] frames = this.getStackFrames();
        if (frames.length > 0) {
            return frames[0];
        }
        return null;
    }

    public boolean hasStackFrames() throws DebugException {
        return this.isSuspended();
    }

    @Override
    public boolean isTerminated() {
        return this.sim.isTerminated();
    }

    @Override
    public void terminate() throws DebugException {
        if (this.theThread != null && this.theThread.isAlive()) {
            this.sim.stopstep();
            try {
                this.theThread.join();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        TerminateThread t = new TerminateThread();
        t.start();
    }

    @Override
    public ISimulationInterface getSim() {
        return this.sim;
    }

    public boolean canDisconnect() {
        return true;
    }

    public void disconnect() throws DebugException {
        this.disconnected = true;
    }

    public boolean isDisconnected() {
        return this.disconnected;
    }

    private class TerminateThread
    extends Thread {
        protected TerminateThread() {
            super("Terminiate Thread");
        }

        @Override
        public void run() {
            try {
                CCSLDebugThread.this.sim.finish();
                CCSLDebugThread.this.getDebugTarget().terminate();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private class ThreadRun
    extends Thread {
        public ThreadRun() {
            super("Running solver");
        }

        @Override
        public void run() {
            try {
                CCSLDebugThread.this.sim.steprun();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            try {
                CCSLDebugThread.this.endofStep();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            CCSLDebugThread.this.sim.finish();
        }
    }

    public class ThreadStart
    extends Thread {
        protected ThreadStart() {
            super("Starting Solver");
        }

        @Override
        public void run() {
            try {
                CCSLDebugThread.this.sim.init();
                CCSLDebugThread.this.fireCreationEvent();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private class ThreadStep
    extends Thread {
        public ThreadStep() {
            super("resolve 1 step");
        }

        @Override
        public void run() {
            try {
                CCSLDebugThread.this.sim.step(false);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            try {
                CCSLDebugThread.this.endofStep();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    private class ThreadStepN
    extends Thread {
        int nb;

        public ThreadStepN(int nb) {
            super("resolve " + nb + " steps");
            this.nb = nb;
        }

        @Override
        public void run() {
            try {
                CCSLDebugThread.this.sim.step(this.nb);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            try {
                CCSLDebugThread.this.endofStep();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }
}

