/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.instantrelation.generator.metier;

import fr.inria.aoste.timesquare.instantrelation.CCSLRelationModel.CCSLConstraintRef;
import fr.inria.aoste.timesquare.instantrelation.CCSLRelationModel.CCSLRelationModelFactory;
import fr.inria.aoste.timesquare.instantrelation.CCSLRelationModel.Packet;
import fr.inria.aoste.timesquare.instantrelation.exceptions.ResolveClockConstraintException;
import fr.inria.aoste.timesquare.instantrelation.generator.metier.AbstractCreator;
import fr.inria.aoste.timesquare.instantrelation.generator.metier.Description;
import fr.inria.aoste.trace.EventOccurrence;
import fr.inria.aoste.trace.ModelElementReference;

public class CreatorPacketSustain
extends AbstractCreator {
    final ModelElementReference clock;
    final ModelElementReference trigger;
    final ModelElementReference upto;
    Packet relationPacket = null;

    public CreatorPacketSustain(CCSLConstraintRef cref, ModelElementReference clock, ModelElementReference trigger, ModelElementReference upto) {
        super(cref);
        this.clock = clock;
        this.trigger = trigger;
        this.upto = upto;
    }

    @Override
    public void resolve() throws ResolveClockConstraintException {
        EventOccurrence l = this.getEventOccurrenceOnStepTrace(this.clock);
        EventOccurrence t = this.getEventOccurrenceOnStepTrace(this.trigger);
        EventOccurrence u = this.getEventOccurrenceOnStepTrace(this.upto);
        boolean bt = this.clockTick(t);
        boolean b1 = this.clockTick(l);
        boolean bu = this.clockTick(u);
        if (bt) {
            this.create();
        }
        if (b1) {
            this.add(l);
        }
        if (bu) {
            this.remove();
        }
    }

    protected void remove() {
        this.addRelation(this.relationPacket);
        this.relationPacket = null;
    }

    protected void add(EventOccurrence l) {
        if (this.relationPacket != null) {
            this.relationPacket.getOccurrences().add((Object)l);
        }
    }

    protected void create() {
        if (this.relationPacket == null) {
            this.relationPacket = CCSLRelationModelFactory.eINSTANCE.createPacket();
        }
    }

    @Override
    public Description createDescription() {
        return Description.createDescriptionPacket(this.clock, this.getCcslConstraintRef());
    }

    @Override
    public void finish() {
        if (this.relationPacket != null && this.relationPacket.getOccurrences().size() != 0) {
            this.addRelation(this.relationPacket);
        }
        this.relationPacket = null;
    }

    @Override
    protected void init() {
    }
}

