/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.instantrelation.ccslkernel;

import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.BasicType.BooleanElement;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.BasicType.Element;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.BasicType.IntegerElement;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.BasicType.SequenceElement;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockConstraintSystem;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.KernelExpression.Concatenation;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.KernelExpression.Defer;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.KernelExpression.Inf;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.KernelExpression.Intersection;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.KernelExpression.NonStrictSampling;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.KernelExpression.StrictSampling;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.KernelExpression.Sup;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.KernelExpression.Union;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.KernelExpression.UpTo;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.KernelExpression.Wait;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.KernelExpression.util.KernelExpressionSwitch;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.KernelRelation.Coincidence;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.KernelRelation.KernelRelationDeclaration;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.KernelRelation.NonStrictPrecedence;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.KernelRelation.Precedence;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.KernelRelation.SubClock;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.KernelRelation.util.KernelRelationSwitch;
import fr.inria.aoste.timesquare.ccslkernel.modelunfolding.InstantiatedElement;
import fr.inria.aoste.timesquare.ccslkernel.modelunfolding.InstantiationPath;
import fr.inria.aoste.timesquare.ccslkernel.modelunfolding.UnfoldModel;
import fr.inria.aoste.timesquare.ccslkernel.modelunfolding.exception.UnfoldingException;
import fr.inria.aoste.timesquare.instantrelation.CCSLRelationModel.CCSLConstraintRef;
import fr.inria.aoste.timesquare.instantrelation.generator.InstantRelationModelGenerator;
import fr.inria.aoste.trace.ModelElementReference;
import fr.inria.aoste.trace.Reference;
import java.io.IOException;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;

public class CCSLKernelInstantRelationModelStructure {
    private InstantRelationModelGenerator instantRelationModelGenerator;

    public CCSLKernelInstantRelationModelStructure(InstantRelationModelGenerator relationModelSolver) {
        this.instantRelationModelGenerator = relationModelSolver;
    }

    public void setCCSLRelationModelSolver(InstantRelationModelGenerator relationModelSolver) {
        this.instantRelationModelGenerator = relationModelSolver;
    }

    public InstantRelationModelGenerator getCCSLRelationModelSolver() {
        return this.instantRelationModelGenerator;
    }

    public boolean getModelRoot(EObject eo1) {
        while (eo1 != null) {
            if (eo1 instanceof ClockConstraintSystem) {
                this.setClockConstraintList((ClockConstraintSystem)eo1);
                return true;
            }
            eo1 = eo1.eContainer();
        }
        return false;
    }

    private void setClockConstraintList(ClockConstraintSystem clockConstraintSystem) {
        UnfoldModel umodel = null;
        try {
            Resource resource = clockConstraintSystem.eResource();
            if (resource == null) {
                resource = new XMIResourceImpl();
                resource.getContents().add((Object)clockConstraintSystem);
            }
            umodel = UnfoldModel.unfoldModel((Resource)resource);
        }
        catch (IOException e1) {
            return;
        }
        catch (UnfoldingException e) {
            return;
        }
        KernelRelationConstraintBuilder rBuilder = new KernelRelationConstraintBuilder();
        KernelExpressionConstraintBuilder eBuilder = new KernelExpressionConstraintBuilder();
        for (InstantiatedElement element : umodel.getInstantiationTree().lookupInstances(null)) {
            if (element.isKernelRelation() && !element.isAssertion() && !element.isConditionCase()) {
                rBuilder.generateInstantRelation(element);
                continue;
            }
            if (element.isKernelRelation() && !element.isAssertion() && element.isConditionCase()) {
                Element testValue;
                InstantiatedElement test = element.getConditionTest();
                if (test == null || !test.isConstant() || !((testValue = test.getValue()) instanceof BooleanElement) || !((BooleanElement)testValue).getValue().booleanValue()) continue;
                rBuilder.generateInstantRelation(element);
                continue;
            }
            if (element.isKernelRelation() && !element.isAssertion() && !element.inConditionalBranch()) {
                rBuilder.generateInstantRelation(element);
                continue;
            }
            if (element.isKernelRelation() && !element.isAssertion() && element.inConditionalBranch()) {
                List tests = element.getBranchConditionTests();
                boolean allTrue = true;
                for (InstantiatedElement test : tests) {
                    if (test.isConstant()) {
                        Element testValue = test.getValue();
                        if (testValue instanceof BooleanElement && ((BooleanElement)testValue).getValue() != Boolean.FALSE) continue;
                        allTrue = false;
                        break;
                    }
                    allTrue = false;
                    break;
                }
                if (!allTrue) continue;
                rBuilder.generateInstantRelation(element);
                continue;
            }
            if (element.isKernelExpression()) {
                eBuilder.generateInstantRelation(element);
                continue;
            }
            if (element.isRecursiveCall()) continue;
            if (element.isExpression() && !element.isConditional()) {
                ModelElementReference expRef = this.getConstraintModelElementReference(element);
                ModelElementReference iClockRef = this.getClockModelElementReference(element);
                if (element.getRootExpression() == null) continue;
                ModelElementReference rootRef = this.getClockModelElementReference(element.getRootExpression());
                CCSLConstraintRef cRef = this.instantRelationModelGenerator.addAndCreateEqual(iClockRef, rootRef);
                cRef.setCcslConstraint((Reference)expRef);
                continue;
            }
            if (element.isExpression() && element.isConditional()) {
                for (InstantiatedElement son : element.getSons()) {
                    Element testValue;
                    InstantiatedElement test;
                    if (!son.isConditionCase() || (test = son.getConditionTest()) == null || !test.isConstant() || !((testValue = test.getValue()) instanceof BooleanElement) || !((BooleanElement)testValue).getValue().booleanValue()) continue;
                    ModelElementReference expRef = this.getConstraintModelElementReference(element);
                    ModelElementReference iClockRef = this.getClockModelElementReference(element);
                    ModelElementReference caseRef = this.getClockModelElementReference(son);
                    CCSLConstraintRef cRef = this.instantRelationModelGenerator.addAndCreateEqual(iClockRef, caseRef);
                    cRef.setCcslConstraint((Reference)expRef);
                }
                continue;
            }
            if (!element.isRelation()) continue;
            element.isConditional();
        }
    }

    private ModelElementReference getClockModelElementReference(InstantiatedElement element) {
        InstantiationPath instPath = element.getInstantiationPath();
        EObject[] path = (EObject[])instPath.toArray((Object[])new EObject[instPath.size()]);
        ModelElementReference ref = this.instantRelationModelGenerator.searchClock(path);
        return ref;
    }

    private ModelElementReference getConstraintModelElementReference(InstantiatedElement element) {
        InstantiationPath instPath = element.getInstantiationPath();
        EObject[] path = (EObject[])instPath.toArray((Object[])new EObject[instPath.size()]);
        ModelElementReference ref = this.instantRelationModelGenerator.searchConstraint(path);
        return ref;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KernelExpressionConstraintBuilder
    extends KernelExpressionSwitch<CCSLConstraintRef> {
        private InstantiatedElement expression;
        private ModelElementReference expressionRef;

        private KernelExpressionConstraintBuilder() {
        }

        public void generateInstantRelation(InstantiatedElement expression) {
            this.expression = expression;
            this.expressionRef = CCSLKernelInstantRelationModelStructure.this.getConstraintModelElementReference(expression);
            CCSLConstraintRef cRef = (CCSLConstraintRef)this.doSwitch((EObject)expression.getDeclaration());
            if (cRef != null) {
                cRef.setCcslConstraint((Reference)this.expressionRef);
            }
        }

        public CCSLConstraintRef caseConcatenation(Concatenation object) {
            InstantiatedElement left = this.expression.resolveAbstractEntity(object.getLeftClock());
            InstantiatedElement right = this.expression.resolveAbstractEntity(object.getRightClock());
            ModelElementReference leftRef = CCSLKernelInstantRelationModelStructure.this.getClockModelElementReference(left);
            ModelElementReference rightRef = CCSLKernelInstantRelationModelStructure.this.getClockModelElementReference(right);
            CCSLConstraintRef cRef = CCSLKernelInstantRelationModelStructure.this.instantRelationModelGenerator.addAndCreateConcatenation(this.expressionRef, leftRef, rightRef);
            return cRef;
        }

        public CCSLConstraintRef caseIntersection(Intersection object) {
            InstantiatedElement left = this.expression.resolveAbstractEntity(object.getClock1());
            InstantiatedElement right = this.expression.resolveAbstractEntity(object.getClock2());
            ModelElementReference leftRef = CCSLKernelInstantRelationModelStructure.this.getClockModelElementReference(left);
            ModelElementReference rightRef = CCSLKernelInstantRelationModelStructure.this.getClockModelElementReference(right);
            CCSLConstraintRef cRef = CCSLKernelInstantRelationModelStructure.this.instantRelationModelGenerator.addandCreateInterOrUnion(this.expressionRef, leftRef, rightRef);
            return cRef;
        }

        public CCSLConstraintRef caseUnion(Union object) {
            InstantiatedElement left = this.expression.resolveAbstractEntity(object.getClock1());
            InstantiatedElement right = this.expression.resolveAbstractEntity(object.getClock2());
            ModelElementReference leftRef = CCSLKernelInstantRelationModelStructure.this.getClockModelElementReference(left);
            ModelElementReference rightRef = CCSLKernelInstantRelationModelStructure.this.getClockModelElementReference(right);
            CCSLConstraintRef cRef = CCSLKernelInstantRelationModelStructure.this.instantRelationModelGenerator.addandCreateInterOrUnion(this.expressionRef, leftRef, rightRef);
            return cRef;
        }

        public CCSLConstraintRef caseDefer(Defer object) {
            SequenceElement value;
            InstantiatedElement base = this.expression.resolveAbstractEntity(object.getBaseClock());
            InstantiatedElement delay = this.expression.resolveAbstractEntity(object.getDelayClock());
            ModelElementReference baseRef = CCSLKernelInstantRelationModelStructure.this.getClockModelElementReference(base);
            ModelElementReference delayRef = CCSLKernelInstantRelationModelStructure.this.getClockModelElementReference(delay);
            InstantiatedElement delayPattern = this.expression.resolveAbstractEntity(object.getDelayPattern());
            int constantDelay = -1;
            if (delayPattern.isConstant() && delayPattern.getValue() instanceof SequenceElement && (value = (SequenceElement)delayPattern.getValue()).getFinitePart().isEmpty() && value.getNonFinitePart().size() == 1 && value.getNonFinitePart().get(0) instanceof IntegerElement) {
                constantDelay = ((IntegerElement)value.getNonFinitePart().get(0)).getValue();
            }
            CCSLConstraintRef cRef = null;
            cRef = CCSLKernelInstantRelationModelStructure.this.instantRelationModelGenerator.addandCreateDelayedFor(this.expressionRef, baseRef, delayRef, constantDelay);
            return cRef;
        }

        public CCSLConstraintRef caseStrictSampling(StrictSampling object) {
            InstantiatedElement sampling = this.expression.resolveAbstractEntity(object.getSamplingClock());
            InstantiatedElement sampled = this.expression.resolveAbstractEntity(object.getSampledClock());
            ModelElementReference samplingRef = CCSLKernelInstantRelationModelStructure.this.getClockModelElementReference(sampling);
            ModelElementReference sampledRef = CCSLKernelInstantRelationModelStructure.this.getClockModelElementReference(sampled);
            CCSLConstraintRef cRef = CCSLKernelInstantRelationModelStructure.this.instantRelationModelGenerator.addandCreateSampledOn(this.expressionRef, samplingRef, sampledRef, true);
            return cRef;
        }

        public CCSLConstraintRef caseNonStrictSampling(NonStrictSampling object) {
            InstantiatedElement sampling = this.expression.resolveAbstractEntity(object.getSamplingClock());
            InstantiatedElement sampled = this.expression.resolveAbstractEntity(object.getSampledClock());
            ModelElementReference samplingRef = CCSLKernelInstantRelationModelStructure.this.getClockModelElementReference(sampling);
            ModelElementReference sampledRef = CCSLKernelInstantRelationModelStructure.this.getClockModelElementReference(sampled);
            CCSLConstraintRef cRef = CCSLKernelInstantRelationModelStructure.this.instantRelationModelGenerator.addandCreateSampledOn(this.expressionRef, samplingRef, sampledRef, false);
            return cRef;
        }

        public CCSLConstraintRef caseInf(Inf object) {
            InstantiatedElement left = this.expression.resolveAbstractEntity(object.getClock1());
            InstantiatedElement right = this.expression.resolveAbstractEntity(object.getClock2());
            ModelElementReference leftRef = CCSLKernelInstantRelationModelStructure.this.getClockModelElementReference(left);
            ModelElementReference rightRef = CCSLKernelInstantRelationModelStructure.this.getClockModelElementReference(right);
            ModelElementReference[] refTab = new ModelElementReference[]{leftRef, rightRef};
            CCSLConstraintRef cRef = CCSLKernelInstantRelationModelStructure.this.instantRelationModelGenerator.addandCreateInf(this.expressionRef, refTab);
            return cRef;
        }

        public CCSLConstraintRef caseSup(Sup object) {
            InstantiatedElement left = this.expression.resolveAbstractEntity(object.getClock1());
            InstantiatedElement right = this.expression.resolveAbstractEntity(object.getClock2());
            ModelElementReference leftRef = CCSLKernelInstantRelationModelStructure.this.getClockModelElementReference(left);
            ModelElementReference rightRef = CCSLKernelInstantRelationModelStructure.this.getClockModelElementReference(right);
            ModelElementReference[] refTab = new ModelElementReference[]{leftRef, rightRef};
            CCSLConstraintRef cRef = CCSLKernelInstantRelationModelStructure.this.instantRelationModelGenerator.addandCreateSup(this.expressionRef, refTab);
            return cRef;
        }

        public CCSLConstraintRef caseUpTo(UpTo object) {
            InstantiatedElement follow = this.expression.resolveAbstractEntity(object.getClockToFollow());
            InstantiatedElement killer = this.expression.resolveAbstractEntity(object.getKillerClock());
            ModelElementReference followRef = CCSLKernelInstantRelationModelStructure.this.getClockModelElementReference(follow);
            ModelElementReference killerRef = CCSLKernelInstantRelationModelStructure.this.getClockModelElementReference(killer);
            CCSLConstraintRef cRef = CCSLKernelInstantRelationModelStructure.this.instantRelationModelGenerator.addAndCreateUpTo(this.expressionRef, followRef, killerRef);
            return cRef;
        }

        public CCSLConstraintRef caseWait(Wait object) {
            InstantiatedElement waiting = this.expression.resolveAbstractEntity(object.getWaitingClock());
            ModelElementReference waitingRef = CCSLKernelInstantRelationModelStructure.this.getClockModelElementReference(waiting);
            CCSLConstraintRef cRef = CCSLKernelInstantRelationModelStructure.this.instantRelationModelGenerator.addAndCreateEqual(this.expressionRef, waitingRef);
            return cRef;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KernelRelationConstraintBuilder
    extends KernelRelationSwitch<CCSLConstraintRef> {
        private ModelElementReference relationRef;
        private ModelElementReference leftRef;
        private ModelElementReference rightRef;

        private KernelRelationConstraintBuilder() {
        }

        public void generateInstantRelation(InstantiatedElement relation) {
            this.relationRef = CCSLKernelInstantRelationModelStructure.this.getConstraintModelElementReference(relation);
            KernelRelationDeclaration decl = (KernelRelationDeclaration)relation.getDeclaration();
            InstantiatedElement left = relation.resolveAbstractEntity(decl.getLeftEntity());
            this.leftRef = CCSLKernelInstantRelationModelStructure.this.getClockModelElementReference(left);
            InstantiatedElement right = relation.resolveAbstractEntity(decl.getRightEntity());
            this.rightRef = CCSLKernelInstantRelationModelStructure.this.getClockModelElementReference(right);
            CCSLConstraintRef cRef = (CCSLConstraintRef)this.doSwitch((EObject)decl);
            if (cRef != null) {
                cRef.setCcslConstraint((Reference)this.relationRef);
            }
        }

        public CCSLConstraintRef caseCoincidence(Coincidence object) {
            CCSLConstraintRef cRef = CCSLKernelInstantRelationModelStructure.this.instantRelationModelGenerator.addAndCreateEqual(this.leftRef, this.rightRef);
            return cRef;
        }

        public CCSLConstraintRef casePrecedence(Precedence object) {
            CCSLConstraintRef cRef = CCSLKernelInstantRelationModelStructure.this.instantRelationModelGenerator.addAndCreatePrecedes(this.leftRef, this.rightRef, 1, 1, true);
            return cRef;
        }

        public CCSLConstraintRef caseNonStrictPrecedence(NonStrictPrecedence object) {
            CCSLConstraintRef cRef = CCSLKernelInstantRelationModelStructure.this.instantRelationModelGenerator.addAndCreatePrecedes(this.leftRef, this.rightRef, 1, 1, false);
            return cRef;
        }

        public CCSLConstraintRef caseSubClock(SubClock object) {
            CCSLConstraintRef cRef = CCSLKernelInstantRelationModelStructure.this.instantRelationModelGenerator.addAndCreateEqual(this.leftRef, this.rightRef);
            return cRef;
        }
    }
}

