/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.backend.obeoviewpointanimator;

import fr.inria.aoste.timesquare.backend.manager.visible.Behavior;
import fr.inria.aoste.timesquare.backend.manager.visible.ClockBehaviorAgain;
import fr.inria.aoste.timesquare.backend.manager.visible.ClockEntity;
import fr.inria.aoste.timesquare.backend.manager.visible.TraceHelper;
import fr.inria.aoste.timesquare.trace.util.adapter.AdapterRegistry;
import fr.inria.aoste.timesquare.trace.util.adapter.IModelAdapter;
import java.util.ArrayList;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sirius.diagram.BorderedStyle;
import org.eclipse.sirius.diagram.ContainerStyle;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.DNodeContainer;
import org.eclipse.sirius.diagram.DNodeList;
import org.eclipse.sirius.diagram.DiagramFactory;
import org.eclipse.sirius.diagram.EdgeStyle;
import org.eclipse.sirius.diagram.Ellipse;
import org.eclipse.sirius.diagram.FlatContainerStyle;
import org.eclipse.sirius.diagram.Lozenge;
import org.eclipse.sirius.diagram.NodeStyle;
import org.eclipse.sirius.diagram.ShapeContainerStyle;
import org.eclipse.sirius.diagram.Square;
import org.eclipse.sirius.viewpoint.DRepresentationElement;
import org.eclipse.sirius.viewpoint.RGBValues;
import org.eclipse.sirius.viewpoint.Style;
import org.eclipse.sirius.viewpoint.ViewpointFactory;

public class AnimateTicksBehaviour
implements ClockBehaviorAgain {
    private int _clockCounter = 0;
    private ArrayList<DRepresentationElement> _representations = new ArrayList();
    private ArrayList<Style> _originalStyle = null;
    private TransactionalEditingDomain _ted = null;
    private TraceHelper _helper = null;
    final ClockEntity _ce;
    private IModelAdapter.EventEnumerator _ek = null;
    boolean receiveDone = false;

    public AnimateTicksBehaviour(ClockEntity ce) {
        this._ce = ce;
        this._ek = AdapterRegistry.getAdapter((EObject)this._ce.getClock()).getEventkind(this._ce.getClock());
    }

    public String getDescription() {
        return "Obeo Viewpoint Animator";
    }

    public void setRepresentation(ArrayList<DRepresentationElement> representations) {
        this._representations = representations;
        this._originalStyle = new ArrayList();
    }

    public void start(TransactionalEditingDomain ted) {
        this._ted = ted;
        if (this._representations == null) {
            return;
        }
        for (DRepresentationElement repr : this._representations) {
            this._originalStyle.add(repr.getStyle());
        }
    }

    private void changeBorderSize(DRepresentationElement repr, RGBValues newColor, int newVBorderSize) {
        if (repr instanceof DNodeList || repr instanceof DNode || repr instanceof DNodeContainer || repr instanceof DEdge) {
            ChangeBorderCommand doChangeBorderSize = new ChangeBorderCommand(this._ted, repr, newColor, newVBorderSize);
            this._ted.getCommandStack().execute((Command)doChangeBorderSize);
        }
    }

    public void run(TraceHelper helper) {
        if (this._representations.size() > 0) {
            this._helper = helper;
            this._clockCounter = helper.getClockState().getCounter();
            RGBValues highlightedColor = ViewpointFactory.eINSTANCE.createRGBValues();
            ChangeColor doChangeColor = new ChangeColor(this._ted, highlightedColor, 255, 0, 0);
            this._ted.getCommandStack().execute((Command)doChangeColor);
            if (this._ce.getReferencedElement().size() > 0) {
                for (DRepresentationElement repr : this._representations) {
                    switch (this._ek) {
                        case START: {
                            if (this._originalStyle.get(this._representations.indexOf(repr)) != null && repr.getStyle().equals(this._originalStyle.get(this._representations.indexOf(repr)))) {
                                doChangeColor = new ChangeColor(this._ted, highlightedColor, 255, 0, 0);
                                this._ted.getCommandStack().execute((Command)doChangeColor);
                                this.changeBorderSize(repr, highlightedColor, 7);
                                break;
                            }
                            RGBValues newColor = ViewpointFactory.eINSTANCE.createRGBValues();
                            doChangeColor = new ChangeColor(this._ted, highlightedColor, 255, 20, 0);
                            this._ted.getCommandStack().execute((Command)doChangeColor);
                            this.changeBorderSize(repr, newColor, 7);
                            break;
                        }
                        case SEND: {
                            if (this._originalStyle.get(this._representations.indexOf(repr)) != null && repr.getStyle().equals(this._originalStyle.get(this._representations.indexOf(repr)))) {
                                doChangeColor = new ChangeColor(this._ted, highlightedColor, 0, 255, 0);
                                this._ted.getCommandStack().execute((Command)doChangeColor);
                                this.changeBorderSize(repr, highlightedColor, 7);
                                break;
                            }
                            RGBValues newColor = ViewpointFactory.eINSTANCE.createRGBValues();
                            doChangeColor = new ChangeColor(this._ted, highlightedColor, 20, 255, 0);
                            this._ted.getCommandStack().execute((Command)doChangeColor);
                            this.changeBorderSize(repr, newColor, 7);
                            break;
                        }
                        case PRODUCE: {
                            if (this._originalStyle.get(this._representations.indexOf(repr)) != null && repr.getStyle().equals(this._originalStyle.get(this._representations.indexOf(repr)))) {
                                doChangeColor = new ChangeColor(this._ted, highlightedColor, 127, 0, 0);
                                this._ted.getCommandStack().execute((Command)doChangeColor);
                                this.changeBorderSize(repr, highlightedColor, 7);
                                break;
                            }
                            doChangeColor = new ChangeColor(this._ted, highlightedColor, 127, 20, 0);
                            this._ted.getCommandStack().execute((Command)doChangeColor);
                            this.changeBorderSize(repr, highlightedColor, 7);
                            break;
                        }
                        case FINISH: {
                            Style s = this._originalStyle.get(this._representations.indexOf(repr));
                            RestoreStyleCommand doRestoreStyle = new RestoreStyleCommand(this._ted, repr, s);
                            this._ted.getCommandStack().execute((Command)doRestoreStyle);
                            break;
                        }
                        case CONSUME: {
                            Style s = this._originalStyle.get(this._representations.indexOf(repr));
                            RestoreStyleCommand doRestoreStyle = new RestoreStyleCommand(this._ted, repr, s);
                            this._ted.getCommandStack().execute((Command)doRestoreStyle);
                            break;
                        }
                        case RECEIVE: {
                            if (this._originalStyle.get(this._representations.indexOf(repr)) != null && repr.getStyle().equals(this._originalStyle.get(this._representations.indexOf(repr)))) {
                                doChangeColor = new ChangeColor(this._ted, highlightedColor, 0, 0, 255);
                                this._ted.getCommandStack().execute((Command)doChangeColor);
                                this.changeBorderSize(repr, highlightedColor, 7);
                            } else {
                                RGBValues newColor = ViewpointFactory.eINSTANCE.createRGBValues();
                                doChangeColor = new ChangeColor(this._ted, highlightedColor, 0, 255, 30);
                                this._ted.getCommandStack().execute((Command)doChangeColor);
                                this.changeBorderSize(repr, newColor, 7);
                            }
                            this.receiveDone = true;
                            break;
                        }
                        case UNDEFINED: {
                            Style style = null;
                            try {
                                style = this._representations.get(this._originalStyle.indexOf(repr)).getStyle();
                            }
                            catch (ArrayIndexOutOfBoundsException e) {
                                style = repr.getStyle();
                            }
                            if (style instanceof Square) {
                                doChangeColor = new ChangeColor(this._ted, highlightedColor, Math.abs(255 - ((Square)style).getColor().getGreen()), Math.abs(255 - ((Square)style).getColor().getRed()), Math.abs(255 - ((Square)style).getColor().getBlue()));
                                this._ted.getCommandStack().execute((Command)doChangeColor);
                            }
                            if (style instanceof Ellipse) {
                                doChangeColor = new ChangeColor(this._ted, highlightedColor, Math.abs(255 - ((Ellipse)style).getColor().getGreen()), Math.abs(255 - ((Ellipse)style).getColor().getRed()), Math.abs(255 - ((Ellipse)style).getColor().getBlue()));
                                this._ted.getCommandStack().execute((Command)doChangeColor);
                            }
                            if (style instanceof Lozenge) {
                                doChangeColor = new ChangeColor(this._ted, highlightedColor, Math.abs(255 - ((Lozenge)style).getColor().getGreen()), Math.abs(255 - ((Lozenge)style).getColor().getRed()), Math.abs(255 - ((Lozenge)style).getColor().getBlue()));
                                this._ted.getCommandStack().execute((Command)doChangeColor);
                            }
                            if (style instanceof ShapeContainerStyle) {
                                doChangeColor = new ChangeColor(this._ted, highlightedColor, Math.abs(255 - ((ShapeContainerStyle)style).getBackgroundColor().getGreen()), Math.abs(255 - ((ShapeContainerStyle)style).getBackgroundColor().getRed()), Math.abs(255 - ((ShapeContainerStyle)style).getBackgroundColor().getBlue()));
                                this._ted.getCommandStack().execute((Command)doChangeColor);
                            }
                            if (style instanceof FlatContainerStyle) {
                                doChangeColor = new ChangeColor(this._ted, highlightedColor, Math.abs(255 - ((FlatContainerStyle)style).getBackgroundColor().getGreen()), Math.abs(255 - ((FlatContainerStyle)style).getBackgroundColor().getRed()), Math.abs(255 - ((FlatContainerStyle)style).getBackgroundColor().getBlue()));
                                this._ted.getCommandStack().execute((Command)doChangeColor);
                            }
                            int size = 0;
                            if (style instanceof BorderedStyle) {
                                size = ((BorderedStyle)style).getBorderSize();
                            }
                            this.changeBorderSize(repr, highlightedColor, size + 1);
                        }
                    }
                }
            }
            this._helper = null;
        }
    }

    void finish() {
        this._representations = null;
        this._originalStyle = null;
        this._ted = null;
        this._helper = null;
        this._ek = null;
    }

    public void runWithWrongActivationState(TraceHelper helper) {
        if (this._representations.size() > 0) {
            this._helper = helper;
            this._clockCounter = helper.getClockState().getCounter();
            if (this._ce.getReferencedElement().size() > 0) {
                RestoreStyleCommand doRestoreStyle;
                Style s;
                if (this._ek == IModelAdapter.EventEnumerator.UNDEFINED) {
                    for (DRepresentationElement repr : this._representations) {
                        s = this._originalStyle.get(this._representations.indexOf(repr));
                        doRestoreStyle = new RestoreStyleCommand(this._ted, repr, s);
                        this._ted.getCommandStack().execute((Command)doRestoreStyle);
                    }
                }
                if (this._ek == IModelAdapter.EventEnumerator.RECEIVE && this.receiveDone) {
                    this.receiveDone = false;
                    for (DRepresentationElement repr : this._representations) {
                        s = this._originalStyle.get(this._representations.indexOf(repr));
                        doRestoreStyle = new RestoreStyleCommand(this._ted, repr, s);
                        this._ted.getCommandStack().execute((Command)doRestoreStyle);
                    }
                }
            }
            this._helper = null;
        }
    }

    public void againRun(TraceHelper helper) {
        this.run(helper);
    }

    public void againRunWithWrongActivationState(TraceHelper helper) {
        this.runWithWrongActivationState(helper);
    }

    public boolean behaviorEquals(Behavior behavior) {
        return behavior == this;
    }

    public ClockEntity get_ce() {
        return this._ce;
    }

    private static final class ChangeBorderCommand
    extends RecordingCommand {
        private int _borderSize = 1;
        private ContainerStyle _Cstyle = null;
        private EdgeStyle _Estyle = null;
        private NodeStyle _Sstyle = null;
        private DRepresentationElement _repr = null;
        private RGBValues _newColor = null;
        private RGBValues _backGroundColor = null;

        public ChangeBorderCommand(TransactionalEditingDomain domain, DRepresentationElement repr, RGBValues newColor, int newBorderSize) {
            super(domain);
            Style originalStyle = repr.getStyle();
            if (originalStyle instanceof EdgeStyle) {
                this._borderSize = newBorderSize;
                this._Estyle = DiagramFactory.eINSTANCE.createEdgeStyle();
                this._newColor = newColor;
                this._repr = repr;
                return;
            }
            if (originalStyle instanceof ShapeContainerStyle) {
                this._borderSize = newBorderSize;
                this._Cstyle = DiagramFactory.eINSTANCE.createShapeContainerStyle();
                this._newColor = newColor;
                this._repr = repr;
                return;
            }
            if (originalStyle instanceof FlatContainerStyle) {
                this._borderSize = newBorderSize;
                this._Cstyle = DiagramFactory.eINSTANCE.createFlatContainerStyle();
                this._backGroundColor = ((FlatContainerStyle)originalStyle).getBackgroundColor();
                this._newColor = newColor;
                this._repr = repr;
                return;
            }
            if (originalStyle instanceof ContainerStyle) {
                this._borderSize = newBorderSize;
                this._Cstyle = DiagramFactory.eINSTANCE.createShapeContainerStyle();
                this._newColor = newColor;
                this._repr = repr;
                return;
            }
            if (originalStyle instanceof Square) {
                this._borderSize = newBorderSize;
                this._Sstyle = DiagramFactory.eINSTANCE.createSquare();
                this._backGroundColor = ((Square)originalStyle).getColor();
                this._newColor = newColor;
                this._repr = repr;
                return;
            }
            if (originalStyle instanceof Ellipse) {
                this._borderSize = newBorderSize;
                this._Sstyle = DiagramFactory.eINSTANCE.createEllipse();
                this._backGroundColor = ((Ellipse)originalStyle).getColor();
                this._newColor = newColor;
                this._repr = repr;
                return;
            }
            if (originalStyle instanceof Lozenge) {
                this._borderSize = newBorderSize;
                this._Sstyle = DiagramFactory.eINSTANCE.createLozenge();
                this._backGroundColor = ((Lozenge)originalStyle).getColor();
                this._newColor = newColor;
                this._repr = repr;
                return;
            }
            if (originalStyle instanceof DNode) {
                this._borderSize = newBorderSize;
                this._Sstyle = DiagramFactory.eINSTANCE.createEllipse();
                this._newColor = newColor;
                this._repr = repr;
                return;
            }
        }

        protected void doExecute() {
            if (this._repr instanceof DNodeList) {
                this._Cstyle.setBorderSize(Integer.valueOf(this._borderSize));
                this._Cstyle.setBorderColor(this._newColor);
                ((DNodeList)this._repr).setOwnedStyle(this._Cstyle);
                return;
            }
            if (this._repr instanceof DNodeContainer) {
                this._Cstyle.setBorderSize(Integer.valueOf(this._borderSize));
                this._Cstyle.setBorderColor(this._newColor);
                if (this._Cstyle instanceof ShapeContainerStyle) {
                    ((ShapeContainerStyle)this._Cstyle).setBackgroundColor(this._backGroundColor);
                } else {
                    ((FlatContainerStyle)this._Cstyle).setBackgroundColor(this._backGroundColor);
                }
                ((DNodeContainer)this._repr).setOwnedStyle(this._Cstyle);
                return;
            }
            if (this._repr instanceof DNode) {
                this._Sstyle.setBorderSize(Integer.valueOf(this._borderSize));
                this._Sstyle.setBorderColor(this._newColor);
                if (this._Sstyle instanceof Square) {
                    ((Square)this._Sstyle).setColor(this._backGroundColor);
                } else if (this._Sstyle instanceof Ellipse) {
                    ((Ellipse)this._Sstyle).setColor(this._backGroundColor);
                } else if (this._Sstyle instanceof Lozenge) {
                    ((Lozenge)this._Sstyle).setColor(this._backGroundColor);
                }
                ((DNode)this._repr).setOwnedStyle(this._Sstyle);
                return;
            }
            if (this._repr instanceof DEdge) {
                this._Estyle.setSize(Integer.valueOf(this._borderSize));
                this._Estyle.setStrokeColor(this._newColor);
                ((DEdge)this._repr).setOwnedStyle(this._Estyle);
                return;
            }
        }
    }

    private static final class ChangeColor
    extends RecordingCommand {
        private int red = 0;
        private int green = 0;
        private int blue = 0;
        private RGBValues color;

        public ChangeColor(TransactionalEditingDomain domain, RGBValues c, int R, int G, int B) {
            super(domain);
            this.red = R;
            this.green = G;
            this.blue = B;
            this.color = RGBValues.create((int)c.getRed(), (int)c.getGreen(), (int)c.getBlue());
        }

        protected void doExecute() {
            this.color = RGBValues.create((int)this.red, (int)this.green, (int)this.blue);
        }
    }

    private static final class RestoreStyleCommand
    extends RecordingCommand {
        private Style _style = null;
        private DRepresentationElement _repr = null;

        public RestoreStyleCommand(TransactionalEditingDomain domain, DRepresentationElement repr, Style style) {
            super(domain);
            this._style = style;
            this._repr = repr;
        }

        protected void doExecute() {
            if (this._repr instanceof DNodeList) {
                ((DNodeList)this._repr).setOwnedStyle((ContainerStyle)this._style);
                return;
            }
            if (this._repr instanceof DNodeContainer) {
                RGBValues color;
                if (this._style instanceof ShapeContainerStyle) {
                    color = ((ShapeContainerStyle)this._repr.getStyle()).getBackgroundColor();
                    ((ShapeContainerStyle)this._style).setBackgroundColor(color);
                }
                if (this._style instanceof FlatContainerStyle) {
                    color = ((FlatContainerStyle)this._repr.getStyle()).getBackgroundColor();
                    ((FlatContainerStyle)this._style).setBackgroundColor(color);
                }
                ((DNodeContainer)this._repr).setOwnedStyle((ContainerStyle)this._style);
                return;
            }
            if (this._repr instanceof DNode) {
                RGBValues color;
                if (this._style instanceof Square) {
                    color = ((Square)this._repr.getStyle()).getColor();
                    ((Square)this._style).setColor(color);
                }
                if (this._style instanceof Ellipse) {
                    color = ((Ellipse)this._repr.getStyle()).getColor();
                    ((Ellipse)this._style).setColor(color);
                }
                if (this._style instanceof Lozenge) {
                    color = ((Lozenge)this._repr.getStyle()).getColor();
                    ((Lozenge)this._style).setColor(color);
                }
                ((DNode)this._repr).setOwnedStyle((NodeStyle)this._style);
                return;
            }
            if (this._repr instanceof DEdge) {
                ((DEdge)this._repr).setOwnedStyle((EdgeStyle)this._style);
                return;
            }
        }
    }
}

