/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.backend.manager.datastructure.assertion;

import fr.inria.aoste.trace.AssertionState;

public class AssertActivationState {
    public static final int assertionNumber = 2;
    public static final String[] assertlist = new String[]{"satisfied", "failed"};
    private boolean[] _relation;

    public AssertActivationState(boolean[] relation) {
        this._relation = null;
        if (this.isValidRelation(relation)) {
            this._relation = relation;
        }
    }

    public AssertActivationState(AssertionState assertion) {
        if (assertion == null) {
            this._relation = null;
            return;
        }
        boolean[] tmp = new boolean[2];
        int i = 0;
        while (i < tmp.length) {
            tmp[i] = false;
            ++i;
        }
        if (!assertion.isIsViolated()) {
            tmp[0] = true;
        }
        if (assertion.isIsViolated()) {
            tmp[1] = true;
        }
        if (this.isValidRelation(tmp)) {
            this._relation = tmp;
        }
    }

    public boolean isValidRelation(boolean[] relation) {
        if (relation == null) {
            return false;
        }
        return relation.length == 2;
    }

    public boolean[] getAssertState() {
        return this._relation;
    }

    public String getDescription() {
        String tmp = "";
        if (this._relation == null) {
            return "null";
        }
        int i = 0;
        while (i < this._relation.length) {
            if (this._relation[i]) {
                tmp = tmp.length() == 0 ? tmp.concat(assertlist[i]) : tmp.concat("|" + assertlist[i]);
            }
            ++i;
        }
        return tmp;
    }

    public int hashCode() {
        int n = 0;
        int k = 1;
        int i = 0;
        while (i < this._relation.length) {
            if (this._relation[i]) {
                n += k;
            }
            if ((k *= 2) <= 0) {
                k = 1;
            }
            ++i;
        }
        return n;
    }

    public boolean equals(Object o) {
        AssertActivationState re;
        if (o == this) {
            return true;
        }
        if (o instanceof AssertActivationState && (re = (AssertActivationState)o).getAssertState().length == this._relation.length) {
            boolean b = true;
            int i = 0;
            while (i < this._relation.length) {
                if (re.getAssertState()[i] != this._relation[i]) {
                    b = false;
                }
                ++i;
            }
            return b;
        }
        return false;
    }

    public static boolean stateActivationOK(AssertActivationState clock1, AssertActivationState clock2) {
        if (clock1 == null || clock2 == null) {
            return false;
        }
        int i = 0;
        while (i < clock1.getAssertState().length) {
            if ((clock1.getAssertState()[i] && clock2.getAssertState()[i]) != clock2.getAssertState()[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

