/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.progress;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.commands.common.EventManager;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.internal.progress.GroupInfo;
import org.eclipse.ui.internal.progress.IJobProgressManagerListener;
import org.eclipse.ui.internal.progress.JobInfo;
import org.eclipse.ui.internal.progress.JobTreeElement;
import org.eclipse.ui.internal.progress.ProgressManager;
import org.eclipse.ui.internal.progress.ProgressManagerUtil;
import org.eclipse.ui.internal.progress.TaskInfo;
import org.eclipse.ui.progress.IProgressConstants;

public class FinishedJobs
extends EventManager {
    private static FinishedJobs theInstance;
    private IJobProgressManagerListener listener;
    private HashSet<JobTreeElement> keptjobinfos = new HashSet();
    private HashMap<JobTreeElement, Long> finishedTime = new HashMap();
    private static JobTreeElement[] EMPTY_INFOS;

    public static synchronized FinishedJobs getInstance() {
        if (theInstance == null) {
            theInstance = new FinishedJobs();
            EMPTY_INFOS = new JobTreeElement[0];
        }
        return theInstance;
    }

    private FinishedJobs() {
        this.listener = new IJobProgressManagerListener(){

            @Override
            public void addJob(JobInfo info) {
                FinishedJobs.this.checkForDuplicates(info);
            }

            @Override
            public void addGroup(GroupInfo info) {
                FinishedJobs.this.checkForDuplicates(info);
            }

            @Override
            public void refreshJobInfo(JobInfo info) {
                FinishedJobs.this.checkTasks(info);
            }

            @Override
            public void refreshGroup(GroupInfo info) {
            }

            @Override
            public void refreshAll() {
            }

            @Override
            public void removeJob(JobInfo info) {
                if (FinishedJobs.keep(info)) {
                    FinishedJobs.this.checkForDuplicates(info);
                    FinishedJobs.this.add(info);
                }
            }

            @Override
            public void removeGroup(GroupInfo group) {
            }

            @Override
            public boolean showsDebug() {
                return false;
            }
        };
        ProgressManager.getInstance().addListener(this.listener);
    }

    static boolean keep(JobInfo info) {
        Job job = info.getJob();
        if (job != null) {
            Object prop = job.getProperty(ProgressManagerUtil.KEEP_PROPERTY);
            if (prop instanceof Boolean && ((Boolean)prop).booleanValue()) {
                return true;
            }
            prop = job.getProperty(ProgressManagerUtil.KEEPONE_PROPERTY);
            if (prop instanceof Boolean && ((Boolean)prop).booleanValue()) {
                return true;
            }
            IStatus status = job.getResult();
            if (status != null && status.getSeverity() == 4) {
                return true;
            }
        }
        return false;
    }

    void addListener(KeptJobsListener l) {
        this.addListenerObject(l);
    }

    void removeListener(KeptJobsListener l) {
        this.removeListenerObject(l);
    }

    private void checkForDuplicates(GroupInfo info) {
        Object[] objectArray = info.getChildren();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object child = objectArray[n2];
            if (child instanceof JobInfo) {
                this.checkForDuplicates((JobInfo)child);
            }
            ++n2;
        }
    }

    private void checkForDuplicates(JobTreeElement info) {
        JobTreeElement[] toBeRemoved = this.findJobsToRemove(info);
        if (toBeRemoved != null) {
            JobTreeElement[] jobTreeElementArray = toBeRemoved;
            int n = toBeRemoved.length;
            int n2 = 0;
            while (n2 < n) {
                JobTreeElement element = jobTreeElementArray[n2];
                this.remove(element);
                ++n2;
            }
        }
    }

    private void add(JobInfo info) {
        boolean fire = false;
        if (!this.keptjobinfos.contains(info)) {
            this.keptjobinfos.add(info);
            long now = System.currentTimeMillis();
            this.finishedTime.put(info, now);
            GroupInfo parent = info.getParent();
            if (parent != null && !this.keptjobinfos.contains(parent)) {
                this.keptjobinfos.add(parent);
                this.finishedTime.put(parent, now);
            }
            fire = true;
        }
        if (fire) {
            Object[] objectArray = this.getListeners();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object listener = objectArray[n2];
                KeptJobsListener jv = (KeptJobsListener)listener;
                jv.finished(info);
                ++n2;
            }
        }
    }

    static void disposeAction(JobTreeElement jte) {
        Object prop;
        JobInfo ji;
        Job job;
        if (jte.isJobInfo() && (job = (ji = (JobInfo)jte).getJob()) != null && (prop = job.getProperty(IProgressConstants.ACTION_PROPERTY)) instanceof ActionFactory.IWorkbenchAction) {
            ((ActionFactory.IWorkbenchAction)prop).dispose();
        }
    }

    private JobTreeElement[] findJobsToRemove(JobTreeElement info) {
        Object prop;
        Job myJob;
        if (info.isJobInfo() && (myJob = ((JobInfo)info).getJob()) != null && (prop = myJob.getProperty(ProgressManagerUtil.KEEPONE_PROPERTY)) instanceof Boolean && ((Boolean)prop).booleanValue()) {
            JobTreeElement[] all;
            ArrayList<JobTreeElement> found = null;
            JobTreeElement[] jobTreeElementArray = all = this.keptjobinfos.toArray(new JobTreeElement[this.keptjobinfos.size()]);
            int n = all.length;
            int n2 = 0;
            while (n2 < n) {
                Job job;
                JobTreeElement jobTreeElement = jobTreeElementArray[n2];
                if (jobTreeElement != info && jobTreeElement.isJobInfo() && (job = ((JobInfo)jobTreeElement).getJob()) != null && job != myJob && job.belongsTo((Object)myJob)) {
                    if (found == null) {
                        found = new ArrayList<JobTreeElement>();
                    }
                    found.add(jobTreeElement);
                }
                ++n2;
            }
            if (found != null) {
                return found.toArray(new JobTreeElement[found.size()]);
            }
        }
        return null;
    }

    private void checkTasks(JobInfo info) {
        TaskInfo tinfo;
        if (FinishedJobs.keep(info) && (tinfo = info.getTaskInfo()) != null) {
            int n;
            int n2;
            Object[] objectArray;
            Object[] toBeRemoved = null;
            boolean fire = false;
            JobInfo element = tinfo.getParent();
            if (element == info && !this.keptjobinfos.contains(tinfo)) {
                toBeRemoved = this.findJobsToRemove(element);
                this.keptjobinfos.add(tinfo);
                this.finishedTime.put(tinfo, System.currentTimeMillis());
            }
            if (toBeRemoved != null) {
                objectArray = toBeRemoved;
                n2 = toBeRemoved.length;
                n = 0;
                while (n < n2) {
                    Object jobTreeElement = objectArray[n];
                    this.remove((JobTreeElement)jobTreeElement);
                    ++n;
                }
            }
            if (fire) {
                objectArray = this.getListeners();
                n2 = objectArray.length;
                n = 0;
                while (n < n2) {
                    Object listener = objectArray[n];
                    KeptJobsListener jv = (KeptJobsListener)listener;
                    jv.finished(info);
                    ++n;
                }
            }
        }
    }

    public void removeErrorJobs() {
        JobTreeElement[] infos;
        JobTreeElement[] jobTreeElementArray = infos = this.getKeptElements();
        int n = infos.length;
        int n2 = 0;
        while (n2 < n) {
            IStatus status;
            JobInfo info1;
            Job job;
            JobTreeElement info = jobTreeElementArray[n2];
            if (info.isJobInfo() && (job = (info1 = (JobInfo)info).getJob()) != null && (status = job.getResult()) != null && status.getSeverity() == 4) {
                JobTreeElement topElement = info1.getParent();
                if (topElement == null) {
                    topElement = info1;
                }
                FinishedJobs.getInstance().remove(topElement);
            }
            ++n2;
        }
    }

    boolean remove(JobTreeElement jte) {
        int n;
        boolean fire = false;
        boolean removed = false;
        if (this.keptjobinfos.remove(jte)) {
            JobTreeElement[] jtes;
            removed = true;
            this.finishedTime.remove(jte);
            FinishedJobs.disposeAction(jte);
            JobTreeElement[] jobTreeElementArray = jtes = this.keptjobinfos.toArray(new JobTreeElement[this.keptjobinfos.size()]);
            int n2 = jtes.length;
            n = 0;
            while (n < n2) {
                JobTreeElement jobTreeElement = jobTreeElementArray[n];
                JobTreeElement parent = jobTreeElement.getParent();
                if (parent != null && (parent == jte || parent.getParent() == jte)) {
                    if (this.keptjobinfos.remove(jobTreeElement)) {
                        FinishedJobs.disposeAction(jobTreeElement);
                    }
                    this.finishedTime.remove(jobTreeElement);
                }
                ++n;
            }
            fire = true;
        }
        if (fire) {
            Object[] objectArray = this.getListeners();
            n = objectArray.length;
            int n3 = 0;
            while (n3 < n) {
                Object listener = objectArray[n3];
                KeptJobsListener jv = (KeptJobsListener)listener;
                jv.removed(jte);
                ++n3;
            }
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JobTreeElement[] getKeptElements() {
        JobTreeElement[] all;
        if (this.keptjobinfos.isEmpty()) {
            return EMPTY_INFOS;
        }
        HashSet<JobTreeElement> hashSet = this.keptjobinfos;
        synchronized (hashSet) {
            all = this.keptjobinfos.toArray(new JobTreeElement[this.keptjobinfos.size()]);
        }
        return all;
    }

    public Date getFinishDate(JobTreeElement jte) {
        Long o = this.finishedTime.get(jte);
        if (o instanceof Long) {
            return new Date(o);
        }
        return null;
    }

    public boolean isKept(JobTreeElement element) {
        return this.keptjobinfos.contains(element);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAll() {
        HashSet<JobTreeElement> hashSet = this.keptjobinfos;
        synchronized (hashSet) {
            JobTreeElement[] all;
            JobTreeElement[] jobTreeElementArray = all = this.keptjobinfos.toArray(new JobTreeElement[this.keptjobinfos.size()]);
            int n = all.length;
            int n2 = 0;
            while (n2 < n) {
                JobTreeElement jobTreeElement = jobTreeElementArray[n2];
                FinishedJobs.disposeAction(jobTreeElement);
                ++n2;
            }
            this.keptjobinfos.clear();
            this.finishedTime.clear();
        }
        Object[] objectArray = this.getListeners();
        int n = objectArray.length;
        int n3 = 0;
        while (n3 < n) {
            Object listener = objectArray[n3];
            KeptJobsListener jv = (KeptJobsListener)listener;
            jv.removed(null);
            ++n3;
        }
    }

    Set<JobTreeElement> getKeptAsSet() {
        return this.keptjobinfos;
    }

    static interface KeptJobsListener {
        public void finished(JobTreeElement var1);

        public void removed(JobTreeElement var1);
    }
}

