/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl;

import java.math.BigDecimal;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.ocl.AbstractEvaluationVisitor;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.EvaluationEnvironment;
import org.eclipse.ocl.EvaluationHaltedException;
import org.eclipse.ocl.TypeChecker;
import org.eclipse.ocl.expressions.AssociationClassCallExp;
import org.eclipse.ocl.expressions.BooleanLiteralExp;
import org.eclipse.ocl.expressions.CollectionItem;
import org.eclipse.ocl.expressions.CollectionKind;
import org.eclipse.ocl.expressions.CollectionLiteralExp;
import org.eclipse.ocl.expressions.CollectionLiteralPart;
import org.eclipse.ocl.expressions.CollectionRange;
import org.eclipse.ocl.expressions.EnumLiteralExp;
import org.eclipse.ocl.expressions.IfExp;
import org.eclipse.ocl.expressions.IntegerLiteralExp;
import org.eclipse.ocl.expressions.InvalidLiteralExp;
import org.eclipse.ocl.expressions.IterateExp;
import org.eclipse.ocl.expressions.IteratorExp;
import org.eclipse.ocl.expressions.LetExp;
import org.eclipse.ocl.expressions.MessageExp;
import org.eclipse.ocl.expressions.NullLiteralExp;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.expressions.OperationCallExp;
import org.eclipse.ocl.expressions.PropertyCallExp;
import org.eclipse.ocl.expressions.RealLiteralExp;
import org.eclipse.ocl.expressions.StateExp;
import org.eclipse.ocl.expressions.StringLiteralExp;
import org.eclipse.ocl.expressions.TupleLiteralExp;
import org.eclipse.ocl.expressions.TupleLiteralPart;
import org.eclipse.ocl.expressions.TypeExp;
import org.eclipse.ocl.expressions.UnlimitedNaturalLiteralExp;
import org.eclipse.ocl.expressions.UnspecifiedValueExp;
import org.eclipse.ocl.expressions.Variable;
import org.eclipse.ocl.expressions.VariableExp;
import org.eclipse.ocl.internal.OCLPlugin;
import org.eclipse.ocl.internal.evaluation.CachedTypeChecker;
import org.eclipse.ocl.internal.evaluation.IterationTemplate;
import org.eclipse.ocl.internal.evaluation.IterationTemplateAny;
import org.eclipse.ocl.internal.evaluation.IterationTemplateClosure;
import org.eclipse.ocl.internal.evaluation.IterationTemplateCollect;
import org.eclipse.ocl.internal.evaluation.IterationTemplateCollectNested;
import org.eclipse.ocl.internal.evaluation.IterationTemplateExists;
import org.eclipse.ocl.internal.evaluation.IterationTemplateForAll;
import org.eclipse.ocl.internal.evaluation.IterationTemplateIsUnique;
import org.eclipse.ocl.internal.evaluation.IterationTemplateOne;
import org.eclipse.ocl.internal.evaluation.IterationTemplateReject;
import org.eclipse.ocl.internal.evaluation.IterationTemplateSelect;
import org.eclipse.ocl.internal.evaluation.IterationTemplateSortedBy;
import org.eclipse.ocl.internal.l10n.OCLMessages;
import org.eclipse.ocl.options.EvaluationOptions;
import org.eclipse.ocl.types.AnyType;
import org.eclipse.ocl.types.BagType;
import org.eclipse.ocl.types.CollectionType;
import org.eclipse.ocl.types.InvalidType;
import org.eclipse.ocl.types.OrderedSetType;
import org.eclipse.ocl.types.PrimitiveType;
import org.eclipse.ocl.types.SequenceType;
import org.eclipse.ocl.types.SetType;
import org.eclipse.ocl.types.VoidType;
import org.eclipse.ocl.util.CollectionUtil;
import org.eclipse.ocl.util.OCLStandardLibraryUtil;
import org.eclipse.ocl.util.OCLUtil;
import org.eclipse.ocl.util.ObjectUtil;
import org.eclipse.ocl.util.UnicodeSupport;
import org.eclipse.ocl.utilities.PredefinedType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EvaluationVisitorImpl<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E>
extends AbstractEvaluationVisitor<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> {
    private static final Integer UNLIMITED = -1;
    private static int tempCounter = 0;
    private static final String DELIMS = " \t\n\r\f";
    private static final int DEFAULT_REGEX_CACHE_LIMIT = 16;
    private static final float DEFAULT_REGEX_CACHE_LOAD_FACTOR = 0.75f;
    private EvaluationEnvironment.Enumerations<EL> enumerations;
    private final TypeChecker.Cached<C, O, P> cachedTypeChecker;
    private Map<String, Matcher> regexMatchers;

    private static List<String> tokenize(String sourceString, String delims, boolean returnDelims) {
        StringTokenizer tokenizer = new StringTokenizer(sourceString, delims, returnDelims);
        ArrayList<String> results = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            results.add(tokenizer.nextToken());
        }
        return results;
    }

    public EvaluationVisitorImpl(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, EvaluationEnvironment<C, O, P, CLS, E> evalEnv, Map<? extends CLS, ? extends Set<? extends E>> extentMap) {
        super(env, evalEnv, extentMap);
        this.enumerations = OCLUtil.getAdapter(evalEnv, EvaluationEnvironment.Enumerations.class);
        boolean dynamicDispatch = EvaluationOptions.getValue(evalEnv, EvaluationOptions.DYNAMIC_DISPATCH);
        this.cachedTypeChecker = dynamicDispatch ? this.createTypeChecker() : null;
    }

    protected TypeChecker.Cached<C, O, P> createTypeChecker() {
        Environment environment = this.getEnvironment();
        TypeChecker typeChecker = OCLUtil.getAdapter(environment, TypeChecker.class);
        if (typeChecker instanceof TypeChecker.Cached) {
            return (TypeChecker.Cached)typeChecker;
        }
        return new CachedTypeChecker(environment);
    }

    private boolean isBooleanOperation(int opCode) {
        return opCode == 10 || opCode == 12 || opCode == 11 || opCode == 25 || opCode == 13;
    }

    @Override
    public Object visitOperationCallExp(OperationCallExp<C, O> oc) {
        OCLExpression arg;
        Object dynamicSourceType;
        OCLExpression source = oc.getSource();
        Object sourceType = source.getType();
        O oper = oc.getReferredOperation();
        int opCode = oc.getOperationCode();
        EList<OCLExpression<C>> args = oc.getArgument();
        int numArgs = args.size();
        Object sourceVal = this.safeVisitExpression(source);
        if (this.cachedTypeChecker != null && (oper = this.cachedTypeChecker.getDynamicOperation(dynamicSourceType = this.getEvaluationEnvironment().getType(sourceVal), oper)) == null) {
            return this.getInvalid();
        }
        OCLExpression body = this.getOperationBody(oper);
        if (body != null || opCode <= 0 || this.getEvaluationEnvironment().overrides(oper, opCode)) {
            Object[] evalArgs = new Object[numArgs];
            int i = 0;
            for (OCLExpression arg2 : args) {
                evalArgs[i] = this.safeVisitExpression(arg2);
                ++i;
            }
            try {
                Object result;
                if (body != null) {
                    if (this.isUndefined(sourceVal)) {
                        return this.getInvalid();
                    }
                    result = this.call(oper, body, sourceVal, evalArgs);
                } else {
                    if (opCode <= 0) {
                        opCode = this.inferOperationCode(oper, opCode);
                    }
                    result = this.getEvaluationEnvironment().callOperation(oper, opCode, sourceVal, evalArgs);
                }
                return result;
            }
            catch (EvaluationHaltedException e) {
                throw e;
            }
            catch (UnsupportedOperationException e) {
            }
            catch (Exception e) {
                OCLPlugin.catching(this.getClass(), "visitOperationCallExp", e);
                OCLPlugin.log(4, 10, OCLMessages.bind(OCLMessages.ErrorMessage_ERROR_, "visitOperationCallExp", e.getLocalizedMessage()), e);
                return this.getInvalid();
            }
        }
        if (opCode == 60) {
            if (sourceVal == this.getInvalid()) {
                return this.getInvalid();
            }
            arg = (OCLExpression)args.get(0);
            Object argVal = this.safeVisitExpression(arg);
            if (argVal == this.getInvalid()) {
                return argVal;
            }
            if (sourceVal instanceof Number) {
                sourceVal = this.higherPrecisionNumber((Number)sourceVal);
            }
            if (argVal instanceof Number) {
                argVal = this.higherPrecisionNumber((Number)argVal);
            }
            return ObjectUtil.equal(sourceVal, argVal);
        }
        if (opCode == 61) {
            if (sourceVal == this.getInvalid()) {
                return this.getInvalid();
            }
            arg = (OCLExpression)args.get(0);
            Object argVal = this.safeVisitExpression(arg);
            if (argVal == this.getInvalid()) {
                return argVal;
            }
            if (sourceVal instanceof Number) {
                sourceVal = this.higherPrecisionNumber((Number)sourceVal);
            }
            if (argVal instanceof Number) {
                argVal = this.higherPrecisionNumber((Number)argVal);
            }
            return !ObjectUtil.equal(sourceVal, argVal);
        }
        if (opCode == 213) {
            if (sourceVal == null) {
                return "null";
            }
            if (sourceVal == this.getInvalid()) {
                return "invalid";
            }
            if (sourceVal == UNLIMITED && sourceType == this.getUnlimitedNatural()) {
                return "*";
            }
            return sourceVal.toString();
        }
        if (opCode == 230) {
            if (sourceVal == this.getInvalid()) {
                return sourceVal;
            }
            Set<Object> resultSet = CollectionUtil.createNewSet();
            if (sourceVal != null) {
                resultSet.add(sourceVal);
            }
            return resultSet;
        }
        if (sourceType instanceof PrimitiveType || sourceType instanceof CollectionType || this.getUMLReflection().isEnumeration(sourceType) || this.getUMLReflection().isDataType(sourceType) || sourceType instanceof VoidType || sourceType instanceof InvalidType) {
            if (numArgs == 0) {
                if (this.isUndefined(sourceVal) && opCode != 65 && opCode != 66) {
                    return this.getInvalid();
                }
                switch (opCode) {
                    case 2: {
                        if (sourceType == this.getUnlimitedNatural() && UNLIMITED.equals(sourceVal)) {
                            return this.getInvalid();
                        }
                        if (sourceVal instanceof Integer) {
                            int intVal = (Integer)sourceVal;
                            if (intVal == Integer.MIN_VALUE) {
                                return -((long)intVal);
                            }
                            return -intVal;
                        }
                        if (sourceVal instanceof Long) {
                            long longVal = (Long)sourceVal;
                            if (longVal == 0x80000000L) {
                                return Integer.MIN_VALUE;
                            }
                            return -longVal;
                        }
                        return -((Number)sourceVal).doubleValue();
                    }
                    case 15: {
                        if (sourceVal instanceof Integer) {
                            int sourceInt = (Integer)sourceVal;
                            if (sourceType == this.getUnlimitedNatural() && sourceInt == -1) {
                                return this.getInvalid();
                            }
                            if (sourceInt == Integer.MIN_VALUE) {
                                return 0x80000000L;
                            }
                            return Math.abs(sourceInt);
                        }
                        if (sourceVal instanceof Long) {
                            long sourceInt = (Long)sourceVal;
                            if (sourceType == this.getUnlimitedNatural() && sourceInt == -1L) {
                                return this.getInvalid();
                            }
                            return Math.abs(sourceInt);
                        }
                        return Math.abs(((Number)sourceVal).doubleValue());
                    }
                    case 214: {
                        String sourceString = (String)sourceVal;
                        ArrayList<String> results = new ArrayList<String>(sourceString.length());
                        int i = 0;
                        while (i < sourceString.length()) {
                            results.add(sourceString.substring(i, i + 1));
                            ++i;
                        }
                        return results;
                    }
                    case 26: {
                        long sourceInt;
                        if (sourceVal instanceof Double || sourceVal instanceof Float || sourceVal instanceof BigDecimal) {
                            return (int)Math.floor(((Number)sourceVal).doubleValue());
                        }
                        if (sourceType == this.getUnlimitedNatural() && (sourceInt = ((Long)this.higherPrecisionNumber((Number)sourceVal)).longValue()) == -1L) {
                            return this.getInvalid();
                        }
                        return sourceVal;
                    }
                    case 27: {
                        long sourceInt;
                        if (sourceVal instanceof Double || sourceVal instanceof Float || sourceVal instanceof BigDecimal) {
                            return (int)Math.round(((Number)sourceVal).doubleValue());
                        }
                        if (sourceType == this.getUnlimitedNatural() && (sourceInt = ((Long)this.higherPrecisionNumber((Number)sourceVal)).longValue()) == -1L) {
                            return this.getInvalid();
                        }
                        return sourceVal;
                    }
                    case 11: {
                        return (Boolean)sourceVal != false ? Boolean.FALSE : Boolean.TRUE;
                    }
                    case 65: {
                        return this.isUndefined(sourceVal) ? Boolean.TRUE : Boolean.FALSE;
                    }
                    case 66: {
                        return sourceVal == this.getInvalid() ? Boolean.TRUE : Boolean.FALSE;
                    }
                    case 20: {
                        if (sourceType == this.getString()) {
                            return new Integer(((String)sourceVal).length());
                        }
                        if (sourceType instanceof CollectionType) {
                            return new Integer(((Collection)sourceVal).size());
                        }
                    }
                    case 212: {
                        return "true".equals(sourceVal);
                    }
                    case 23: {
                        if (sourceType == this.getString()) {
                            return Integer.valueOf((String)sourceVal);
                        }
                        if (sourceVal != UNLIMITED && sourceType == this.getUnlimitedNatural()) {
                            return Integer.valueOf(sourceVal.toString());
                        }
                        return this.getInvalid();
                    }
                    case 24: {
                        return Double.valueOf((String)sourceVal);
                    }
                    case 28: 
                    case 226: {
                        return UnicodeSupport.toLowerCase((String)sourceVal);
                    }
                    case 29: 
                    case 227: {
                        return UnicodeSupport.toUpperCase((String)sourceVal);
                    }
                    case 224: {
                        return EvaluationVisitorImpl.tokenize((String)sourceVal, DELIMS, false);
                    }
                    case 225: {
                        return ((String)sourceVal).trim();
                    }
                    case 145: {
                        return ((Collection)sourceVal).isEmpty();
                    }
                    case 146: {
                        return !((Collection)sourceVal).isEmpty();
                    }
                    case 148: {
                        Number num = (Number)CollectionUtil.sum((Collection)sourceVal);
                        if (num == null) {
                            CollectionType numCollType = (CollectionType)sourceType;
                            Object numType = numCollType.getElementType();
                            if (numType == this.getReal()) {
                                num = new Double(0.0);
                            } else if (numType == this.getInteger()) {
                                num = new Integer(0);
                            }
                        }
                        return num;
                    }
                    case 154: {
                        return CollectionUtil.flatten((Collection)sourceVal);
                    }
                    case 152: {
                        return CollectionUtil.asSet((Collection)sourceVal);
                    }
                    case 149: {
                        return CollectionUtil.asBag((Collection)sourceVal);
                    }
                    case 150: {
                        return CollectionUtil.asOrderedSet((Collection)sourceVal);
                    }
                    case 151: {
                        return CollectionUtil.asSequence((Collection)sourceVal);
                    }
                    case 159: {
                        if (((Collection)sourceVal).isEmpty()) {
                            return this.getInvalid();
                        }
                        return CollectionUtil.first((Collection)sourceVal);
                    }
                    case 162: {
                        if (((Collection)sourceVal).isEmpty()) {
                            return this.getInvalid();
                        }
                        return CollectionUtil.last((Collection)sourceVal);
                    }
                    case 18: {
                        return CollectionUtil.max((Collection)sourceVal);
                    }
                    case 19: {
                        return CollectionUtil.min((Collection)sourceVal);
                    }
                }
            } else if (numArgs == 1) {
                String message;
                Boolean result;
                arg = (OCLExpression)args.get(0);
                Object argType = arg.getType();
                if (this.isUndefined(sourceVal)) {
                    switch (opCode) {
                        case 10: 
                        case 12: 
                        case 13: 
                        case 25: 
                        case 62: 
                        case 63: 
                        case 64: {
                            if (this.isLaxNullHandling()) break;
                            return this.getInvalid();
                        }
                        default: {
                            return this.getInvalid();
                        }
                    }
                }
                if (opCode == 64) {
                    Object targetType = arg.accept(this.getVisitor());
                    if (sourceType == this.getUnlimitedNatural()) {
                        if (targetType == this.getUnlimitedNatural()) {
                            return true;
                        }
                        return false;
                    }
                    result = this.oclIsTypeOf(sourceVal, targetType);
                    if (result == null) {
                        return this.getInvalid();
                    }
                    return result;
                }
                if (opCode == 63) {
                    Object targetType = arg.accept(this.getVisitor());
                    if (sourceType == this.getUnlimitedNatural() && targetType == this.getUnlimitedNatural()) {
                        return true;
                    }
                    result = this.oclIsKindOf(sourceVal, targetType);
                    if (result == null) {
                        return this.getInvalid();
                    }
                    return result;
                }
                if (opCode == 62) {
                    if (sourceVal == null || argType instanceof VoidType) {
                        return sourceVal;
                    }
                    if (sourceVal == this.getInvalid() || argType instanceof InvalidType) {
                        return this.getInvalid();
                    }
                    if (sourceVal instanceof String && ((TypeExp)arg).getReferredType() == this.getString()) {
                        return sourceVal;
                    }
                    if ((sourceVal instanceof Double || sourceVal instanceof Float || sourceVal instanceof BigDecimal) && argType == this.getInteger()) {
                        return new Integer(((Number)sourceVal).intValue());
                    }
                    if (sourceVal instanceof Boolean && ((TypeExp)arg).getReferredType() == this.getBoolean()) {
                        return sourceVal;
                    }
                    if (sourceVal instanceof Integer && ((TypeExp)arg).getReferredType() == this.getReal()) {
                        int sourceInt;
                        if (sourceType == this.getUnlimitedNatural() && (sourceInt = ((Integer)sourceVal).intValue()) == -1) {
                            return this.getInvalid();
                        }
                        return new Double(((Integer)sourceVal).doubleValue());
                    }
                    if (sourceType == this.getUnlimitedNatural() && sourceVal.equals(UNLIMITED) && ((TypeExp)arg).getReferredType() == this.getInteger()) {
                        return this.getInvalid();
                    }
                    if (((TypeExp)arg).getReferredType() instanceof AnyType) {
                        return sourceVal;
                    }
                    if (sourceType == this.getUnlimitedNatural() && ((TypeExp)arg).getReferredType() == this.getUnlimitedNatural() || this.oclIsKindOf(sourceVal, ((TypeExp)arg).getReferredType()).booleanValue()) {
                        return sourceVal;
                    }
                    return this.getInvalid();
                }
                Object argVal = null;
                if (!this.isBooleanOperation(opCode) && (argVal = this.safeVisitExpression(arg)) == this.getInvalid()) {
                    return argVal;
                }
                if (sourceVal instanceof Number) {
                    if (argVal == null) {
                        return this.getInvalid();
                    }
                    sourceVal = this.higherPrecisionNumber((Number)sourceVal);
                    if (argVal instanceof Number) {
                        argVal = this.higherPrecisionNumber((Number)argVal);
                    }
                }
                if (sourceVal instanceof Long && argVal instanceof Long) {
                    boolean argUnlimited;
                    long sourceInt = (Long)sourceVal;
                    long argInt = (Long)argVal;
                    boolean sourceUnlimited = sourceType == this.getUnlimitedNatural() && sourceInt == -1L;
                    boolean bl = argUnlimited = argType == this.getUnlimitedNatural() && argInt == -1L;
                    if (sourceUnlimited && argUnlimited) {
                        switch (opCode) {
                            case 67: 
                            case 68: {
                                return Boolean.FALSE;
                            }
                            case 69: 
                            case 70: {
                                return Boolean.TRUE;
                            }
                        }
                        return this.getInvalid();
                    }
                    if (sourceUnlimited || argUnlimited) {
                        switch (opCode) {
                            case 67: 
                            case 69: {
                                return argUnlimited;
                            }
                            case 68: 
                            case 70: {
                                return sourceUnlimited;
                            }
                        }
                        return this.getInvalid();
                    }
                    switch (opCode) {
                        case 1: {
                            return this.coerceNumber(sourceInt + argInt);
                        }
                        case 2: {
                            return this.coerceNumber(sourceInt - argInt);
                        }
                        case 3: {
                            return this.coerceNumber(sourceInt * argInt);
                        }
                        case 4: {
                            double num = sourceInt;
                            double denom = argInt;
                            return denom == 0.0 ? this.getInvalid() : Double.valueOf(num / denom);
                        }
                        case 16: {
                            return argInt == 0L ? this.getInvalid() : this.coerceNumber(sourceInt / argInt);
                        }
                        case 17: {
                            return this.coerceNumber(sourceInt % argInt);
                        }
                        case 18: {
                            return this.coerceNumber(Math.max(sourceInt, argInt));
                        }
                        case 19: {
                            return this.coerceNumber(Math.min(sourceInt, argInt));
                        }
                        case 67: {
                            if (sourceInt < argInt) {
                                return true;
                            }
                            return false;
                        }
                        case 68: {
                            if (sourceInt > argInt) {
                                return true;
                            }
                            return false;
                        }
                        case 69: {
                            if (sourceInt <= argInt) {
                                return true;
                            }
                            return false;
                        }
                        case 70: {
                            if (sourceInt >= argInt) {
                                return true;
                            }
                            return false;
                        }
                    }
                    String message2 = OCLMessages.bind(OCLMessages.UnknownOperation_ERROR_, this.getName(oper));
                    RuntimeException error = new RuntimeException(message2);
                    OCLPlugin.throwing(this.getClass(), "visitOperationCallExp", error);
                    throw error;
                }
                if (sourceVal instanceof Long && argVal instanceof Double) {
                    long sourceInt = (Long)sourceVal;
                    double argReal = (Double)argVal;
                    if (sourceType == this.getUnlimitedNatural() && sourceInt == -1L) {
                        switch (opCode) {
                            case 67: {
                                return Boolean.FALSE;
                            }
                            case 68: 
                            case 70: {
                                return Boolean.TRUE;
                            }
                        }
                        return this.getInvalid();
                    }
                    switch (opCode) {
                        case 1: {
                            return this.coerceNumber((double)sourceInt + argReal);
                        }
                        case 2: {
                            return this.coerceNumber((double)sourceInt - argReal);
                        }
                        case 3: {
                            return this.coerceNumber((double)sourceInt * argReal);
                        }
                        case 4: {
                            return argReal == 0.0 ? this.getInvalid() : Double.valueOf((double)sourceInt / argReal);
                        }
                        case 18: {
                            return this.coerceNumber(Math.max((double)sourceInt, argReal));
                        }
                        case 19: {
                            return this.coerceNumber(Math.min((double)sourceInt, argReal));
                        }
                        case 67: {
                            if ((double)sourceInt < argReal) {
                                return true;
                            }
                            return false;
                        }
                        case 68: {
                            if ((double)sourceInt > argReal) {
                                return true;
                            }
                            return false;
                        }
                        case 69: {
                            if ((double)sourceInt <= argReal) {
                                return true;
                            }
                            return false;
                        }
                        case 70: {
                            if ((double)sourceInt >= argReal) {
                                return true;
                            }
                            return false;
                        }
                    }
                    String message3 = OCLMessages.bind(OCLMessages.UnknownOperation_ERROR_, this.getName(oper));
                    RuntimeException error = new RuntimeException(message3);
                    OCLPlugin.throwing(this.getClass(), "visitOperationCallExp", error);
                    throw error;
                }
                if (sourceVal instanceof Double && argVal instanceof Long) {
                    double sourceReal = (Double)sourceVal;
                    long argInt = (Long)argVal;
                    if (argType == this.getUnlimitedNatural() && argInt == -1L) {
                        switch (opCode) {
                            case 67: {
                                return Boolean.TRUE;
                            }
                            case 68: 
                            case 70: {
                                return Boolean.FALSE;
                            }
                        }
                        return this.getInvalid();
                    }
                    switch (opCode) {
                        case 1: {
                            return sourceReal + (double)argInt;
                        }
                        case 2: {
                            return sourceReal - (double)argInt;
                        }
                        case 3: {
                            return sourceReal * (double)argInt;
                        }
                        case 4: {
                            return argInt == 0L ? this.getInvalid() : Double.valueOf(sourceReal / (double)argInt);
                        }
                        case 18: {
                            return Math.max(sourceReal, (double)argInt);
                        }
                        case 19: {
                            return Math.min(sourceReal, (double)argInt);
                        }
                        case 67: {
                            if (sourceReal < (double)argInt) {
                                return true;
                            }
                            return false;
                        }
                        case 68: {
                            if (sourceReal > (double)argInt) {
                                return true;
                            }
                            return false;
                        }
                        case 69: {
                            if (sourceReal <= (double)argInt) {
                                return true;
                            }
                            return false;
                        }
                        case 70: {
                            if (sourceReal >= (double)argInt) {
                                return true;
                            }
                            return false;
                        }
                    }
                    String message4 = OCLMessages.bind(OCLMessages.UnknownOperation_ERROR_, this.getName(oper));
                    RuntimeException error = new RuntimeException(message4);
                    OCLPlugin.throwing(this.getClass(), "visitOperationCallExp", error);
                    throw error;
                }
                if (sourceVal instanceof Double && argVal instanceof Double) {
                    double sourceReal = (Double)sourceVal;
                    double argReal = (Double)argVal;
                    switch (opCode) {
                        case 1: {
                            return sourceReal + argReal;
                        }
                        case 2: {
                            return sourceReal - argReal;
                        }
                        case 3: {
                            return sourceReal * argReal;
                        }
                        case 4: {
                            return argReal == 0.0 ? this.getInvalid() : Double.valueOf(sourceReal / argReal);
                        }
                        case 18: {
                            return Math.max(sourceReal, argReal);
                        }
                        case 19: {
                            return Math.min(sourceReal, argReal);
                        }
                        case 67: {
                            if (sourceReal < argReal) {
                                return true;
                            }
                            return false;
                        }
                        case 68: {
                            if (sourceReal > argReal) {
                                return true;
                            }
                            return false;
                        }
                        case 69: {
                            if (sourceReal <= argReal) {
                                return true;
                            }
                            return false;
                        }
                        case 70: {
                            if (sourceReal >= argReal) {
                                return true;
                            }
                            return false;
                        }
                    }
                    String message5 = OCLMessages.bind(OCLMessages.UnknownOperation_ERROR_, this.getName(oper));
                    RuntimeException error = new RuntimeException(message5);
                    OCLPlugin.throwing(this.getClass(), "visitOperationCallExp", error);
                    throw error;
                }
                if (sourceVal instanceof Boolean || this.isBooleanOperation(opCode)) {
                    switch (opCode) {
                        case 12: {
                            if (Boolean.TRUE.equals(sourceVal)) {
                                return Boolean.TRUE;
                            }
                            argVal = arg.accept(this.getVisitor());
                            if (Boolean.TRUE.equals(argVal)) {
                                return Boolean.TRUE;
                            }
                            if (this.isUndefined(sourceVal) || this.isUndefined(argVal)) {
                                return this.getInvalid();
                            }
                            return Boolean.FALSE;
                        }
                        case 25: {
                            argVal = arg.accept(this.getVisitor());
                            if (this.isUndefined(sourceVal) || this.isUndefined(argVal)) {
                                return this.getInvalid();
                            }
                            return argVal == null ? sourceVal : ((Boolean)sourceVal ^ (Boolean)argVal ? Boolean.TRUE : Boolean.FALSE);
                        }
                        case 10: {
                            if (Boolean.FALSE.equals(sourceVal)) {
                                return Boolean.FALSE;
                            }
                            argVal = arg.accept(this.getVisitor());
                            if (Boolean.FALSE.equals(argVal)) {
                                return Boolean.FALSE;
                            }
                            if (this.isUndefined(sourceVal) || this.isUndefined(argVal)) {
                                return this.getInvalid();
                            }
                            return Boolean.TRUE;
                        }
                        case 13: {
                            if (Boolean.FALSE.equals(sourceVal)) {
                                return Boolean.TRUE;
                            }
                            argVal = arg.accept(this.getVisitor());
                            if (Boolean.TRUE.equals(argVal)) {
                                return Boolean.TRUE;
                            }
                            if (this.isUndefined(sourceVal) || this.isUndefined(argVal)) {
                                return this.getInvalid();
                            }
                            return argVal;
                        }
                    }
                    message = OCLMessages.bind(OCLMessages.UnknownOperation_ERROR_, this.getName(oper));
                    RuntimeException error = new RuntimeException(message);
                    OCLPlugin.throwing(this.getClass(), "visitOperationCallExp", error);
                    throw error;
                }
                if (sourceVal instanceof String) {
                    if (this.isUndefined(argVal)) {
                        return this.getInvalid();
                    }
                    switch (opCode) {
                        case 1: 
                        case 21: {
                            return ((String)sourceVal).concat((String)argVal);
                        }
                        case 67: {
                            return ((String)sourceVal).compareTo((String)argVal) < 0;
                        }
                        case 69: {
                            return ((String)sourceVal).compareTo((String)argVal) <= 0;
                        }
                        case 68: {
                            return ((String)sourceVal).compareTo((String)argVal) > 0;
                        }
                        case 70: {
                            return ((String)sourceVal).compareTo((String)argVal) >= 0;
                        }
                        case 158: {
                            if (!(argVal instanceof Integer)) {
                                return this.getInvalid();
                            }
                            return String.valueOf(((String)sourceVal).substring((Integer)argVal - 1, (Integer)argVal));
                        }
                        case 215: {
                            return ((String)sourceVal).endsWith((String)argVal);
                        }
                        case 216: {
                            return ((String)sourceVal).equalsIgnoreCase((String)argVal);
                        }
                        case 160: {
                            return 1 + ((String)sourceVal).indexOf((String)argVal);
                        }
                        case 217: {
                            return 1 + ((String)sourceVal).lastIndexOf((String)argVal);
                        }
                        case 218: {
                            return this.getRegexMatcher((String)argVal, (String)sourceVal).matches();
                        }
                        case 221: {
                            return ((String)sourceVal).startsWith((String)argVal);
                        }
                        case 224: {
                            return EvaluationVisitorImpl.tokenize((String)sourceVal, (String)argVal, false);
                        }
                    }
                    message = OCLMessages.bind(OCLMessages.UnknownOperation_ERROR_, this.getName(oper));
                    RuntimeException error = new RuntimeException(message);
                    OCLPlugin.throwing(this.getClass(), "visitOperationCallExp", error);
                    throw error;
                }
                if (sourceVal instanceof Collection) {
                    Collection sourceColl = (Collection)sourceVal;
                    if (argVal == this.getInvalid()) {
                        return argVal;
                    }
                    switch (opCode) {
                        case 143: {
                            return CollectionUtil.includes(sourceColl, argVal) ? Boolean.TRUE : Boolean.FALSE;
                        }
                        case 141: {
                            return CollectionUtil.excludes(sourceColl, argVal) ? Boolean.TRUE : Boolean.FALSE;
                        }
                        case 140: {
                            return new Integer(CollectionUtil.count(sourceColl, argVal));
                        }
                        case 144: {
                            if (argVal == null) {
                                return this.getInvalid();
                            }
                            return CollectionUtil.includesAll(sourceColl, (Collection)argVal) ? Boolean.TRUE : Boolean.FALSE;
                        }
                        case 142: {
                            if (argVal == null) {
                                return this.getInvalid();
                            }
                            return CollectionUtil.excludesAll(sourceColl, (Collection)argVal) ? Boolean.TRUE : Boolean.FALSE;
                        }
                        case 147: {
                            if (argVal == null) {
                                return this.getInvalid();
                            }
                            CollectionType collType = (CollectionType)oc.getType();
                            return CollectionUtil.product(this.getEvaluationEnvironment(), this.getEnvironment(), sourceColl, (Collection)argVal, collType.getElementType());
                        }
                        case 157: {
                            if (argVal == null) {
                                return this.getInvalid();
                            }
                            Collection argColl = (Collection)argVal;
                            return CollectionUtil.union(sourceColl, argColl);
                        }
                        case 156: {
                            if (argVal == null) {
                                return this.getInvalid();
                            }
                            Collection argColl = (Collection)argVal;
                            return CollectionUtil.intersection(sourceColl, argColl);
                        }
                        case 2: {
                            if (argVal == null) {
                                return this.getInvalid();
                            }
                            return CollectionUtil.minus((Set)sourceColl, (Set)argVal);
                        }
                        case 155: {
                            return CollectionUtil.including(sourceColl, argVal);
                        }
                        case 153: {
                            return CollectionUtil.excluding(sourceColl, argVal);
                        }
                        case 167: {
                            if (argVal == null) {
                                return this.getInvalid();
                            }
                            return CollectionUtil.symmetricDifference((Set)sourceColl, (Set)argVal);
                        }
                        case 165: {
                            return CollectionUtil.append(sourceColl, argVal);
                        }
                        case 163: {
                            return CollectionUtil.prepend(sourceColl, argVal);
                        }
                        case 158: {
                            if (!(argVal instanceof Integer)) {
                                return this.getInvalid();
                            }
                            int indexVal = (Integer)argVal;
                            return CollectionUtil.at(sourceColl, indexVal);
                        }
                        case 160: {
                            Object indexOf = CollectionUtil.indexOf(sourceColl, argVal);
                            if (indexOf == null) {
                                indexOf = this.getInvalid();
                            }
                            return indexOf;
                        }
                        case 228: {
                            Collection newElements = CollectionUtil.createNewCollectionOfSameKind(sourceColl);
                            for (Object object : sourceColl) {
                                if (object == null || !this.oclIsKindOf(object, argVal).booleanValue()) continue;
                                newElements.add(object);
                            }
                            return newElements;
                        }
                        case 229: {
                            Collection newElements = CollectionUtil.createNewCollectionOfSameKind(sourceColl);
                            for (Object object : sourceColl) {
                                if (!this.oclIsTypeOf(object, argVal).booleanValue()) continue;
                                newElements.add(object);
                            }
                            return newElements;
                        }
                    }
                } else if (sourceVal instanceof Comparable) {
                    Comparable comp;
                    if (opCode == 67) {
                        comp = (Comparable)sourceVal;
                        return comp.compareTo(argVal) < 0;
                    }
                    if (opCode == 69) {
                        comp = (Comparable)sourceVal;
                        return comp.compareTo(argVal) <= 0;
                    }
                    if (opCode == 68) {
                        comp = (Comparable)sourceVal;
                        return comp.compareTo(argVal) > 0;
                    }
                    if (opCode == 70) {
                        comp = (Comparable)sourceVal;
                        return comp.compareTo(argVal) >= 0;
                    }
                }
            } else {
                if (this.isUndefined(sourceVal)) {
                    return this.getInvalid();
                }
                Object arg1 = ((OCLExpression)args.get(0)).accept(this.getVisitor());
                if (arg1 == this.getInvalid()) {
                    return this.getInvalid();
                }
                Object arg2 = ((OCLExpression)args.get(1)).accept(this.getVisitor());
                if (arg2 == this.getInvalid()) {
                    return this.getInvalid();
                }
                if (sourceVal instanceof String) {
                    if (this.isUndefined(arg1) || this.isUndefined(arg2)) {
                        return this.getInvalid();
                    }
                    String sourceString = (String)sourceVal;
                    switch (opCode) {
                        case 219: {
                            return this.getRegexMatcher((String)arg1, sourceString).replaceAll((String)arg2);
                        }
                        case 220: {
                            return this.getRegexMatcher((String)arg1, sourceString).replaceFirst((String)arg2);
                        }
                        case 222: {
                            return sourceString.replace((String)arg1, (String)arg2);
                        }
                        case 223: {
                            String oldSubstring = (String)arg1;
                            int index = sourceString.indexOf((String)arg1);
                            if (index >= 0) {
                                return String.valueOf(sourceString.substring(0, index)) + (String)arg2 + sourceString.substring(index + oldSubstring.length(), sourceString.length());
                            }
                            return this.getInvalid();
                        }
                        case 22: {
                            int lower = (Integer)arg1;
                            int upper = (Integer)arg2;
                            if (1 > lower || lower > upper || upper > ((String)sourceVal).length()) {
                                return this.getInvalid();
                            }
                            return sourceString.substring(lower - 1, upper);
                        }
                        case 224: {
                            return EvaluationVisitorImpl.tokenize(sourceString, (String)arg1, (Boolean)arg2);
                        }
                    }
                } else if (sourceVal instanceof Collection) {
                    Collection sourceColl = (Collection)sourceVal;
                    if (opCode == 161) {
                        if (this.isUndefined(arg1)) {
                            return this.getInvalid();
                        }
                        int index = (Integer)arg1;
                        return CollectionUtil.insertAt(sourceColl, index, arg2);
                    }
                    if (opCode == 166) {
                        if (this.isUndefined(arg1) || this.isUndefined(arg2)) {
                            return this.getInvalid();
                        }
                        int lower = (Integer)arg1;
                        int upper = (Integer)arg2;
                        return CollectionUtil.subOrderedSet(sourceColl, lower, upper);
                    }
                    if (opCode == 164) {
                        if (this.isUndefined(arg1) || this.isUndefined(arg2)) {
                            return this.getInvalid();
                        }
                        int lower = (Integer)arg1;
                        int upper = (Integer)arg2;
                        return CollectionUtil.subSequence(sourceColl, lower, upper);
                    }
                }
            }
        } else {
            Comparable compContext;
            if (opCode == 40) {
                Object classifier = sourceVal;
                if (this.getUMLReflection().isEnumeration(classifier)) {
                    return new HashSet(this.getUMLReflection().getEnumerationLiterals(classifier));
                }
                if (sourceVal instanceof VoidType) {
                    HashSet<Object> result = new HashSet<Object>();
                    result.add(null);
                    return result;
                }
                if (this.getUMLReflection().isClass(classifier)) {
                    return this.getExtentMap().get(sourceVal);
                }
                return Collections.EMPTY_SET;
            }
            if (opCode == 65) {
                return this.isUndefined(sourceVal) ? Boolean.TRUE : Boolean.FALSE;
            }
            if (opCode == 66) {
                return sourceVal == this.getInvalid() ? Boolean.TRUE : Boolean.FALSE;
            }
            if (this.isUndefined(sourceVal)) {
                switch (opCode) {
                    case 62: 
                    case 63: 
                    case 64: {
                        if (this.isLaxNullHandling()) break;
                        return this.getInvalid();
                    }
                    default: {
                        return this.getInvalid();
                    }
                }
            }
            if (opCode == 64) {
                arg = (OCLExpression)args.get(0);
                Boolean result = this.oclIsTypeOf(sourceVal, arg.accept(this.getVisitor()));
                if (result == null) {
                    return this.getInvalid();
                }
                return result;
            }
            if (opCode == 63) {
                arg = (OCLExpression)args.get(0);
                Boolean result = this.oclIsKindOf(sourceVal, arg.accept(this.getVisitor()));
                if (result == null) {
                    return this.getInvalid();
                }
                return result;
            }
            if (opCode == 62) {
                arg = (OCLExpression)args.get(0);
                Object type = arg.accept(this.getVisitor());
                if (Boolean.TRUE.equals(this.oclIsKindOf(sourceVal, type))) {
                    return sourceVal;
                }
                return this.getInvalid();
            }
            if (opCode == 67 && sourceVal instanceof Comparable) {
                compContext = (Comparable)sourceVal;
                OCLExpression arg3 = (OCLExpression)args.get(0);
                Comparable evalArg = (Comparable)arg3.accept(this.getVisitor());
                return compContext.compareTo(evalArg) < 0;
            }
            if (opCode == 69 && sourceVal instanceof Comparable) {
                compContext = (Comparable)sourceVal;
                OCLExpression arg4 = (OCLExpression)args.get(0);
                Comparable evalArg = (Comparable)arg4.accept(this.getVisitor());
                return compContext.compareTo(evalArg) <= 0;
            }
            if (opCode == 68 && sourceVal instanceof Comparable) {
                compContext = (Comparable)sourceVal;
                OCLExpression arg5 = (OCLExpression)args.get(0);
                Comparable evalArg = (Comparable)arg5.accept(this.getVisitor());
                return compContext.compareTo(evalArg) > 0;
            }
            if (opCode == 70 && sourceVal instanceof Comparable) {
                compContext = (Comparable)sourceVal;
                OCLExpression arg6 = (OCLExpression)args.get(0);
                Comparable evalArg = (Comparable)arg6.accept(this.getVisitor());
                return compContext.compareTo(evalArg) >= 0;
            }
            return this.getInvalid();
        }
        return this.getInvalid();
    }

    private int inferOperationCode(O operation, int opcode) {
        int result = opcode;
        String opName = this.getName(operation);
        if ("<".equals(opName)) {
            result = 67;
        } else if (">".equals(opName)) {
            result = 68;
        } else if ("<=".equals(opName)) {
            result = 69;
        } else if (">=".equals(opName)) {
            result = 70;
        }
        return result;
    }

    @Override
    public Object visitIterateExp(IterateExp<C, PM> ie) {
        Variable<C, PM> vd = ie.getResult();
        String resultName = (String)vd.accept(this.getVisitor());
        try {
            EList iterators = ie.getIterator();
            Object sourceValue = ie.getSource().accept(this.getVisitor());
            if (this.isUndefined(sourceValue)) {
                Object object = this.getInvalid();
                return object;
            }
            Collection coll = (Collection)sourceValue;
            OCLExpression body = ie.getBody();
            IterationTemplate is = IterationTemplate.getInstance(this.getVisitor());
            Object object = is.evaluate(coll, iterators, body, resultName);
            return object;
        }
        finally {
            this.getEvaluationEnvironment().remove(resultName);
        }
    }

    @Override
    public Object visitIteratorExp(IteratorExp<C, PM> ie) {
        Object sourceType = ie.getSource().getType();
        if (sourceType instanceof PredefinedType) {
            Object sourceValue = ie.getSource().accept(this.getVisitor());
            if (this.isUndefined(sourceValue)) {
                return this.getInvalid();
            }
            Collection sourceCollection = (Collection)sourceValue;
            switch (OCLStandardLibraryUtil.getOperationCode(ie.getName())) {
                case 201: {
                    return this.evaluateExistsIterator(ie, sourceCollection);
                }
                case 202: {
                    return this.evaluateForAllIterator(ie, sourceCollection);
                }
                case 209: {
                    return this.evaluateSelectIterator(ie, sourceCollection);
                }
                case 210: {
                    return this.evaluateRejectIterator(ie, sourceCollection);
                }
                case 206: {
                    return this.evaluateCollectIterator(ie, sourceCollection);
                }
                case 207: {
                    return this.evaluateCollectNestedIterator(ie, sourceCollection);
                }
                case 204: {
                    return this.evaluateOneIterator(ie, sourceCollection);
                }
                case 205: {
                    return this.evaluateAnyIterator(ie, sourceCollection);
                }
                case 211: {
                    return this.evaluateSortedByIterator(ie, sourceCollection);
                }
                case 203: {
                    return this.evaluateIsUnique(ie, sourceCollection);
                }
                case 208: {
                    return this.evaluateClosure(ie, sourceCollection);
                }
            }
        }
        String message = OCLMessages.bind(OCLMessages.IteratorNotImpl_ERROR_, ie.getName());
        UnsupportedOperationException ex = new UnsupportedOperationException(message);
        OCLPlugin.throwing(this.getClass(), "visitIteratorExp", ex);
        throw ex;
    }

    private static synchronized String generateName() {
        return "__result__" + tempCounter++;
    }

    private Object evaluateExistsIterator(IteratorExp<C, PM> ie, Collection<?> coll) {
        EList iterators = ie.getIterator();
        OCLExpression body = ie.getBody();
        IterationTemplate is = IterationTemplateExists.getInstance(this.getVisitor());
        String resultName = EvaluationVisitorImpl.generateName();
        this.getEvaluationEnvironment().add(resultName, Boolean.FALSE);
        try {
            Object object = is.evaluate(coll, iterators, body, resultName);
            return object;
        }
        finally {
            this.getEvaluationEnvironment().remove(resultName);
        }
    }

    private Object evaluateForAllIterator(IteratorExp<C, PM> ie, Collection<?> coll) {
        EList iterators = ie.getIterator();
        OCLExpression body = ie.getBody();
        IterationTemplate is = IterationTemplateForAll.getInstance(this.getVisitor());
        String resultName = EvaluationVisitorImpl.generateName();
        this.getEvaluationEnvironment().add(resultName, Boolean.TRUE);
        try {
            Object object = is.evaluate(coll, iterators, body, resultName);
            return object;
        }
        finally {
            this.getEvaluationEnvironment().remove(resultName);
        }
    }

    private Object evaluateCollectNestedIterator(IteratorExp<C, PM> ie, Collection<?> coll) {
        EList iterators = ie.getIterator();
        OCLExpression body = ie.getBody();
        CollectionType collType = (CollectionType)ie.getSource().getType();
        Collection initResultVal = null;
        initResultVal = collType instanceof SetType || collType instanceof BagType ? CollectionUtil.createNewBag() : CollectionUtil.createNewSequence();
        IterationTemplate is = IterationTemplateCollectNested.getInstance(this.getVisitor());
        String resultName = EvaluationVisitorImpl.generateName();
        this.getEvaluationEnvironment().add(resultName, initResultVal);
        try {
            Object object = is.evaluate(coll, iterators, body, resultName);
            return object;
        }
        finally {
            this.getEvaluationEnvironment().remove(resultName);
        }
    }

    private Object evaluateCollectIterator(IteratorExp<C, PM> ie, Collection<?> coll) {
        EList iterators = ie.getIterator();
        OCLExpression body = ie.getBody();
        CollectionType collType = (CollectionType)ie.getSource().getType();
        Collection initResultVal = null;
        initResultVal = collType instanceof SetType || collType instanceof BagType ? CollectionUtil.createNewBag() : CollectionUtil.createNewSequence();
        IterationTemplate is = IterationTemplateCollect.getInstance(this.getVisitor());
        String resultName = EvaluationVisitorImpl.generateName();
        this.getEvaluationEnvironment().add(resultName, initResultVal);
        try {
            Object object = is.evaluate(coll, iterators, body, resultName);
            return object;
        }
        finally {
            this.getEvaluationEnvironment().remove(resultName);
        }
    }

    private Object evaluateSelectIterator(IteratorExp<C, PM> ie, Collection<?> coll) {
        EList iterators = ie.getIterator();
        OCLExpression body = ie.getBody();
        CollectionType collType = (CollectionType)ie.getSource().getType();
        Collection initResultVal = null;
        initResultVal = collType instanceof SetType ? CollectionUtil.createNewSet() : (collType instanceof BagType ? CollectionUtil.createNewBag() : (collType instanceof SequenceType ? CollectionUtil.createNewSequence() : CollectionUtil.createNewOrderedSet()));
        IterationTemplate is = IterationTemplateSelect.getInstance(this.getVisitor());
        String resultName = EvaluationVisitorImpl.generateName();
        this.getEvaluationEnvironment().add(resultName, initResultVal);
        try {
            Object object = is.evaluate(coll, iterators, body, resultName);
            return object;
        }
        finally {
            this.getEvaluationEnvironment().remove(resultName);
        }
    }

    private Object evaluateRejectIterator(IteratorExp<C, PM> ie, Collection<?> coll) {
        EList iterators = ie.getIterator();
        OCLExpression body = ie.getBody();
        CollectionType collType = (CollectionType)ie.getSource().getType();
        Collection initResultVal = null;
        initResultVal = collType instanceof SetType ? CollectionUtil.createNewSet() : (collType instanceof BagType ? CollectionUtil.createNewBag() : (collType instanceof SequenceType ? CollectionUtil.createNewSequence() : CollectionUtil.createNewOrderedSet()));
        IterationTemplate is = IterationTemplateReject.getInstance(this.getVisitor());
        String resultName = EvaluationVisitorImpl.generateName();
        this.getEvaluationEnvironment().add(resultName, initResultVal);
        try {
            Object object = is.evaluate(coll, iterators, body, resultName);
            return object;
        }
        finally {
            this.getEvaluationEnvironment().remove(resultName);
        }
    }

    private Object evaluateOneIterator(IteratorExp<C, PM> ie, Collection<?> coll) {
        EList iterators = ie.getIterator();
        OCLExpression body = ie.getBody();
        IterationTemplate is = IterationTemplateOne.getInstance(this.getVisitor());
        String resultName = EvaluationVisitorImpl.generateName();
        this.getEvaluationEnvironment().add(resultName, Boolean.FALSE);
        try {
            Object object = is.evaluate(coll, iterators, body, resultName);
            return object;
        }
        finally {
            this.getEvaluationEnvironment().remove(resultName);
        }
    }

    private Object evaluateAnyIterator(IteratorExp<C, PM> ie, Collection<?> coll) {
        EvaluationEnvironment evaluationEnvironment;
        EList iterators = ie.getIterator();
        OCLExpression body = ie.getBody();
        IterationTemplate is = IterationTemplateAny.getInstance(this.getVisitor());
        String resultName = EvaluationVisitorImpl.generateName();
        boolean anyLessIsInvalid = EvaluationOptions.getValue(evaluationEnvironment = this.getEvaluationEnvironment(), EvaluationOptions.ANY_LESS_IS_INVALID);
        evaluationEnvironment.add(resultName, anyLessIsInvalid ? this.getInvalid() : null);
        try {
            Object object = is.evaluate(coll, iterators, body, resultName);
            return object;
        }
        finally {
            evaluationEnvironment.remove(resultName);
        }
    }

    private Object evaluateSortedByIterator(IteratorExp<C, PM> ie, Collection<?> coll) {
        EList iterators = ie.getIterator();
        OCLExpression body = ie.getBody();
        IterationTemplate is = IterationTemplateSortedBy.getInstance(this.getVisitor());
        String resultName = EvaluationVisitorImpl.generateName();
        HashMap<Object, Comparable<Object>> map = new HashMap<Object, Comparable<Object>>();
        this.getEvaluationEnvironment().add(resultName, map);
        try {
            Object evaluationResult = is.evaluate(coll, iterators, body, resultName);
            if (evaluationResult == this.getInvalid()) {
                Object object = evaluationResult;
                return object;
            }
            is.evaluate(coll, iterators, body, resultName);
        }
        finally {
            this.getEvaluationEnvironment().remove(resultName);
        }
        ArrayList result = new ArrayList(coll);
        Collections.sort(result, this.getComparatorForSortedBy(map, ie));
        Object collType = ie.getSource().getType();
        if (collType instanceof SetType || collType instanceof OrderedSetType) {
            return CollectionUtil.createNewOrderedSet(result);
        }
        return CollectionUtil.createNewSequence(result);
    }

    private Comparator<Object> getComparatorForSortedBy(final Map<Object, Comparable<Object>> map, IteratorExp<C, PM> ie) {
        if (ie.getBody().getType() == this.getUnlimitedNatural()) {
            return new Comparator<Object>(){

                @Override
                public int compare(Object o1, Object o2) {
                    Comparable b1 = (Comparable)map.get(o1);
                    Comparable b2 = (Comparable)map.get(o2);
                    return b1.equals(UNLIMITED) ? (b2.equals(UNLIMITED) ? 0 : 1) : (b2.equals(UNLIMITED) ? -1 : b1.compareTo(b2));
                }
            };
        }
        return new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                Comparable b1 = (Comparable)map.get(o1);
                Comparable b2 = (Comparable)map.get(o2);
                return b1.compareTo(b2);
            }
        };
    }

    private Object evaluateIsUnique(IteratorExp<C, PM> ie, Collection<?> coll) {
        EList iterators = ie.getIterator();
        OCLExpression body = ie.getBody();
        IterationTemplate is = IterationTemplateIsUnique.getInstance(this.getVisitor());
        String resultName = EvaluationVisitorImpl.generateName();
        this.getEvaluationEnvironment().add(resultName, new HashSet());
        try {
            is.evaluate(coll, iterators, body, resultName);
        }
        finally {
            this.getEvaluationEnvironment().remove(resultName);
        }
        return is.isDone() ? Boolean.FALSE : Boolean.TRUE;
    }

    private Object evaluateClosure(IteratorExp<C, PM> ie, Collection<?> coll) {
        EList iterators = ie.getIterator();
        OCLExpression body = ie.getBody();
        Object type = ie.getType();
        Set initResultVal = type instanceof OrderedSetType ? CollectionUtil.createNewOrderedSet() : CollectionUtil.createNewSet();
        IterationTemplate template = IterationTemplateClosure.getInstance(this.getVisitor(), body);
        String resultName = EvaluationVisitorImpl.generateName();
        this.getEvaluationEnvironment().add(resultName, initResultVal);
        try {
            Object object = template.evaluate(coll, iterators, body, resultName);
            return object;
        }
        finally {
            this.getEvaluationEnvironment().remove(resultName);
        }
    }

    @Override
    public Object visitEnumLiteralExp(EnumLiteralExp<C, EL> el) {
        return this.enumerations == null ? el.getReferredEnumLiteral() : this.enumerations.getValue(el.getReferredEnumLiteral());
    }

    @Override
    public Object visitVariableExp(VariableExp<C, PM> v) {
        Variable<C, PM> vd = v.getReferredVariable();
        String varName = vd.getName();
        return this.getEvaluationEnvironment().getValueOf(varName);
    }

    @Override
    public Object visitPropertyCallExp(PropertyCallExp<C, P> pc) {
        List qualifiers;
        P property = pc.getReferredProperty();
        OCLExpression source = pc.getSource();
        Object context = source.accept(this.getVisitor());
        if (this.isUndefined(context)) {
            return this.getInvalid();
        }
        OCLExpression derivation = this.getPropertyBody(property);
        if (derivation != null) {
            return this.navigate(property, derivation, context);
        }
        if (pc.getQualifier().isEmpty()) {
            qualifiers = Collections.emptyList();
        } else {
            qualifiers = new ArrayList();
            for (OCLExpression q : pc.getQualifier()) {
                qualifiers.add(q.accept(this.getVisitor()));
            }
        }
        Collection result = this.getEvaluationEnvironment().navigateProperty(property, qualifiers, context);
        if (pc.getType() instanceof CollectionType && !(result instanceof Collection)) {
            CollectionKind kind = ((CollectionType)pc.getType()).getKind();
            Collection collection = CollectionUtil.createNewCollection(kind);
            collection.add(result);
            result = collection;
        }
        return result;
    }

    @Override
    public Object visitAssociationClassCallExp(AssociationClassCallExp<C, P> ae) {
        Object context = ae.getSource().accept(this.getVisitor());
        if (this.isUndefined(context)) {
            return this.getInvalid();
        }
        return this.getEvaluationEnvironment().navigateAssociationClass(ae.getReferredAssociationClass(), ae.getNavigationSource(), context);
    }

    @Override
    public Object visitVariable(Variable<C, PM> vd) {
        String varName = vd.getName();
        OCLExpression<C> initExp = vd.getInitExpression();
        Object initVal = null;
        if (initExp != null) {
            initVal = this.safeVisitExpression(initExp);
        }
        this.getEvaluationEnvironment().add(varName, initVal);
        return varName;
    }

    @Override
    public Object visitIfExp(IfExp<C> ie) {
        OCLExpression<C> condition = ie.getCondition();
        Object condVal = condition.accept(this.getVisitor());
        if (this.isUndefined(condVal)) {
            return this.getInvalid();
        }
        Boolean condValBool = (Boolean)condVal;
        if (condValBool.booleanValue()) {
            return ie.getThenExpression().accept(this.getVisitor());
        }
        return ie.getElseExpression().accept(this.getVisitor());
    }

    @Override
    public Object visitTypeExp(TypeExp<C> t) {
        return t.getReferredType();
    }

    @Override
    public Object visitStateExp(StateExp<C, S> s) {
        return s.getReferredState();
    }

    @Override
    public Object visitMessageExp(MessageExp<C, COA, SSA> m) {
        throw new UnsupportedOperationException("evaluation of MessageExp");
    }

    @Override
    public Object visitUnspecifiedValueExp(UnspecifiedValueExp<C> uv) {
        throw new UnsupportedOperationException("evaluation of UnspecifiedValueExp");
    }

    @Override
    public Object visitIntegerLiteralExp(IntegerLiteralExp<C> il) {
        return this.coerceNumber(il.getLongSymbol());
    }

    @Override
    public Object visitUnlimitedNaturalLiteralExp(UnlimitedNaturalLiteralExp<C> literalExp) {
        return literalExp.getIntegerSymbol();
    }

    @Override
    public Object visitRealLiteralExp(RealLiteralExp<C> rl) {
        return rl.getRealSymbol();
    }

    @Override
    public Object visitStringLiteralExp(StringLiteralExp<C> sl) {
        return sl.getStringSymbol();
    }

    @Override
    public Object visitBooleanLiteralExp(BooleanLiteralExp<C> bl) {
        return bl.getBooleanSymbol();
    }

    @Override
    public Object visitInvalidLiteralExp(InvalidLiteralExp<C> il) {
        return this.getInvalid();
    }

    @Override
    public Object visitNullLiteralExp(NullLiteralExp<C> il) {
        return null;
    }

    @Override
    public Object visitLetExp(LetExp<C, PM> l) {
        Variable<C, PM> vd = l.getVariable();
        String name = (String)vd.accept(this.getVisitor());
        try {
            OCLExpression<C> inExp = l.getIn();
            Object object = inExp.accept(this.getVisitor());
            return object;
        }
        finally {
            this.getEvaluationEnvironment().remove(name);
        }
    }

    @Override
    public Object visitCollectionLiteralExp(CollectionLiteralExp<C> cl) {
        CollectionKind kind = cl.getKind();
        EList<CollectionLiteralPart<C>> parts = cl.getPart();
        Collection<Object> result = CollectionUtil.createNewCollection(kind);
        if (kind == CollectionKind.SEQUENCE_LITERAL && cl.isSimpleRange()) {
            int lastInt;
            CollectionRange collRange = (CollectionRange)parts.get(0);
            OCLExpression first = collRange.getFirst();
            OCLExpression last = collRange.getLast();
            Integer firstVal = (Integer)first.accept(this.getVisitor());
            if (firstVal == null) {
                result.add(null);
                return result;
            }
            Integer lastVal = (Integer)last.accept(this.getVisitor());
            if (lastVal == null) {
                result.add(null);
                return result;
            }
            int firstInt = firstVal;
            if (firstInt > (lastInt = lastVal.intValue())) {
                return result;
            }
            return new IntegerRangeList(firstInt, lastInt);
        }
        for (CollectionLiteralPart part : parts) {
            if (part instanceof CollectionItem) {
                CollectionItem item = (CollectionItem)part;
                OCLExpression itemExp = item.getItem();
                Object itemVal = itemExp.accept(this.getVisitor());
                if (itemVal == this.getInvalid()) {
                    return this.getInvalid();
                }
                if (itemVal == null && parts.size() <= 1 && this.isImplicitSetConversion(cl)) continue;
                result.add(itemVal);
                continue;
            }
            CollectionRange range = (CollectionRange)part;
            OCLExpression first = range.getFirst();
            OCLExpression last = range.getLast();
            Integer firstVal = (Integer)first.accept(this.getVisitor());
            Integer lastVal = (Integer)last.accept(this.getVisitor());
            if (firstVal == null || lastVal == null) continue;
            int firstInt = firstVal;
            int lastInt = lastVal;
            int i = firstInt;
            while (i <= lastInt) {
                result.add(new Integer(i));
                ++i;
            }
        }
        return result;
    }

    private boolean isImplicitSetConversion(CollectionLiteralExp<C> cl) {
        String implicitSetConversionDetail;
        EAnnotation implicitSetConversionAnnotation;
        boolean result = false;
        if (cl instanceof EModelElement && (implicitSetConversionAnnotation = ((EModelElement)cl).getEAnnotation("http://www.eclipse.org/ocl/1.1.0/OCL/Annotations")) != null && (implicitSetConversionDetail = (String)implicitSetConversionAnnotation.getDetails().get((Object)"IMPLICIT_SET_CONVERSION")) != null && Boolean.valueOf(implicitSetConversionDetail).booleanValue()) {
            result = true;
        }
        return result;
    }

    @Override
    public Object visitTupleLiteralExp(TupleLiteralExp<C, P> tl) {
        Object type = tl.getType();
        EList<TupleLiteralPart<C, P>> tp = tl.getPart();
        HashMap propertyValues = new HashMap();
        for (TupleLiteralPart part : tp) {
            propertyValues.put(part.getAttribute(), part.accept(this.getVisitor()));
        }
        return this.getEvaluationEnvironment().createTuple(type, propertyValues);
    }

    @Override
    public Object visitTupleLiteralPart(TupleLiteralPart<C, P> tp) {
        return tp.getValue().accept(this.getVisitor());
    }

    protected Matcher getRegexMatcher(String regex, String stringToMatch) {
        Matcher result;
        if (this.regexMatchers == null) {
            this.regexMatchers = this.createRegexCache();
        }
        if ((result = this.regexMatchers.get(regex)) == null) {
            result = Pattern.compile(regex).matcher(stringToMatch);
            this.regexMatchers.put(regex, result);
        } else {
            result.reset(stringToMatch);
        }
        return result;
    }

    protected Map<String, Matcher> createRegexCache() {
        return new LinkedHashMap<String, Matcher>(16, 0.75f, true){
            private static final long serialVersionUID = 1L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, Matcher> eldest) {
                return this.size() > 16;
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class IntegerRangeList
    extends AbstractList<Integer> {
        private int first;
        private int last;

        public IntegerRangeList(int first, int last) {
            this.first = first;
            this.last = last;
        }

        @Override
        public int size() {
            return this.last - this.first + 1;
        }

        @Override
        public Integer get(int index) {
            if (index < 0 || index >= this.size()) {
                String message = OCLMessages.bind(OCLMessages.IndexOutOfRange_ERROR_, new Object[]{Integer.toString(index), Integer.toString(this.first), Integer.toString(this.last)});
                IllegalArgumentException error = new IllegalArgumentException(message);
                OCLPlugin.throwing(this.getClass(), "get", error);
                throw error;
            }
            return new Integer(this.first + index);
        }

        @Override
        public Iterator<Integer> iterator() {
            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            class IntegerRangeIterator
            implements Iterator<Integer> {
                private int curr;
                private boolean initialized;

                public IntegerRangeIterator() {
                    this.curr = IntegerRangeList.this.first;
                    this.initialized = false;
                }

                @Override
                public Integer next() {
                    if (!this.initialized) {
                        this.curr = IntegerRangeList.this.first - 1;
                        this.initialized = true;
                    }
                    if (this.hasNext()) {
                        return new Integer(++this.curr);
                    }
                    throw new NoSuchElementException();
                }

                @Override
                public boolean hasNext() {
                    return this.curr < IntegerRangeList.this.last || !this.initialized;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            }
            return new IntegerRangeIterator();
        }
    }
}

