/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.blackbox.java;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.m2m.internal.qvt.oml.NLS;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalModuleEnv;
import org.eclipse.m2m.internal.qvt.oml.blackbox.java.DiagnosticUtil;
import org.eclipse.m2m.internal.qvt.oml.blackbox.java.Java2QVTTypeResolver;
import org.eclipse.m2m.internal.qvt.oml.blackbox.java.JavaBlackboxMessages;
import org.eclipse.m2m.internal.qvt.oml.expressions.DirectionKind;
import org.eclipse.m2m.internal.qvt.oml.expressions.ExpressionsFactory;
import org.eclipse.m2m.internal.qvt.oml.expressions.Helper;
import org.eclipse.m2m.internal.qvt.oml.expressions.ImperativeOperation;
import org.eclipse.m2m.internal.qvt.oml.expressions.VarParameter;
import org.eclipse.m2m.qvt.oml.blackbox.java.Operation;
import org.eclipse.m2m.qvt.oml.blackbox.java.Parameter;
import org.eclipse.m2m.qvt.oml.util.IContext;

class OperationBuilder {
    private Java2QVTTypeResolver fTypeResolver;
    private BasicDiagnostic fProblems;

    OperationBuilder(Java2QVTTypeResolver typeResolver) {
        this.fTypeResolver = typeResolver;
    }

    public EOperation buildOperation(Method javaMethod) {
        this.resetErrors();
        return this.createOperation(javaMethod);
    }

    public Diagnostic getDiagnostics() {
        return this.fProblems != null ? this.fProblems : Diagnostic.OK_INSTANCE;
    }

    private EOperation createOperation(Method method) {
        boolean isContextual;
        boolean isWithExecutionContext;
        EClassifier contextType = null;
        String name = method.getName();
        Type resultType = method.getGenericReturnType();
        Type[] paramTypes = method.getGenericParameterTypes();
        Annotation[][] annotations = method.getParameterAnnotations();
        int paramTypesCount = paramTypes.length;
        Operation operAnnotation = method.getAnnotation(Operation.class);
        boolean bl = isWithExecutionContext = operAnnotation != null && operAnnotation.withExecutionContext();
        if (isWithExecutionContext && (paramTypesCount == 0 || paramTypes[0] != IContext.class)) {
            this.reportError(NLS.bind(JavaBlackboxMessages.QvtoContextParameterRequired, method.getName()), method);
            --paramTypesCount;
        }
        boolean bl2 = isContextual = operAnnotation != null && operAnnotation.contextual();
        if (isContextual && paramTypesCount == 0) {
            this.reportError(NLS.bind(JavaBlackboxMessages.FirstContextualOperationParameterRequired, method), method);
        }
        Operation.Kind operKind = OperationBuilder.getOperationKind(operAnnotation);
        EOperation operation = null;
        switch (operKind) {
            case OPERATION: {
                operation = EcoreFactory.eINSTANCE.createEOperation();
                break;
            }
            case MAPPING: {
                operation = ExpressionsFactory.eINSTANCE.createMappingOperation();
                break;
            }
            case CONSTRUCTOR: {
                if (!isContextual) {
                    this.reportError(NLS.bind(JavaBlackboxMessages.ConstructorRequiresContextualOperation, method.getName()), method);
                }
                operation = ExpressionsFactory.eINSTANCE.createConstructor();
                break;
            }
            case HELPER: 
            case QUERY: {
                Helper helper = ExpressionsFactory.eINSTANCE.createHelper();
                helper.setIsQuery(operKind == Operation.Kind.QUERY);
                operation = helper;
                break;
            }
            case TRANSFORMATION: {
                if (isContextual) {
                    this.reportError(NLS.bind(JavaBlackboxMessages.TransformationRequiresContextlessOperation, method.getName()), method);
                }
                operation = EcoreFactory.eINSTANCE.createEOperation();
                break;
            }
            default: {
                assert (false) : "unsupported operation kind";
                operation = EcoreFactory.eINSTANCE.createEOperation();
            }
        }
        operation.setName(name);
        operation.setEType(this.fTypeResolver.toEClassifier(resultType, 2));
        if (operation.getEType() == null) {
            this.reportError(NLS.bind(JavaBlackboxMessages.UnresolvedOclTypeForJavaType, method.getReturnType(), method), method);
        }
        int i = 0;
        QvtOperationalModuleEnv environment = this.fTypeResolver.getEnvironment();
        Type[] typeArray = paramTypes;
        int n = paramTypes.length;
        int n2 = 0;
        while (n2 < n) {
            Type paramType = typeArray[n2];
            if (i == 0 && paramType == IContext.class) {
                ++i;
            } else {
                Parameter paramAnno;
                VarParameter eParameter;
                VarParameter varParam = operKind != Operation.Kind.OPERATION ? ExpressionsFactory.eINSTANCE.createVarParameter() : null;
                VarParameter varParameter = eParameter = varParam != null ? varParam : EcoreFactory.eINSTANCE.createEParameter();
                if (varParam != null) {
                    varParam.setKind(DirectionKind.IN);
                }
                eParameter.setEType(this.fTypeResolver.toEClassifier(paramType, 4));
                if (eParameter.getEType() == null) {
                    this.reportError(NLS.bind(JavaBlackboxMessages.UnresolvedOclTypeForJavaType, paramType, method), method);
                }
                String paramName = (paramAnno = OperationBuilder.getParameterAnnotation(annotations[i])) != null && paramAnno.name() != null ? paramAnno.name() : "arg" + (isWithExecutionContext ? i - 1 : i);
                eParameter.setName(paramName);
                if (isContextual && (isWithExecutionContext ? i == 1 : i == 0)) {
                    if (operKind != Operation.Kind.OPERATION) {
                        assert (operation instanceof ImperativeOperation);
                        assert (varParam != null);
                        varParam.setName("self");
                        ((ImperativeOperation)operation).setContext(varParam);
                    }
                    contextType = eParameter.getEType();
                } else {
                    operation.getEParameters().add((Object)eParameter);
                }
                ++i;
            }
            ++n2;
        }
        if (operation instanceof ImperativeOperation) {
            ImperativeOperation imperativeOperation = (ImperativeOperation)operation;
            environment.defineImperativeOperation(imperativeOperation, false, true);
        } else if (contextType != null) {
            environment.getTypeResolver().resolveAdditionalOperation(contextType, operation);
        }
        return operation;
    }

    static Operation.Kind getOperationKind(Operation operAnnotation) {
        Operation.Kind operKind;
        Operation.Kind kind = operKind = operAnnotation != null ? operAnnotation.kind() : Operation.Kind.OPERATION;
        if (operKind == Operation.Kind.OPERATION) {
            operKind = Operation.Kind.HELPER;
        }
        return operKind;
    }

    private static Parameter getParameterAnnotation(Annotation[] allAnnotations) {
        Annotation[] annotationArray = allAnnotations;
        int n = allAnnotations.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation annotation = annotationArray[n2];
            if (annotation.annotationType() == Parameter.class) {
                return (Parameter)annotation;
            }
            ++n2;
        }
        return null;
    }

    private void resetErrors() {
        this.fProblems = null;
    }

    private void reportError(String message, Method problemMethod) {
        if (this.fProblems == null) {
            this.fProblems = DiagnosticUtil.createRootDiagnostic(NLS.bind(JavaBlackboxMessages.LoadOperationDiagnostics, problemMethod));
        }
        this.fProblems.add((Diagnostic)DiagnosticUtil.createErrorDiagnostic(message));
    }
}

