/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.ui.internal.search;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.help.internal.workingset.AdaptableHelpResource;
import org.eclipse.help.internal.workingset.AdaptableTocsArray;
import org.eclipse.help.internal.workingset.WorkingSet;
import org.eclipse.help.ui.RootScopePage;
import org.eclipse.help.ui.internal.Messages;
import org.eclipse.help.ui.internal.search.HelpWorkingSetElementLabelProvider;
import org.eclipse.help.ui.internal.search.HelpWorkingSetTreeContentProvider;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class InfoCenterPage
extends RootScopePage {
    private Text urlText;
    private Button searchAll;
    private Button searchSelected;
    private CheckboxTreeViewer tree;
    private ITreeContentProvider treeContentProvider;
    private ILabelProvider elementLabelProvider;
    private AdaptableTocsArray remoteTocs;
    private RemoteWorkingSet workingSet;
    private boolean tocStale;

    @Override
    protected int createScopeContents(Composite parent) {
        Font font = parent.getFont();
        this.initializeDialogUnits((Control)parent);
        Label label = new Label(parent, 0);
        label.setText(Messages.InfoCenterPage_url);
        this.urlText = new Text(parent, 2048);
        this.urlText.setLayoutData((Object)new GridData(768));
        this.urlText.setEditable(this.getEngineDescriptor().isUserDefined());
        this.searchAll = new Button(parent, 16);
        this.searchAll.setText(Messages.selectAll);
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        this.searchAll.setLayoutData((Object)gd);
        this.searchAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (InfoCenterPage.this.searchAll.getSelection()) {
                    InfoCenterPage.this.tree.getTree().setEnabled(false);
                }
            }
        });
        this.searchSelected = new Button(parent, 16);
        this.searchSelected.setText(Messages.selectWorkingSet);
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.searchSelected.setLayoutData((Object)gd);
        this.searchSelected.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (InfoCenterPage.this.searchSelected.getSelection()) {
                    InfoCenterPage.this.tree.getTree().setEnabled(true);
                    if (InfoCenterPage.this.tocStale) {
                        InfoCenterPage.this.updateTocs();
                    }
                }
            }
        });
        label = new Label(parent, 64);
        label.setFont(font);
        label.setText(Messages.WorkingSetContent);
        gd = new GridData(772);
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        this.tree = new CheckboxTreeViewer(parent, 2816);
        gd = new GridData(1808);
        gd.heightHint = this.convertHeightInCharsToPixels(15);
        gd.horizontalSpan = 2;
        this.tree.getControl().setLayoutData((Object)gd);
        this.tree.getControl().setFont(font);
        this.treeContentProvider = new HelpWorkingSetTreeContentProvider();
        this.tree.setContentProvider((IContentProvider)this.treeContentProvider);
        this.elementLabelProvider = new HelpWorkingSetElementLabelProvider();
        this.tree.setLabelProvider((IBaseLabelProvider)this.elementLabelProvider);
        this.tree.setUseHashlookup(true);
        this.initializeControls();
        this.tree.addCheckStateListener(event -> this.handleCheckStateChange(event));
        this.tree.addTreeListener(new ITreeViewerListener(){

            public void treeCollapsed(TreeExpansionEvent event) {
            }

            public void treeExpanded(TreeExpansionEvent event) {
                Object element = event.getElement();
                if (!InfoCenterPage.this.tree.getGrayed(element)) {
                    BusyIndicator.showWhile((Display)InfoCenterPage.this.getShell().getDisplay(), () -> InfoCenterPage.this.setSubtreeChecked(element, InfoCenterPage.this.tree.getChecked(element), false));
                }
            }
        });
        this.applyDialogFont(parent);
        return 2;
    }

    private void initializeControls() {
        IPreferenceStore store = this.getPreferenceStore();
        String url = store.getString(this.getKey("url"));
        if (url.length() == 0 && (url = (String)this.getEngineDescriptor().getParameters().get("url")) == null) {
            url = "";
        }
        this.urlText.setText(url);
        this.workingSet = new RemoteWorkingSet();
        this.workingSet.load(store);
        this.urlText.addModifyListener(e -> {
            boolean bl = this.tocStale = true;
        });
        this.tree.setInput((Object)this.remoteTocs);
        boolean selected = false;
        this.searchAll.setSelection(!selected);
        this.searchSelected.setSelection(selected);
        this.tree.getTree().setEnabled(selected);
        this.searchAll.setEnabled(false);
        this.searchSelected.setEnabled(false);
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), () -> {
            Object[] elements = this.workingSet.getElements();
            this.tree.setCheckedElements(elements);
            int i = 0;
            while (i < elements.length) {
                Object element = elements[i];
                if (this.isExpandable(element)) {
                    this.setSubtreeChecked(element, true, true);
                }
                this.updateParentState(element, true);
                ++i;
            }
        });
    }

    private void updateTocs() {
        this.tocStale = false;
        this.tree.setInput((Object)this.remoteTocs);
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), () -> {
            Object[] elements = this.workingSet.getElements();
            this.tree.setCheckedElements(elements);
            int i = 0;
            while (i < elements.length) {
                Object element = elements[i];
                if (this.isExpandable(element)) {
                    this.setSubtreeChecked(element, true, true);
                }
                this.updateParentState(element, true);
                ++i;
            }
        });
    }

    boolean isExpandable(Object element) {
        return this.treeContentProvider.hasChildren(element);
    }

    void updateParentState(Object child, boolean baseChildState) {
        if (child == null) {
            return;
        }
        Object parent = this.treeContentProvider.getParent(child);
        if (parent == null) {
            return;
        }
        boolean allSameState = true;
        Object[] children = null;
        children = this.treeContentProvider.getChildren(parent);
        int i = children.length - 1;
        while (i >= 0) {
            if (this.tree.getChecked(children[i]) != baseChildState || this.tree.getGrayed(children[i])) {
                allSameState = false;
                break;
            }
            --i;
        }
        this.tree.setGrayed(parent, !allSameState);
        this.tree.setChecked(parent, !allSameState || baseChildState);
        this.updateParentState(parent, baseChildState);
    }

    void setSubtreeChecked(Object parent, boolean state, boolean checkExpandedState) {
        Object[] children = this.treeContentProvider.getChildren(parent);
        int i = children.length - 1;
        while (i >= 0) {
            Object element = children[i];
            if (state) {
                this.tree.setChecked(element, true);
                this.tree.setGrayed(element, false);
            } else {
                this.tree.setGrayChecked(element, false);
            }
            if (this.isExpandable(element)) {
                this.setSubtreeChecked(element, state, checkExpandedState);
            }
            --i;
        }
    }

    private void findCheckedElements(List checkedResources, Object parent) {
        Object[] children = this.treeContentProvider.getChildren(parent);
        int i = 0;
        while (i < children.length) {
            if (this.tree.getGrayed(children[i])) {
                this.findCheckedElements(checkedResources, children[i]);
            } else if (this.tree.getChecked(children[i])) {
                checkedResources.add(children[i]);
            }
            ++i;
        }
    }

    void handleCheckStateChange(CheckStateChangedEvent event) {
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), () -> {
            Object element = event.getElement();
            boolean state = event.getChecked();
            this.tree.setGrayed(element, false);
            if (this.isExpandable(element)) {
                this.setSubtreeChecked(element, state, state);
            }
            this.updateParentState(element, state);
        });
    }

    public void updateWorkingSet() {
        ArrayList elements = new ArrayList(10);
        this.findCheckedElements(elements, this.tree.getInput());
        this.workingSet.setElements(elements.toArray(new AdaptableHelpResource[elements.size()]));
    }

    @Override
    public boolean performOk() {
        IPreferenceStore store = this.getPreferenceStore();
        if (this.getEngineDescriptor().isUserDefined()) {
            store.setValue(this.getKey("url"), this.urlText.getText());
        }
        this.updateWorkingSet();
        this.workingSet.store(store);
        store.setValue(this.getKey("searchSelected"), this.searchSelected.getSelection());
        return super.performOk();
    }

    private String getKey(String key) {
        return String.valueOf(this.getEngineDescriptor().getId()) + "." + key;
    }

    class RemoteWorkingSet
    extends WorkingSet {
        public RemoteWorkingSet() {
            super("InfoCenter");
        }

        public void load(IPreferenceStore store) {
            String elements = store.getString(InfoCenterPage.this.getKey("tocs"));
            StringTokenizer stok = new StringTokenizer(elements, ";");
            ArrayList<AdaptableHelpResource> list = new ArrayList<AdaptableHelpResource>();
            while (stok.hasMoreTokens()) {
                String url = stok.nextToken();
                AdaptableHelpResource res = this.find(url);
                if (res == null) continue;
                list.add(res);
            }
            this.setElements(list.toArray(new AdaptableHelpResource[list.size()]));
        }

        private AdaptableHelpResource find(String url) {
            if (InfoCenterPage.this.remoteTocs == null) {
                return null;
            }
            IAdaptable[] children = InfoCenterPage.this.remoteTocs.getChildren();
            int i = 0;
            while (i < children.length) {
                AdaptableHelpResource res;
                IAdaptable child = children[i];
                if (child instanceof AdaptableHelpResource && (res = (AdaptableHelpResource)child).getHref().equals(url)) {
                    return res;
                }
                ++i;
            }
            return null;
        }

        public void store(IPreferenceStore store) {
            StringBuilder buf = new StringBuilder();
            AdaptableHelpResource[] elements = this.getElements();
            int i = 0;
            while (i < elements.length) {
                if (i > 0) {
                    buf.append(";");
                }
                buf.append(elements[i].getHref());
                ++i;
            }
            store.setValue(InfoCenterPage.this.getKey("tocs"), buf.toString());
        }
    }
}

