/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.xdsmlframework.ide.ui.builder;

import java.io.IOException;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.gemoc.commons.eclipse.pde.manifest.ManifestChanger;
import org.eclipse.gemoc.dsl.Dsl;
import org.eclipse.gemoc.xdsmlframework.ide.ui.Activator;
import org.eclipse.gemoc.xdsmlframework.ide.ui.builder.pde.PluginXMLHelper;
import org.eclipse.jdt.core.IJavaProject;
import org.jdom2.Element;
import org.osgi.framework.BundleException;

public class GemocLanguageProjectBuilder
extends IncrementalProjectBuilder {
    public static final String BUILDER_ID = "org.eclipse.gemoc.xdsmlframework.ide.ui.GemocLanguageProjectBuilder";

    protected IProject[] build(int kind, Map<String, String> args, IProgressMonitor monitor) throws CoreException {
        if (kind == 6) {
            this.fullBuild(monitor);
        } else {
            IResourceDelta delta = this.getDelta(this.getProject());
            if (delta == null) {
                this.fullBuild(monitor);
            } else {
                this.incrementalBuild(delta, monitor);
            }
        }
        return null;
    }

    public void checkConsistency(IResource resource) {
    }

    private void updateProjectPluginConfiguration(IResource resource) {
        if (resource instanceof IFile && resource.getFileExtension().equals("dsl") && !resource.getLocation().toString().contains("/bin/")) {
            IFile file = (IFile)resource;
            IProject project = file.getProject();
            try {
                IJavaProject javaProject = (IJavaProject)project.getNature("org.eclipse.jdt.core.javanature");
                if (javaProject.getOutputLocation().isPrefixOf(file.getFullPath())) {
                    return;
                }
            }
            catch (CoreException e) {
                Activator.error(e.getMessage(), e);
            }
            if (file.exists()) {
                Job job = Job.create((String)("Update GEMOC Project Plugin Configuration of " + project.getName()), monitor -> {
                    Resource res = new ResourceSetImpl().getResource(URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true), true);
                    if (res != null && res.getContents().size() > 0 && res.getContents().get(0) instanceof Dsl) {
                        Dsl dsl = (Dsl)res.getContents().get(0);
                        String languageName = dsl.getName();
                        if (languageName == null || languageName.isEmpty()) {
                            languageName = file.getName();
                        }
                        this.setPluginLanguageNameAndFilePath(project, file, languageName);
                    }
                    this.updateModelLoaderClass(project, null);
                    ManifestChanger manifestChanger = new ManifestChanger(project);
                    try {
                        manifestChanger.addPluginDependency("org.eclipse.gemoc.executionframework.extensions.sirius");
                        manifestChanger.commit();
                    }
                    catch (IOException | CoreException | BundleException e) {
                        Activator.error(e.getMessage(), e);
                    }
                });
                job.setRule((ISchedulingRule)project);
                job.schedule(500L);
            }
        }
    }

    protected void updateModelLoaderClass(IProject project, String modelLoaderClass) {
        IFile pluginfile = project.getFile("plugin.xml");
        PluginXMLHelper.createEmptyTemplateFile(pluginfile, false);
        PluginXMLHelper helper = new PluginXMLHelper();
        helper.loadDocument(pluginfile);
        Element gemocExtensionPoint = helper.getOrCreateExtensionPoint("org.eclipse.gemoc.gemoc_language_workbench.xdsml");
        helper.updateXDSMLDefinitionAttributeInExtensionPoint(gemocExtensionPoint, "modelLoader_class", modelLoaderClass != null ? modelLoaderClass : "org.eclipse.gemoc.executionframework.extensions.sirius.modelloader.DefaultModelLoader");
        helper.saveDocument(pluginfile);
    }

    protected void setPluginLanguageNameAndFilePath(IProject project, IFile dslFile, String languageName) {
        IFile pluginfile = project.getFile("plugin.xml");
        PluginXMLHelper.createEmptyTemplateFile(pluginfile, false);
        PluginXMLHelper helper = new PluginXMLHelper();
        helper.loadDocument(pluginfile);
        Element gemocExtensionPoint = helper.getOrCreateExtensionPoint("org.eclipse.gemoc.gemoc_language_workbench.xdsml");
        helper.updateXDSMLDefinitionInExtensionPoint(gemocExtensionPoint, languageName);
        helper.updateXDSMLDefinitionAttributeInExtensionPoint(gemocExtensionPoint, "xdsmlFilePath", dslFile.getFullPath().toString());
        helper.saveDocument(pluginfile);
    }

    protected void clean(IProgressMonitor monitor) throws CoreException {
    }

    protected void fullBuild(IProgressMonitor monitor) throws CoreException {
        try {
            this.getProject().accept((IResourceVisitor)new GemocSequentialLanguageResourceVisitor());
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    protected void incrementalBuild(IResourceDelta delta, IProgressMonitor monitor) throws CoreException {
        delta.accept((IResourceDeltaVisitor)new GemocSequentialLanguageProjectDeltaVisitor());
    }

    class GemocSequentialLanguageProjectDeltaVisitor
    implements IResourceDeltaVisitor {
        GemocSequentialLanguageProjectDeltaVisitor() {
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IResource resource = delta.getResource();
            switch (delta.getKind()) {
                case 1: {
                    GemocLanguageProjectBuilder.this.updateProjectPluginConfiguration(resource);
                    GemocLanguageProjectBuilder.this.checkConsistency(resource);
                    break;
                }
                case 2: {
                    GemocLanguageProjectBuilder.this.updateProjectPluginConfiguration(resource);
                    GemocLanguageProjectBuilder.this.checkConsistency(resource);
                    break;
                }
                case 4: {
                    GemocLanguageProjectBuilder.this.updateProjectPluginConfiguration(resource);
                    GemocLanguageProjectBuilder.this.checkConsistency(resource);
                }
            }
            return true;
        }
    }

    class GemocSequentialLanguageResourceVisitor
    implements IResourceVisitor {
        GemocSequentialLanguageResourceVisitor() {
        }

        public boolean visit(IResource resource) {
            GemocLanguageProjectBuilder.this.updateProjectPluginConfiguration(resource);
            GemocLanguageProjectBuilder.this.checkConsistency(resource);
            return resource instanceof IFolder || resource instanceof IProject;
        }
    }
}

