/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.xdsmlframework.extensions.sirius.wizards.pages;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.gemoc.xdsmlframework.extensions.sirius.wizards.pages.NewGemocSiriusProjectWizardFields;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.sirius.editor.editorPlugin.SiriusEditorPlugin;
import org.eclipse.sirius.ui.tools.api.project.ViewpointSpecificationProject;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class NewODesignFileWizardPage
extends WizardPage {
    private static final String DOT = ".";
    private List<String> encodings;
    private Combo encodingField;
    private ModifyListener validator = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            NewODesignFileWizardPage.this.setPageComplete(NewODesignFileWizardPage.this.validatePage());
            NewODesignFileWizardPage.this.isVsmNameChanged = true;
        }
    };
    private Text modelName;
    private Boolean isVsmNameChanged = false;
    private NewGemocSiriusProjectWizardFields context;

    public NewODesignFileWizardPage(String pageName, NewGemocSiriusProjectWizardFields context) {
        super(pageName);
        this.context = context;
    }

    public Text getModelName() {
        return this.modelName;
    }

    public String getEncoding() {
        return this.encodingField.getText();
    }

    public String getInitialObjectName() {
        return ViewpointSpecificationProject.INITIAL_OBJECT_NAME;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.verticalSpacing = 12;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.grabExcessVerticalSpace = true;
        data.horizontalAlignment = 4;
        composite.setLayoutData((Object)data);
        Label modelNameLabel = new Label(composite, 16384);
        modelNameLabel.setText(SiriusEditorPlugin.getPlugin().getString("_UI_SiriusModelWizardName_label"));
        data = new GridData();
        data.horizontalAlignment = 4;
        modelNameLabel.setLayoutData((Object)data);
        this.modelName = new Text(composite, 18432);
        this.modelName.setText(this.extractModelName(this.context.projectName));
        data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        this.modelName.setLayoutData((Object)data);
        this.modelName.addModifyListener(this.validator);
        Label encodingLabel = new Label(composite, 16384);
        encodingLabel.setText(SiriusEditorPlugin.getPlugin().getString("_UI_XMLEncoding"));
        data = new GridData();
        data.horizontalAlignment = 4;
        encodingLabel.setLayoutData((Object)data);
        this.encodingField = new Combo(composite, 2048);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        this.encodingField.setLayoutData((Object)data);
        for (String string : this.getEncodings()) {
            this.encodingField.add(string);
        }
        this.encodingField.select(0);
        this.encodingField.addModifyListener(this.validator);
        this.setPageComplete(this.validatePage());
        this.setControl((Control)composite);
    }

    protected boolean validatePage() {
        return this.getEncodings().contains(this.encodingField.getText()) && this.getModelName().getText().endsWith(DOT + ViewpointSpecificationProject.VIEWPOINT_MODEL_EXTENSION) && this.getModelName().getText().length() > ViewpointSpecificationProject.VIEWPOINT_MODEL_EXTENSION.length() + 1;
    }

    private Collection<String> getEncodings() {
        if (this.encodings == null) {
            this.encodings = new ArrayList<String>();
            StringTokenizer stringTokenizer = new StringTokenizer(SiriusEditorPlugin.getPlugin().getString("_UI_XMLEncodingChoices"));
            while (stringTokenizer.hasMoreTokens()) {
                this.encodings.add(stringTokenizer.nextToken());
            }
        }
        return this.encodings;
    }

    public void setVisible(boolean visible) {
        if (visible && !this.isVsmNameChanged.booleanValue()) {
            this.modelName.setText(this.extractModelName(this.context.projectName));
        }
        super.setVisible(visible);
    }

    private String extractModelName(String projectName) {
        String[] projectNames;
        String modelPrefixName = "";
        modelPrefixName = projectName != null && projectName.contains(DOT) ? ("design".equals((projectNames = projectName.split("[.]"))[projectNames.length - 1]) ? projectNames[projectNames.length - 2] : projectNames[projectNames.length - 1]) : projectName;
        return String.valueOf(modelPrefixName) + DOT + ViewpointSpecificationProject.VIEWPOINT_MODEL_EXTENSION;
    }
}

