/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.xdsmlframework.api.extensions;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.gemoc.xdsmlframework.api.extensions.Extension;

public abstract class ExtensionPoint<T extends Extension> {
    private Class<? extends Extension> _class;

    protected ExtensionPoint(Class<? extends Extension> extensionClazz) {
        this._class = extensionClazz;
    }

    private T createInstance() throws InstantiationException, IllegalAccessException {
        Extension instance = this._class.newInstance();
        instance.setSpecification(null);
        return (T)instance;
    }

    protected abstract String getExtensionPointName();

    protected Collection<T> internal_getSpecifications() {
        IConfigurationElement[] confElements = ExtensionPoint.getExtensions(this.getExtensionPointName());
        ArrayList<T> specs = new ArrayList<T>();
        int i = 0;
        while (i < confElements.length) {
            try {
                T s = this.createInstance();
                ((Extension)s).setSpecification(confElements[i]);
                specs.add(s);
            }
            catch (IllegalAccessException | InstantiationException e) {
                e.printStackTrace();
            }
            ++i;
        }
        return specs;
    }

    protected static IConfigurationElement[] getExtensions(String extensionPointName) {
        return Platform.getExtensionRegistry().getConfigurationElementsFor(extensionPointName);
    }
}

