/**
 * Copyright (c) 2016, 2017 Inria and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Inria - initial API and implementation
 */
package org.eclipse.gemoc.xdsmlframework.api.engine_addon.modelchangelistener;

import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gemoc.xdsmlframework.api.engine_addon.modelchangelistener.FieldModelChange;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.xbase.lib.Pure;

@SuppressWarnings("all")
public class PotentialCollectionFieldModelChange extends FieldModelChange {
  @Accessors({ AccessorType.PROTECTED_SETTER, AccessorType.PUBLIC_GETTER })
  private Object emfNotifications;
  
  public PotentialCollectionFieldModelChange(final EObject changedObject, final EStructuralFeature changedField, final List<Notification> notifications) {
    super(changedObject, changedField);
    this.emfNotifications = notifications;
  }
  
  @Pure
  public Object getEmfNotifications() {
    return this.emfNotifications;
  }
  
  protected void setEmfNotifications(final Object emfNotifications) {
    this.emfNotifications = emfNotifications;
  }
}
