/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.trace.gemoc.generator;

import com.google.common.collect.Iterables;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import opsemanticsview.OperationalSemanticsView;
import opsemanticsview.Rule;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.gemoc.trace.commons.CodeGenUtil;
import org.eclipse.gemoc.trace.commons.EclipseUtil;
import org.eclipse.gemoc.trace.commons.EcoreCraftingUtil;
import org.eclipse.gemoc.trace.commons.ManifestUtil;
import org.eclipse.gemoc.trace.gemoc.generator.codegen.StateManagerGeneratorJava;
import org.eclipse.gemoc.trace.gemoc.generator.codegen.TraceConstructorGeneratorJava;
import org.eclipse.gemoc.trace.gemoc.generator.util.StandaloneEMFProjectGenerator;
import org.eclipse.gemoc.trace.metamodel.generator.TraceMMGenerationTraceability;
import org.eclipse.gemoc.trace.metamodel.generator.TraceMMGenerator;
import org.eclipse.gemoc.xdsmlframework.ide.ui.builder.pde.PluginXMLHelper;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.PlatformUI;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.filter.ElementFilter;
import org.jdom2.filter.Filter;

public class GenericEngineTraceAddonGenerator {
    private final OperationalSemanticsView opsemanticsview;
    private final String pluginName;
    private final String packageQN;
    private final String className;
    private final String languageName;
    private final String tracedLanguageName;
    private final String stepFactoryClassName;
    private String traceConstructorClassName;
    private String stateManagerClassName;
    private TraceMMGenerationTraceability traceability;
    private Set<GenPackage> genPackages;
    private IPackageFragment packageFragment;
    private EPackage tracemm;
    private boolean partialTraceManagement = false;
    @Accessors(value={AccessorType.PUBLIC_GETTER, AccessorType.PROTECTED_SETTER})
    private IProject project;

    public GenericEngineTraceAddonGenerator(OperationalSemanticsView opsemanticsview, String pluginName) {
        String _plus_2;
        String _plus_1;
        String _plus;
        this.opsemanticsview = opsemanticsview;
        this.pluginName = pluginName;
        this.packageQN = String.valueOf(pluginName) + ".tracemanager";
        this.tracedLanguageName = opsemanticsview.getExecutionMetamodel().getName();
        String _replaceAll = this.tracedLanguageName.replaceAll(" ", "");
        this.languageName = _plus = String.valueOf(_replaceAll) + "Trace";
        String _firstUpper = StringExtensions.toFirstUpper((String)this.languageName.replaceAll(" ", ""));
        this.className = _plus_1 = String.valueOf(_firstUpper) + "EngineAddon";
        String _firstUpper_1 = StringExtensions.toFirstUpper((String)this.languageName.replaceAll(" ", ""));
        this.stepFactoryClassName = _plus_2 = String.valueOf(_firstUpper_1) + "StepFactory";
    }

    public void generateCompleteAddon() {
        try {
            IRunnableWithProgress _function = m -> this.generateCompleteAddon(m);
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().run(false, true, _function);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public static String getBaseFQN(Rule r) {
        EOperation o = r.getOperation();
        EClass c = r.getContainingClass();
        String _baseFQN = EcoreCraftingUtil.getBaseFQN((EClassifier)c);
        String _plus = String.valueOf(_baseFQN) + ".";
        String _name = o.getName();
        return String.valueOf(_plus) + _name;
    }

    private String getJavaFQN(EClassifier c) {
        return this.getJavaFQN(c, false);
    }

    private String getJavaFQN(EClassifier c, boolean enforcePrimitiveJavaClass) {
        return EcoreCraftingUtil.getJavaFQN((EClassifier)c, this.genPackages, (boolean)enforcePrimitiveJavaClass);
    }

    private static Set<GenPackage> findNestedGenpackages(GenPackage p) {
        Set result = IterableExtensions.toSet((Iterable)p.getNestedGenPackages());
        result.add(p);
        EList _nestedGenPackages = p.getNestedGenPackages();
        for (GenPackage n : _nestedGenPackages) {
            result.addAll(GenericEngineTraceAddonGenerator.findNestedGenpackages(n));
        }
        return result;
    }

    public void generateCompleteAddon(IProgressMonitor m) {
        this.generateTraceMetamodelAndPlugin(m);
        this.prepareManifest(m);
        this.generateTraceManagementCode(m);
        this.addExtensionPoint();
    }

    private void generateTraceMetamodelAndPlugin(IProgressMonitor m) {
        try {
            TraceMMGenerator tmmgenerator = new TraceMMGenerator(this.opsemanticsview, true);
            tmmgenerator.computeAllMaterial();
            tmmgenerator.sortResult();
            this.tracemm = tmmgenerator.getTracemmresult();
            StandaloneEMFProjectGenerator emfGen = new StandaloneEMFProjectGenerator(this.pluginName, this.tracemm);
            emfGen.generateBaseEMFProject(m);
            Set<GenPackage> referencedGenPackagesRoots = emfGen.getReferencedGenPackages();
            Functions.Function1 _function = it -> GenericEngineTraceAddonGenerator.findNestedGenpackages(it);
            this.genPackages = IterableExtensions.toSet((Iterable)Iterables.concat((Iterable)IterableExtensions.map(referencedGenPackagesRoots, (Functions.Function1)_function)));
            tmmgenerator.addGetCallerEOperations(emfGen.getRootPackages(), this.genPackages);
            ((EPackage)IterableExtensions.head(emfGen.getRootPackages())).eResource().save(null);
            emfGen.generateModelCode(m);
            this.project = emfGen.getProject();
            IJavaProject javaProject = JavaCore.create((IProject)this.project);
            List sourceFolders = EclipseUtil.findSrcFoldersOf((IJavaProject)javaProject);
            IPackageFragmentRoot srcFolderFragment = javaProject.getPackageFragmentRoot((IResource)sourceFolders.get(0));
            this.packageFragment = srcFolderFragment.createPackageFragment(this.packageQN, true, m);
            this.traceability = tmmgenerator.getTraceability();
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private void generateTraceManagementCode(IProgressMonitor m) {
        try {
            EPackage _executionMetamodel = this.opsemanticsview.getExecutionMetamodel();
            TraceConstructorGeneratorJava tconstructorgen = new TraceConstructorGeneratorJava(this.languageName, String.valueOf(this.pluginName) + ".tracemanager", this.tracemm, this.traceability, this.genPackages, _executionMetamodel, this.partialTraceManagement);
            this.traceConstructorClassName = tconstructorgen.getClassName();
            this.packageFragment.createCompilationUnit(String.valueOf(this.traceConstructorClassName) + ".java", tconstructorgen.generateCode(), true, m);
            StateManagerGeneratorJava statemanagergem = new StateManagerGeneratorJava(this.languageName, String.valueOf(this.pluginName) + ".tracemanager", this.tracemm, this.traceability, this.genPackages);
            this.stateManagerClassName = statemanagergem.getClassName();
            this.packageFragment.createCompilationUnit(String.valueOf(this.stateManagerClassName) + ".java", statemanagergem.generateCode(), true, m);
            IPackageFragment fragment = this.packageFragment;
            String prettyCode = CodeGenUtil.formatJavaCode((String)this.generateAddonClassCode());
            fragment.createCompilationUnit(String.valueOf(this.className) + ".java", prettyCode, true, m);
            String uglyFactoryCode = this.generateStepFactory();
            String prettyCodeStepFactory = CodeGenUtil.formatJavaCode((String)uglyFactoryCode);
            fragment.createCompilationUnit(String.valueOf(this.stepFactoryClassName) + ".java", prettyCodeStepFactory, true, m);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private boolean prepareManifest(IProgressMonitor m) {
        try {
            boolean _xblockexpression = false;
            ManifestUtil.addToPluginManifest((IProject)this.project, (IProgressMonitor)m, (String)"org.eclipse.emf.transaction");
            ManifestUtil.addToPluginManifest((IProject)this.project, (IProgressMonitor)m, (String)"org.eclipse.emf.compare");
            ManifestUtil.addToPluginManifest((IProject)this.project, (IProgressMonitor)m, (String)"org.eclipse.gemoc.executionframework.engine");
            ManifestUtil.addToPluginManifest((IProject)this.project, (IProgressMonitor)m, (String)"org.eclipse.xtext");
            ManifestUtil.addToPluginManifest((IProject)this.project, (IProgressMonitor)m, (String)"org.eclipse.gemoc.commons.eclipse");
            ManifestUtil.addToPluginManifest((IProject)this.project, (IProgressMonitor)m, (String)"org.eclipse.gemoc.trace.gemoc");
            ManifestUtil.addToPluginManifest((IProject)this.project, (IProgressMonitor)m, (String)"org.eclipse.gemoc.trace.gemoc.api");
            ManifestUtil.addToPluginManifest((IProject)this.project, (IProgressMonitor)m, (String)"org.eclipse.gemoc.xdsmlframework.api");
            ManifestUtil.addToPluginManifest((IProject)this.project, (IProgressMonitor)m, (String)"org.eclipse.gemoc.trace.commons.model");
            ManifestUtil.addToPluginManifest((IProject)this.project, (IProgressMonitor)m, (String)"org.eclipse.gemoc.addon.multidimensional.timeline");
            ManifestUtil.addToPluginManifest((IProject)this.project, (IProgressMonitor)m, (String)"org.eclipse.gemoc.timeline");
            ManifestUtil.addToPluginManifest((IProject)this.project, (IProgressMonitor)m, (String)"org.eclipse.gemoc.trace.commons");
            ManifestUtil.addToPluginManifest((IProject)this.project, (IProgressMonitor)m, (String)"org.eclipse.gemoc.xdsmlframework.api");
            ManifestUtil.addToPluginManifest((IProject)this.project, (IProgressMonitor)m, (String)"org.eclipse.gemoc.trace.commons.model");
            _xblockexpression = ManifestUtil.setRequiredExecutionEnvironmentToPluginManifest((IProject)this.project, (IProgressMonitor)m, (String)"JavaSE-1.8");
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private void addExtensionPoint() {
        this.project = this.project;
        IFile pluginfile = this.project.getFile("plugin.xml");
        PluginXMLHelper.createEmptyTemplateFile((IFile)pluginfile, (boolean)false);
        PluginXMLHelper helper = new PluginXMLHelper();
        helper.loadDocument(pluginfile);
        Element extensionPoint = helper.getOrCreateExtensionPoint("org.eclipse.gemoc.gemoc_language_workbench.engine_addon");
        GenericEngineTraceAddonGenerator.updateDefinitionAttributeInExtensionPoint(extensionPoint, "class", String.valueOf(this.packageQN) + "." + this.className);
        GenericEngineTraceAddonGenerator.updateDefinitionAttributeInExtensionPoint(extensionPoint, "default", "false");
        GenericEngineTraceAddonGenerator.updateDefinitionAttributeInExtensionPoint(extensionPoint, "id", this.pluginName);
        GenericEngineTraceAddonGenerator.updateDefinitionAttributeInExtensionPoint(extensionPoint, "name", String.valueOf(this.tracedLanguageName) + " MultiDimensional Trace");
        GenericEngineTraceAddonGenerator.updateDefinitionAttributeInExtensionPoint(extensionPoint, "shortDescription", "MultiDimensional Trace support dedicated to " + this.tracedLanguageName + " language");
        GenericEngineTraceAddonGenerator.updateDefinitionAttributeInExtensionPoint(extensionPoint, "openViewIds", "org.eclipse.gemoc.addon.multidimensional.timeline.views.timeline.MultidimensionalTimeLineView");
        GenericEngineTraceAddonGenerator.updateDefinitionAttributeInExtensionPoint(extensionPoint, "addonGroupId", "Sequential.AddonGroup");
        helper.saveDocument(pluginfile);
    }

    private static Element updateDefinitionAttributeInExtensionPoint(Element extensionPoint, String atributeName, String value) {
        boolean _equals;
        Element result = null;
        String defName = "Addon";
        ElementFilter _elementFilter = new ElementFilter("Addon");
        List elements = extensionPoint.getContent((Filter)_elementFilter);
        int _size = elements.size();
        boolean bl = _equals = _size == 0;
        if (_equals) {
            Element _element;
            result = _element = new Element("Addon");
            extensionPoint.addContent((Content)result);
        } else {
            result = (Element)elements.get(0);
        }
        result.setAttribute(atributeName, value);
        return result;
    }

    private String generateAddonClassCode() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("package ");
        _builder.append(this.packageQN);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("import java.util.Map;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("import org.eclipse.emf.ecore.EObject;");
        _builder.newLine();
        _builder.append("import org.eclipse.emf.ecore.resource.Resource;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("import org.eclipse.gemoc.trace.commons.model.trace.State;");
        _builder.newLine();
        _builder.append("import org.eclipse.gemoc.trace.gemoc.api.IStateManager;");
        _builder.newLine();
        _builder.append("import org.eclipse.gemoc.trace.gemoc.api.IStepFactory;");
        _builder.newLine();
        _builder.append("import org.eclipse.gemoc.trace.commons.model.trace.TracedObject;");
        _builder.newLine();
        _builder.append("import org.eclipse.gemoc.trace.gemoc.api.ITraceConstructor;");
        _builder.newLine();
        _builder.append("import org.eclipse.gemoc.trace.gemoc.traceaddon.AbstractTraceAddon;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("public class ");
        _builder.append(this.className);
        _builder.append(" extends AbstractTraceAddon {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("private ");
        _builder.append(this.stepFactoryClassName, "\t");
        _builder.append(" factory = null;");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("@Override");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public ITraceConstructor constructTraceConstructor(Resource modelResource, Resource traceResource, Map<EObject, TracedObject<?>> exeToTraced) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return new ");
        _builder.append(this.traceConstructorClassName, "\t\t");
        _builder.append("(modelResource, traceResource, exeToTraced);");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("@Override");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public IStateManager<State<?, ?>> constructStateManager(Resource modelResource, Map<TracedObject<?>, EObject> tracedToExe) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return new ");
        _builder.append(this.stateManagerClassName, "\t\t");
        _builder.append("(modelResource, tracedToExe);");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("@Override");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public IStepFactory getFactory() {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if (factory == null)");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("factory = new ");
        _builder.append(this.stepFactoryClassName, "\t\t\t");
        _builder.append("();");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("return factory;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("@Override");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public boolean isAddonForTrace(EObject root) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return root instanceof ");
        String _javaFQN = this.getJavaFQN((EClassifier)this.traceability.getTraceMMExplorer().getSpecificTraceClass());
        _builder.append(_javaFQN, "\t\t");
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("}");
        return _builder.toString();
    }

    private Set<EClass> potentialCallerClasses(EClass stepCallerClass) {
        HashSet possibleCallerClasses = new HashSet();
        Iterables.addAll(possibleCallerClasses, (Iterable)Iterables.filter((Iterable)this.opsemanticsview.getExecutionMetamodel().getEClassifiers(), EClass.class));
        possibleCallerClasses.addAll(this.traceability.getAllMutableClasses());
        Functions.Function1 _function = c -> c.equals(stepCallerClass) || c.getEAllSuperTypes().contains((Object)stepCallerClass);
        Functions.Function1 _function_1 = it -> it.getName();
        Set filtered = IterableExtensions.toSet((Iterable)IterableExtensions.sortBy((Iterable)IterableExtensions.filter((Iterable)Iterables.filter(possibleCallerClasses, EClass.class), (Functions.Function1)_function), (Functions.Function1)_function_1));
        return filtered;
    }

    private String generateStepFactory() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("package ");
        _builder.append(this.packageQN);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("import java.util.List;");
        _builder.newLine();
        _builder.append("import org.eclipse.gemoc.trace.gemoc.api.IStepFactory;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("public class ");
        _builder.append(this.stepFactoryClassName);
        _builder.append(" implements IStepFactory {\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("@Override");
        _builder.newLine();
        _builder.append("public org.eclipse.gemoc.trace.commons.model.trace.Step<?> createStep(org.eclipse.gemoc.trace.commons.model.trace.MSE mse, List<Object> parameters, List<Object> result) {");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("org.eclipse.gemoc.trace.commons.model.trace.Step<?> step = null;");
        _builder.newLine();
        _builder.append("org.eclipse.emf.ecore.EClass ec = mse.getCaller().eClass();");
        _builder.newLine();
        _builder.append("String stepRule = org.eclipse.gemoc.trace.commons.EcoreCraftingUtil.getFQN(ec, \".\") + \".\"");
        _builder.newLine();
        _builder.append("\t\t\t\t\t\t");
        _builder.append("+ mse.getAction().getName();");
        _builder.newLine();
        _builder.newLine();
        Functions.Function1 _function = it -> GenericEngineTraceAddonGenerator.getBaseFQN(it);
        List _sortBy = IterableExtensions.sortBy((Iterable)this.opsemanticsview.getRules(), (Functions.Function1)_function);
        boolean _hasElements = false;
        for (Rule rule : _sortBy) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)"else", "\t");
            }
            _builder.newLine();
            _builder.append("\t");
            EClass stepCallerClass = rule.getContainingClass();
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            Set<EClass> filtered = this.potentialCallerClasses(stepCallerClass);
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.newLine();
            boolean _isEmpty = filtered.isEmpty();
            if (_isEmpty) {
                _builder.append("\t");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("if (stepRule.equalsIgnoreCase(\"");
                String _baseFQN = GenericEngineTraceAddonGenerator.getBaseFQN(rule);
                _builder.append(_baseFQN, "\t");
                _builder.append("\")) {");
                _builder.newLineIfNotEmpty();
            } else {
                _builder.append("\t");
                _builder.append("if (");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("mse.getAction().getName().equalsIgnoreCase(\"");
                String _name = rule.getOperation().getName();
                _builder.append(_name, "\t\t");
                _builder.append("\")");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("&& (");
                _builder.newLine();
                boolean _hasElements_1 = false;
                for (EClass possibleCallerClass : filtered) {
                    if (!_hasElements_1) {
                        _hasElements_1 = true;
                    } else {
                        _builder.appendImmediate((Object)" || ", "\t\t");
                    }
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("ec.getClassifierID()== ");
                    String _stringClassifierID = EcoreCraftingUtil.stringClassifierID((EClassifier)possibleCallerClass, this.genPackages);
                    _builder.append(_stringClassifierID, "\t\t");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append("\t");
                _builder.append("\t");
                _builder.append(")");
                _builder.newLine();
                _builder.append("\t");
                _builder.append(")");
                _builder.newLine();
                _builder.append("\t");
                _builder.newLine();
                _builder.append("\t");
                _builder.append(" ");
                _builder.append("{");
                _builder.newLine();
            }
            _builder.append("\t");
            _builder.append("step = ");
            String _stringCreate = EcoreCraftingUtil.stringCreate((EClass)this.traceability.getStepClassFromStepRule(rule));
            _builder.append(_stringCreate, "\t");
            _builder.append(";");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("} ");
            _builder.newLine();
            _builder.append("\t");
            _builder.newLine();
        }
        if (_hasElements) {
            _builder.append("else", "\t");
        }
        _builder.append("\t");
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("step = org.eclipse.gemoc.trace.commons.model.generictrace.GenerictraceFactory.eINSTANCE.createGenericSequentialStep();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("org.eclipse.gemoc.trace.commons.model.trace.MSEOccurrence mseocc = org.eclipse.gemoc.trace.commons.model.trace.TraceFactory.eINSTANCE.createMSEOccurrence();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("mseocc.setMse(mse);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("mseocc.getParameters().addAll(parameters);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("mseocc.getResult().addAll(result);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("step.setMseoccurrence(mseocc);");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return step;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder.toString();
    }

    @Pure
    public IProject getProject() {
        return this.project;
    }

    protected void setProject(IProject project) {
        this.project = project;
    }
}

