package org.eclipse.gemoc.ui.highlighting;

import com.google.common.base.Objects;
import java.util.ArrayList;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gemoc.dsl.Dsl;
import org.eclipse.gemoc.dsl.Entry;
import org.eclipse.gemoc.ui.highlighting.DslHighlightingConfiguration;
import org.eclipse.gemoc.xdsmlframework.api.extensions.metaprog.LanguageComponentHelper;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.ide.editor.syntaxcoloring.DefaultSemanticHighlightingCalculator;
import org.eclipse.xtext.ide.editor.syntaxcoloring.IHighlightedPositionAcceptor;
import org.eclipse.xtext.nodemodel.BidiTreeIterable;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@SuppressWarnings("all")
public class DslHighlightingCalculator extends DefaultSemanticHighlightingCalculator {
  @Override
  public void provideHighlightingFor(final XtextResource resource, final IHighlightedPositionAcceptor acceptor, final CancelIndicator cancelIndicator) {
    final INode root = resource.getParseResult().getRootNode();
    final LanguageComponentHelper languageHelper = new LanguageComponentHelper();
    EObject _semanticElement = root.getSemanticElement();
    Dsl dsl = ((Dsl) _semanticElement);
    String metaprog = null;
    ArrayList<IConfigurationElement> keys = new ArrayList<IConfigurationElement>();
    EList<Entry> _entries = dsl.getEntries();
    for (final Entry entry : _entries) {
      boolean _equals = "metaprog".equals(entry.getKey());
      if (_equals) {
        metaprog = entry.getValue();
        keys = languageHelper.getFullApproachKeys(metaprog);
      }
    }
    BidiTreeIterable<INode> _asTreeIterable = root.getAsTreeIterable();
    for (final INode node : _asTreeIterable) {
      {
        final EObject grammarElement = node.getGrammarElement();
        if ((grammarElement instanceof RuleCall)) {
          RuleCall rc = ((RuleCall) grammarElement);
          AbstractRule r = rc.getRule();
          final EObject c = ((RuleCall)grammarElement).eContainer();
          final EObject ccc = c.eContainer().eContainer();
          final EObject sem = node.getSemanticElement();
          boolean _equals_1 = r.getName().equals("WORD");
          if (_equals_1) {
            if ((c instanceof Assignment)) {
              String _feature = ((Assignment)c).getFeature();
              boolean _equals_2 = Objects.equal(_feature, "key");
              if (_equals_2) {
                if ((sem instanceof Entry)) {
                  boolean _isEmpty = keys.isEmpty();
                  boolean _not = (!_isEmpty);
                  if (_not) {
                    final Function1<IConfigurationElement, Boolean> _function = (IConfigurationElement e) -> {
                      return Boolean.valueOf((Objects.equal(e.getAttribute("name"), ((Entry)sem).getKey()) && e.getAttribute("optional").matches("false")));
                    };
                    boolean _isEmpty_1 = IterableExtensions.isEmpty(IterableExtensions.<IConfigurationElement>filter(keys, _function));
                    boolean _not_1 = (!_isEmpty_1);
                    if (_not_1) {
                      acceptor.addPosition(node.getOffset(), node.getLength(), 
                        DslHighlightingConfiguration.KEY_PLUGIN_ID);
                    } else {
                      final Function1<IConfigurationElement, Boolean> _function_1 = (IConfigurationElement e) -> {
                        return Boolean.valueOf((Objects.equal(e.getAttribute("name"), ((Entry)sem).getKey()) && e.getAttribute("optional").matches("true")));
                      };
                      boolean _isEmpty_2 = IterableExtensions.isEmpty(IterableExtensions.<IConfigurationElement>filter(keys, _function_1));
                      boolean _not_2 = (!_isEmpty_2);
                      if (_not_2) {
                        acceptor.addPosition(node.getOffset(), node.getLength(), 
                          DslHighlightingConfiguration.OPTIONAL_KEY_PLUGIN_ID);
                      } else {
                        acceptor.addPosition(node.getOffset(), node.getLength(), 
                          DslHighlightingConfiguration.KEY_ID);
                      }
                    }
                  } else {
                    acceptor.addPosition(node.getOffset(), node.getLength(), 
                      DslHighlightingConfiguration.KEY_ID);
                  }
                }
              }
            }
          } else {
            String _name = r.getName();
            boolean _equals_3 = Objects.equal(_name, "VALUE_WORD");
            if (_equals_3) {
              acceptor.addPosition(node.getOffset(), node.getLength(), DslHighlightingConfiguration.VALUE_ID);
            } else {
              String _name_1 = r.getName();
              boolean _equals_4 = Objects.equal(_name_1, "SEPARATOR");
              if (_equals_4) {
                if ((ccc instanceof ParserRule)) {
                  String _name_2 = ((ParserRule)ccc).getName();
                  boolean _notEquals = (!Objects.equal(_name_2, "VALUE_WORD"));
                  if (_notEquals) {
                    acceptor.addPosition(node.getOffset(), node.getLength(), 
                      DslHighlightingConfiguration.SEPARATOR_ID);
                  }
                }
              }
            }
          }
        } else {
          if ((grammarElement instanceof Keyword)) {
            String _value = ((Keyword)grammarElement).getValue();
            boolean _equals_5 = Objects.equal(_value, "\\");
            if (_equals_5) {
              acceptor.addPosition(node.getOffset(), node.getLength(), 
                DslHighlightingConfiguration.LINESEPARATOR_ID);
            }
          }
        }
      }
    }
  }
}
