/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.commons.eclipse.messagingsystem.ui.helper;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;

public class FileHelpers {
    private static String cleanIfNecessaryPath(String resourcePath) {
        String unifiedSepratorResourcePath = resourcePath.replaceAll("\\\\", "/").replaceAll(" ", "%20");
        if (!(unifiedSepratorResourcePath.startsWith("file:/") || unifiedSepratorResourcePath.startsWith("jar:") || unifiedSepratorResourcePath.startsWith("platform:"))) {
            unifiedSepratorResourcePath = unifiedSepratorResourcePath.startsWith("/") ? "file:" + unifiedSepratorResourcePath : "file:/" + unifiedSepratorResourcePath;
        }
        return unifiedSepratorResourcePath;
    }

    public static URL StringToURL(String url) throws MalformedURLException {
        return new URL(FileHelpers.cleanIfNecessaryPath(url));
    }

    public static URI StringToURI(String url) throws URISyntaxException {
        return new URI(FileHelpers.cleanIfNecessaryPath(url));
    }

    public static URL FileToURL(File file) throws MalformedURLException {
        return file.toURI().toURL();
    }

    public static String URLToStringWithoutFile(URL url) {
        return url.getFile();
    }

    public static void copyFile(File inputFile, File outputFile) throws IOException {
        int c;
        outputFile.getParentFile().mkdirs();
        FileReader in = new FileReader(inputFile);
        FileWriter out = new FileWriter(outputFile);
        while ((c = in.read()) != -1) {
            out.write(c);
        }
        in.close();
        out.close();
    }

    public static void copyDirectory(File inputFolder, File outputFolder) throws IOException {
        outputFolder.getParentFile().mkdirs();
        File[] fileArray = inputFolder.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File innerFile = fileArray[n2];
            if (innerFile.isDirectory()) {
                FileHelpers.copyDirectory(innerFile, new File(String.valueOf(outputFolder.getCanonicalPath()) + "/" + innerFile.getName()));
            }
            if (innerFile.isFile()) {
                FileHelpers.copyFile(innerFile, new File(String.valueOf(outputFolder.getCanonicalPath()) + "/" + innerFile.getName()));
            }
            ++n2;
        }
    }
}

