/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.addon.eventscheduling.timeline.views.timeline;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.gemoc.execution.concurrent.ccsljavaengine.eventscheduling.trace.EventSchedulingModelExecutionTracingAddon;
import org.eclipse.gemoc.executionframework.reflectivetrace.gemoc_execution_trace.Branch;
import org.eclipse.gemoc.executionframework.reflectivetrace.gemoc_execution_trace.Choice;
import org.eclipse.gemoc.executionframework.reflectivetrace.gemoc_execution_trace.ExecutionTraceModel;
import org.eclipse.gemoc.executionframework.reflectivetrace.gemoc_execution_trace.Gemoc_execution_traceFactory;
import org.eclipse.gemoc.executionframework.ui.utils.ViewUtils;
import org.eclipse.gemoc.timeline.view.AbstractTimelineProvider;
import org.eclipse.gemoc.trace.commons.model.helper.StepHelper;
import org.eclipse.gemoc.trace.commons.model.trace.MSE;
import org.eclipse.gemoc.trace.commons.model.trace.MSEOccurrence;
import org.eclipse.gemoc.trace.commons.model.trace.Step;
import org.eclipse.gemoc.xdsmlframework.api.core.EngineStatus;
import org.eclipse.gemoc.xdsmlframework.api.core.IDisposable;
import org.eclipse.gemoc.xdsmlframework.api.core.IExecutionEngine;
import org.eclipse.gemoc.xdsmlframework.api.engine_addon.IEngineAddon;

public class EventSchedulingTimelineProvider
extends AbstractTimelineProvider
implements IEngineAddon,
IDisposable {
    private IExecutionEngine<?> _engine;
    private EventSchedulingModelExecutionTracingAddon _tracingAddon;
    private int _numberOfChoices = 0;
    private int _numberOfSteps = 0;

    public EventSchedulingTimelineProvider(IExecutionEngine<?> engine) {
        this._engine = engine;
        this._engine.getExecutionContext().getExecutionPlatform().addEngineAddon((IEngineAddon)this);
    }

    private ExecutionTraceModel getExecutionTrace() {
        ExecutionTraceModel traceModel = null;
        if (this._engine.hasAddon(EventSchedulingModelExecutionTracingAddon.class)) {
            this._tracingAddon = (EventSchedulingModelExecutionTracingAddon)this._engine.getAddon(EventSchedulingModelExecutionTracingAddon.class);
            traceModel = this._tracingAddon.getExecutionTrace();
        } else {
            traceModel = Gemoc_execution_traceFactory.eINSTANCE.createExecutionTraceModel();
        }
        return traceModel;
    }

    private Branch getBranchAt(int branchIndex) {
        Branch result = null;
        if (this.getExecutionTrace() != null && this.getExecutionTrace().getBranches().size() >= branchIndex) {
            result = (Branch)this.getExecutionTrace().getBranches().get(branchIndex);
        }
        return result;
    }

    public Choice getChoiceAt(int branchIndex, int executionStepIndex) {
        int choiceIndex;
        Choice result = null;
        Branch branch = this.getBranchAt(branchIndex);
        if (branch != null && branch.getStartIndex() + branch.getChoices().size() >= executionStepIndex && (choiceIndex = executionStepIndex - branch.getStartIndex()) >= 0) {
            result = (Choice)branch.getChoices().get(choiceIndex);
        }
        return result;
    }

    public int getNumberOfBranches() {
        int result = 0;
        if (this.getExecutionTrace() != null) {
            result = this.getExecutionTrace().getBranches().size();
        }
        return result;
    }

    public int getStart(int branchIndex) {
        int result = 0;
        Branch branch = this.getBranchAt(branchIndex);
        if (branch != null) {
            result = branch.getStartIndex();
        }
        return result;
    }

    public int getEnd(int branchIndex) {
        int result = 0;
        Branch branch = this.getBranchAt(branchIndex);
        if (branch != null) {
            result = branch.getStartIndex() + branch.getChoices().size();
        }
        return result;
    }

    public int getNumberOfPossibleStepsAt(int branchIndex, int executionStepIndex) {
        int numberOfPossibleSteps = 0;
        Choice choice = this.getChoiceAt(branchIndex, executionStepIndex);
        if (choice != null) {
            numberOfPossibleSteps = choice.getPossibleLogicalSteps().size();
        }
        return numberOfPossibleSteps;
    }

    public String getTextAt(int branchIndex) {
        return "Current execution";
    }

    public String getTextAt(int branchIndex, int index) {
        return String.valueOf(index);
    }

    public Object getAt(int branchIndex, int executionStepIndex, int logicalStepIndex) {
        Object result = null;
        Choice choice = this.getChoiceAt(branchIndex, executionStepIndex);
        if (choice != null && choice.getPossibleLogicalSteps().size() >= logicalStepIndex) {
            result = choice.getPossibleLogicalSteps().get(logicalStepIndex);
        }
        return result;
    }

    public Object getAt(int branchIndex, int executionStepIndex) {
        Choice choice = this.getChoiceAt(branchIndex, executionStepIndex);
        return choice;
    }

    public String getTextAt(int branchIndex, int choiceIndex, int logicalStepIndex) {
        StringBuilder builder = new StringBuilder();
        Step ls = (Step)this.getAt(branchIndex, choiceIndex, logicalStepIndex);
        builder.append(StepHelper.getStepName((Step)ls));
        builder.append(System.getProperty("line.separator"));
        for (MSEOccurrence mseOccurrence : StepHelper.collectAllMSEOccurrences((Step)ls)) {
            this.appendToolTipTextToBuilder(builder, mseOccurrence);
            builder.append(System.getProperty("line.separator"));
        }
        return builder.toString();
    }

    private void appendToolTipTextToBuilder(StringBuilder builder, MSEOccurrence mseOccurrence) {
        String s = "";
        if (mseOccurrence.getMse() != null) {
            s = String.format("%-50s%s", mseOccurrence.getMse().getName(), ViewUtils.eventToString((MSE)mseOccurrence.getMse()));
        }
        builder.append(s);
    }

    public int[][] getFollowings(int branchIndex, int executionStepIndex, int logicalStepIndex) {
        Object res = new int[][]{{branchIndex, -1}};
        Choice choice = this.getChoiceAt(branchIndex, executionStepIndex);
        if (choice != null && !choice.getNextChoices().isEmpty()) {
            res = new int[choice.getNextChoices().size()][1];
            int i = 0;
            while (i < choice.getNextChoices().size()) {
                Choice next = (Choice)choice.getNextChoices().get(i);
                Branch nextBranch = next.getBranch();
                int nextBranchNumber = this.getExecutionTrace().getBranches().indexOf((Object)nextBranch);
                if (next.getChosenLogicalStep() != null) {
                    int nextLogicalStepindex = next.getPossibleLogicalSteps().indexOf((Object)next.getChosenLogicalStep());
                    int[] content = new int[]{nextBranchNumber, nextLogicalStepindex};
                    res[i] = content;
                } else {
                    int[] content = new int[]{nextBranchNumber, -1};
                    res[i] = content;
                }
                ++i;
            }
        }
        return res;
    }

    public int[][] getPrecedings(int branchIndex, int executionStepIndex, int logicalStepIndex) {
        int[][] res = new int[][]{{branchIndex, -1}};
        Choice choice = this.getChoiceAt(branchIndex, executionStepIndex);
        if (choice != null && choice.getPreviousChoice() != null) {
            Choice previous = choice.getPreviousChoice();
            Branch previousBranch = previous.getBranch();
            int previousBranchNumber = this.getExecutionTrace().getBranches().indexOf((Object)previousBranch);
            if (previous.getChosenLogicalStep() != null) {
                int previousLogicalStepindex = previous.getPossibleLogicalSteps().indexOf((Object)previous.getChosenLogicalStep());
                int[] content = new int[]{previousBranchNumber, previousLogicalStepindex};
                res[0] = content;
            } else {
                int[] content = new int[]{previousBranchNumber, -1};
                res[0] = content;
            }
        }
        return res;
    }

    private void update(IExecutionEngine<?> engine) {
        Branch branch;
        if (engine == this._engine && this.getExecutionTrace() != null && this._tracingAddon != null && this._tracingAddon.getCurrentBranch() != null && (branch = this._tracingAddon.getCurrentBranch()).getChoices().size() > 0) {
            int branchIndex = this.getExecutionTrace().getBranches().indexOf((Object)branch);
            boolean mustNotify = false;
            Choice gemocChoice = (Choice)branch.getChoices().get(branch.getChoices().size() - 1);
            if (gemocChoice.getPossibleLogicalSteps().size() != this._numberOfSteps) {
                this._numberOfSteps = gemocChoice.getPossibleLogicalSteps().size();
                mustNotify = true;
            }
            if (branch.getChoices().size() != this._numberOfChoices) {
                this._numberOfChoices = branch.getChoices().size();
                mustNotify = true;
            }
            if (mustNotify = true) {
                int stepIndex = branch.getStartIndex() + branch.getChoices().size();
                boolean isSelected = gemocChoice.getChosenLogicalStep() != null;
                this.notifyIsSelectedChanged(branchIndex, stepIndex, gemocChoice.getPossibleLogicalSteps().indexOf((Object)gemocChoice.getChosenLogicalStep()), isSelected);
                this.notifyEndChanged(branchIndex, stepIndex);
                this.notifyStartChanged(branchIndex, branch.getStartIndex());
            }
        }
    }

    public int getSelectedPossibleStep(int branchIndex, int executionStepIndex) {
        int result = -1;
        Branch branch = this.getBranchAt(branchIndex);
        if (branch != null) {
            Choice choice;
            int choiceIndex = executionStepIndex - branch.getStartIndex();
            if (branch.getChoices().size() >= choiceIndex && (choice = (Choice)branch.getChoices().get(choiceIndex)).getSelectedNextChoice() != null) {
                result = choice.getPossibleLogicalSteps().indexOf((Object)choice.getChosenLogicalStep());
            }
        }
        return result;
    }

    public void dispose() {
        if (this._engine != null) {
            this._engine.getExecutionContext().getExecutionPlatform().removeEngineAddon((IEngineAddon)this);
        }
    }

    public void engineAboutToStart(IExecutionEngine<?> engine) {
    }

    public void engineStarted(IExecutionEngine<?> executionEngine) {
    }

    public void aboutToExecuteStep(IExecutionEngine<?> executionEngine, Step<?> logicalStepToApply) {
        this.update(executionEngine);
    }

    public void engineAboutToStop(IExecutionEngine<?> engine) {
    }

    public void engineStopped(IExecutionEngine<?> engine) {
    }

    public void aboutToSelectStep(IExecutionEngine<?> engine, Collection<Step<?>> logicalSteps) {
        this.update(engine);
    }

    public void stepSelected(IExecutionEngine<?> engine, Step<?> selectedLogicalStep) {
        this.update(engine);
    }

    public void stepExecuted(IExecutionEngine<?> engine, Step<?> step) {
    }

    public void engineStatusChanged(IExecutionEngine<?> engine, EngineStatus.RunStatus newStatus) {
    }

    protected void setSelectedStep(Step<?> ls) {
    }

    public void proposedStepsChanged(IExecutionEngine<?> engine, Collection<Step<?>> logicalSteps) {
        this.update(engine);
    }

    public void engineAboutToDispose(IExecutionEngine<?> engine) {
    }

    public List<String> validate(List<IEngineAddon> otherAddons) {
        return new ArrayList<String>();
    }

    public int getCurrentBranch() {
        Branch currentBranch = this._tracingAddon.getCurrentBranch();
        if (currentBranch.getChoices().indexOf((Object)this._tracingAddon.getCurrentChoice()) == 0) {
            return this.getExecutionTrace().getBranches().indexOf((Object)((Choice)this._tracingAddon.getCurrentBranch().getChoices().get(0)).getPreviousChoice().getBranch());
        }
        return this.getExecutionTrace().getBranches().indexOf((Object)this._tracingAddon.getCurrentBranch());
    }

    public int getCurrentChoice() {
        Branch branch = this._tracingAddon.getCurrentBranch();
        return branch.getChoices().indexOf((Object)this._tracingAddon.getCurrentChoice()) + branch.getStartIndex() - 1;
    }

    public int getCurrentPossibleStep() {
        Choice choice = this._tracingAddon.getCurrentChoice();
        Choice previous = choice.getPreviousChoice();
        if (previous != null) {
            return previous.getPossibleLogicalSteps().indexOf((Object)previous.getChosenLogicalStep());
        }
        return -1;
    }
}

