/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.ui.contentassist;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.eclipse.acceleo.query.ast.Expression;
import org.eclipse.acceleo.query.runtime.ICompletionProposal;
import org.eclipse.acceleo.query.runtime.ICompletionResult;
import org.eclipse.acceleo.query.runtime.IProposalFilter;
import org.eclipse.acceleo.query.runtime.IQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.impl.BasicFilter;
import org.eclipse.acceleo.query.runtime.impl.QueryCompletionEngine;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.emf.ecoretools.ale.ALEInterpreter;
import org.eclipse.emf.ecoretools.ale.core.parser.DslBuilder;
import org.eclipse.emf.ecoretools.ale.core.parser.visitor.ParseResult;
import org.eclipse.emf.ecoretools.ale.core.validation.ALEValidator;
import org.eclipse.emf.ecoretools.ale.implementation.Block;
import org.eclipse.emf.ecoretools.ale.implementation.ModelUnit;
import org.eclipse.emf.ecoretools.ui.contentassist.AbstractAleProposalProvider;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.impl.AbstractNode;
import org.eclipse.xtext.nodemodel.impl.CompositeNode;
import org.eclipse.xtext.nodemodel.impl.CompositeNodeWithSemanticElement;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalAcceptor;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class AleProposalProvider
extends AbstractAleProposalProvider {
    @Override
    public void completeExpression_Feature(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        String candidate = this.getOffsetPrefix(context);
        this.addProposals(candidate, model, context, acceptor);
    }

    @Override
    public void completeExpression_Name(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        String candidate = this.getOffsetPrefix(context);
        this.addProposals(candidate, model, context, acceptor);
    }

    @Override
    public void complete_expression(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        String candidate = this.getOffsetPrefix(context);
        this.addProposals(candidate, model, context, acceptor);
    }

    private void addProposals(String expression, EObject model, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _isEmpty_1;
        boolean _isEmpty = expression.isEmpty();
        if (_isEmpty) {
            return;
        }
        IFile aleFile = WorkspaceSynchronizer.getFile((Resource)model.eResource());
        IPath dslPath = aleFile.getFullPath().removeFileExtension().addFileExtension("ecore");
        ResourceSetImpl rs = new ResourceSetImpl();
        Map _extensionToFactoryMap = rs.getResourceFactoryRegistry().getExtensionToFactoryMap();
        XMIResourceFactoryImpl _xMIResourceFactoryImpl = new XMIResourceFactoryImpl();
        _extensionToFactoryMap.put("*", _xMIResourceFactoryImpl);
        List ecorePkgs = DslBuilder.load((String)dslPath.toString(), (ResourceSet)rs);
        byte[] _bytes = context.getDocument().get().getBytes(StandardCharsets.UTF_8);
        ByteArrayInputStream stream = new ByteArrayInputStream(_bytes);
        ALEInterpreter interpreter = new ALEInterpreter();
        IQueryEnvironment _queryEnvironment = interpreter.getQueryEnvironment();
        List parsedSemantics = new DslBuilder(_queryEnvironment).parse(ecorePkgs, Arrays.asList(stream));
        Functions.Function1 _function = it -> (ModelUnit)it.getRoot();
        Functions.Function1 _function_1 = it -> it.getServices();
        List services = IterableExtensions.toList((Iterable)Iterables.concat((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filterNull((Iterable)ListExtensions.map((List)parsedSemantics, (Functions.Function1)_function)), (Functions.Function1)_function_1)));
        interpreter.registerServices(services);
        Map variableTypes = CollectionLiterals.newHashMap();
        int _offset = context.getOffset();
        int _minus = _offset - 1;
        Expression contextExp = this.getExpression(parsedSemantics, _minus);
        IQueryEnvironment _queryEnvironment_1 = interpreter.getQueryEnvironment();
        ALEValidator validator = new ALEValidator(_queryEnvironment_1);
        if (contextExp != null) {
            variableTypes = validator.getValidationContext(contextExp, parsedSemantics);
        }
        if (_isEmpty_1 = variableTypes.entrySet().isEmpty()) {
            Block block = this.getBlock(parsedSemantics, context.getOffset());
            variableTypes = validator.getValidationContext(block, parsedSemantics);
        }
        IQueryEnvironment _queryEnvironment_2 = interpreter.getQueryEnvironment();
        QueryCompletionEngine engine = new QueryCompletionEngine((IReadOnlyQueryEnvironment)_queryEnvironment_2);
        ICompletionResult completionResult = engine.getCompletion(expression, expression.length(), variableTypes);
        BasicFilter _basicFilter = new BasicFilter(completionResult);
        List proposals = completionResult.getProposals((IProposalFilter)_basicFilter);
        Consumer<ICompletionProposal> _function_2 = proposal -> {
            String _proposal = proposal.getProposal();
            StyledString styledText = new StyledString(_proposal);
            styledText.setStyle(0, proposal.getProposal().length(), StyledString.QUALIFIER_STYLER);
            String _proposal_1 = proposal.getProposal();
            int _defaultPriority = this.getPriorityHelper().getDefaultPriority();
            int _plus = _defaultPriority + 1;
            acceptor.accept((org.eclipse.jface.text.contentassist.ICompletionProposal)this.doCreateProposal(_proposal_1, styledText, null, _plus, context));
        };
        proposals.forEach(_function_2);
    }

    private org.eclipse.emf.ecoretools.ale.Expression rootExpression(EObject element) {
        org.eclipse.emf.ecoretools.ale.Expression res = null;
        EObject current = element;
        while (current != null) {
            if (current instanceof org.eclipse.emf.ecoretools.ale.Expression) {
                res = (org.eclipse.emf.ecoretools.ale.Expression)current;
            }
            current = current.eContainer();
        }
        return res;
    }

    private Expression getExpression(List<ParseResult<ModelUnit>> parsedSemantics, int offset) {
        Functions.Function1 _function;
        ParseResult unit;
        Iterable allExps;
        Expression candidate;
        boolean _not;
        Expression res = null;
        int start = 0;
        int end = 0;
        boolean _isEmpty = parsedSemantics.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not && (candidate = (Expression)IterableExtensions.findFirst((Iterable)(allExps = Iterables.filter((unit = (ParseResult)IterableExtensions.head(parsedSemantics)).getStartPositions().keySet(), Expression.class)), (Functions.Function1)(_function = exp -> (Integer)unit.getStartPositions().get(exp) <= offset && (Integer)unit.getEndPositions().get(exp) >= offset))) != null) {
            res = candidate;
            start = (Integer)unit.getStartPositions().get(candidate);
            end = (Integer)unit.getEndPositions().get(candidate);
            while (res.eContainer() instanceof Expression) {
                EObject _eContainer = res.eContainer();
                res = (Expression)_eContainer;
            }
        }
        return res;
    }

    private Block getBlock(List<ParseResult<ModelUnit>> parsedSemantics, int offset) {
        Functions.Function1 _function;
        ParseResult unit;
        Iterable allExps;
        Block candidate;
        boolean _not;
        Block res = null;
        int start = 0;
        int end = 0;
        boolean _isEmpty = parsedSemantics.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not && (candidate = (Block)IterableExtensions.findFirst((Iterable)(allExps = Iterables.filter((unit = (ParseResult)IterableExtensions.head(parsedSemantics)).getStartPositions().keySet(), Block.class)), (Functions.Function1)(_function = block -> (Integer)unit.getStartPositions().get(block) <= offset && (Integer)unit.getEndPositions().get(block) >= offset))) != null) {
            res = candidate;
            start = (Integer)unit.getStartPositions().get(candidate);
            end = (Integer)unit.getEndPositions().get(candidate);
            Iterable _drop = IterableExtensions.drop((Iterable)allExps, (int)1);
            for (Block block2 : _drop) {
                Integer _get_1;
                boolean _lessEqualsThan_1;
                boolean _lessEqualsThan;
                boolean _and = false;
                Integer _get = (Integer)unit.getStartPositions().get(block2);
                boolean bl2 = _lessEqualsThan = start <= _get;
                _and = !_lessEqualsThan ? false : (_lessEqualsThan_1 = (_get_1 = (Integer)unit.getEndPositions().get(block2)) <= end);
                start = (Integer)unit.getStartPositions().get(block2);
                end = (Integer)unit.getEndPositions().get(block2);
            }
        }
        return res;
    }

    private CompositeNode getBlockNode(INode node) {
        String debugDump = NodeModelUtils.compactDump((INode)node.getRootNode(), (boolean)true);
        INode current = node;
        while (!Objects.equal((Object)current, null)) {
            EObject _semanticElement;
            if (current instanceof CompositeNodeWithSemanticElement && (_semanticElement = ((CompositeNodeWithSemanticElement)current).getSemanticElement()) instanceof org.eclipse.emf.ecoretools.ale.Block) {
                return (CompositeNode)current;
            }
            current = current.getParent();
        }
        return null;
    }

    private AbstractNode findStatementNode(INode node, int offset) {
        boolean _notEquals;
        CompositeNode block = this.getBlockNode(node);
        boolean bl = _notEquals = !Objects.equal((Object)block, null);
        if (_notEquals) {
            Functions.Function1 _function = child -> child.getTextRegion().contains(offset);
            AbstractNode candidate = (AbstractNode)IterableExtensions.findFirst((Iterable)block.basicGetChildren(), (Functions.Function1)_function);
            return candidate;
        }
        return null;
    }

    private int findStart(String text, int offset) {
        int openIndex;
        int i = offset;
        while (i > 0) {
            String frame = text.substring(i - 1, i + 1);
            if (Objects.equal((Object)frame, (Object)":=") || Objects.equal((Object)frame, (Object)"+=") || Objects.equal((Object)frame, (Object)"-=") || Objects.equal((Object)frame, (Object)"in")) {
                if (i == offset) {
                    return offset;
                }
                return i + 1;
            }
            --i;
        }
        int whileIndex = text.indexOf("while");
        if (whileIndex != -1 && (openIndex = text.indexOf("(", whileIndex)) != -1) {
            return openIndex;
        }
        int ifIndex = text.indexOf("if");
        if (ifIndex != -1) {
            int openIndex_1 = text.indexOf("(", ifIndex);
            int thenIndex = text.indexOf("then", ifIndex);
            if (openIndex_1 != -1 && (thenIndex == -1 || openIndex_1 < thenIndex)) {
                return openIndex_1;
            }
        }
        return 0;
    }

    private String getOffsetPrefix(ContentAssistContext context) {
        try {
            INode _currentNode = context.getCurrentNode();
            int _offset = context.getOffset();
            int _minus = _offset - 1;
            AbstractNode stmtNode = this.findStatementNode(_currentNode, _minus);
            if (stmtNode != null) {
                String stmtText = context.getDocument().get(stmtNode.getOffset(), stmtNode.getLength());
                int _offset_1 = context.getOffset();
                int _minus_1 = _offset_1 - 1;
                int _offset_2 = stmtNode.getOffset();
                int _minus_2 = _minus_1 - _offset_2;
                int startIndex = this.findStart(stmtText, _minus_2);
                int _offset_3 = stmtNode.getOffset();
                int startOffset = _offset_3 + startIndex;
                IXtextDocument _document = context.getDocument();
                int _offset_4 = context.getOffset();
                int _minus_3 = _offset_4 - startOffset;
                return _document.get(startOffset, _minus_3);
            }
            return "";
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }
}

