/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import org.eclipse.elk.alg.layered.DotDebugUtil;
import org.eclipse.elk.alg.layered.JsonDebugUtil;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.p4nodes.LinearSegmentsNodePlacer;
import org.eclipse.elk.alg.layered.p5edges.OrthogonalRoutingGenerator;
import org.eclipse.elk.core.util.ElkUtil;

public final class DebugUtil {
    private DebugUtil() {
    }

    public static void writeDebugGraph(LGraph lgraph, int slotIndex, String name) {
        DotDebugUtil.writeDebugGraph(lgraph, slotIndex, name);
        JsonDebugUtil.writeDebugGraph(lgraph, slotIndex, name);
    }

    public static void writeDebugGraph(LGraph layeredGraph, List<LinearSegmentsNodePlacer.LinearSegment> segmentList, List<List<LinearSegmentsNodePlacer.LinearSegment>> outgoingList) {
        DotDebugUtil.writeDebugGraph(layeredGraph, segmentList, outgoingList);
        JsonDebugUtil.writeDebugGraph(layeredGraph, segmentList, outgoingList);
    }

    public static void writeDebugGraph(LGraph layeredGraph, int layerIndex, List<OrthogonalRoutingGenerator.HyperNode> hypernodes, String debugPrefix, String label) {
        DotDebugUtil.writeDebugGraph(layeredGraph, layerIndex, hypernodes, debugPrefix, label);
        JsonDebugUtil.writeDebugGraph(layeredGraph, layerIndex, hypernodes, debugPrefix, label);
    }

    static Writer createWriter(LGraph layeredGraph, String extension) throws IOException {
        String path = ElkUtil.debugFolderPath((String)"layered");
        new File(path).mkdirs();
        String debugFileName = String.valueOf(DebugUtil.getDebugOutputFileBaseName(layeredGraph)) + "linseg-dep" + extension;
        return new FileWriter(new File(String.valueOf(path) + debugFileName));
    }

    static Writer createWriter(LGraph graph, int slotIndex, String name, String extension) throws IOException {
        String path = ElkUtil.debugFolderPath((String)"layered");
        new File(path).mkdirs();
        String debugFileName = String.valueOf(DebugUtil.getDebugOutputFileBaseName(graph)) + "fulldebug-slot" + String.format("%1$02d", slotIndex) + "-" + name + extension;
        return new FileWriter(new File(String.valueOf(path) + debugFileName));
    }

    static Writer createWriter(LGraph layeredGraph, int layerIndex, String debugPrefix, String label, String extension) throws IOException {
        String path = ElkUtil.debugFolderPath((String)"layered");
        new File(path).mkdirs();
        String debugFileName = String.valueOf(DebugUtil.getDebugOutputFileBaseName(layeredGraph)) + debugPrefix + "-l" + layerIndex + "-" + label + extension;
        return new FileWriter(new File(String.valueOf(path) + debugFileName));
    }

    static String getDebugOutputFileBaseName(LGraph graph) {
        return String.valueOf(Integer.toString(graph.hashCode() & 0xFFFF)) + "-";
    }
}

