/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.contribution.visualiser.simpleImpl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.contribution.visualiser.core.PaletteManager;
import org.eclipse.contribution.visualiser.core.Stripe;
import org.eclipse.contribution.visualiser.interfaces.IGroup;
import org.eclipse.contribution.visualiser.interfaces.IMarkupKind;
import org.eclipse.contribution.visualiser.interfaces.IMarkupProvider;
import org.eclipse.contribution.visualiser.interfaces.IMember;
import org.eclipse.contribution.visualiser.utils.MarkupUtils;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class SimpleMarkupProvider
implements IMarkupProvider {
    private Map colourMemory = new HashMap();
    private Map availableColours = new HashMap();
    private Map allocatedColours = new HashMap();
    private Hashtable markups = null;
    private SortedSet markupKinds;

    public void initialise() {
    }

    public List getMemberMarkups(IMember member) {
        Object o;
        if (member != null && this.markups != null && (o = this.markups.get(member.getFullname())) instanceof List) {
            return (List)this.markups.get(member.getFullname());
        }
        return null;
    }

    public void addMarkup(String membername, Stripe s) {
        ArrayList<Stripe> stripes;
        if (this.markups == null) {
            this.markups = new Hashtable();
        }
        if ((stripes = (ArrayList<Stripe>)this.markups.get(membername)) == null) {
            stripes = new ArrayList<Stripe>();
            stripes.add(s);
            this.markups.put(membername, stripes);
        } else {
            stripes.add(s);
        }
    }

    public void addMarkupKind(IMarkupKind kind) {
        this.markupKinds.add(kind);
    }

    public void processMarkups() {
        Enumeration memkeys = this.markups.keys();
        while (memkeys.hasMoreElements()) {
            String memberID = (String)memkeys.nextElement();
            List unprocessedListOfStripes = (List)this.markups.get(memberID);
            MarkupUtils.processStripes(unprocessedListOfStripes);
        }
    }

    public List getGroupMarkups(IGroup group) {
        ArrayList<Stripe> stripes = new ArrayList<Stripe>();
        List kids = group.getMembers();
        int accumulatedOffset = 0;
        Iterator iter = kids.iterator();
        while (iter.hasNext()) {
            IMember element = (IMember)iter.next();
            List l = this.getMemberMarkups(element);
            if (l != null) {
                Iterator iterator = l.iterator();
                while (iterator.hasNext()) {
                    Stripe elem = (Stripe)iterator.next();
                    stripes.add(new Stripe(elem.getKinds(), elem.getOffset() + accumulatedOffset, elem.getDepth()));
                }
            }
            accumulatedOffset += element.getSize().intValue();
        }
        return stripes;
    }

    public SortedSet getAllMarkupKinds() {
        if (this.markups == null) {
            return null;
        }
        if (this.markupKinds != null) {
            return this.markupKinds;
        }
        this.markupKinds = new TreeSet();
        Enumeration stripeLists = this.markups.elements();
        while (stripeLists.hasMoreElements()) {
            List stripelist = (List)stripeLists.nextElement();
            Iterator iter = stripelist.iterator();
            while (iter.hasNext()) {
                Stripe element = (Stripe)iter.next();
                this.markupKinds.addAll(element.getKinds());
            }
        }
        return this.markupKinds;
    }

    public Color getColorFor(IMarkupKind kind) {
        Color stripeColour = null;
        String p = "not unique";
        String key = String.valueOf(p) + ":" + kind.getFullName();
        if (this.colourMemory.containsKey(key)) {
            stripeColour = (Color)this.colourMemory.get(key);
        } else {
            stripeColour = this.getNextColourFor(p);
            this.colourMemory.put(key, stripeColour);
        }
        return stripeColour;
    }

    public void setColorFor(IMarkupKind kind, Color color) {
        this.colourMemory.put("not unique:" + kind.getName(), color);
    }

    protected Color getNextColourFor(String p) {
        Color c;
        RGB v;
        List colours;
        if (!this.availableColours.containsKey(p.toString())) {
            RGB[] rgb = PaletteManager.getCurrentPalette().getPalette().getRGBValues();
            ArrayList<RGB> colourList = new ArrayList<RGB>(Arrays.asList(rgb));
            this.availableColours.put(p.toString(), colourList);
        }
        if (!(colours = (List)this.availableColours.get(p.toString())).isEmpty()) {
            v = (RGB)colours.get(0);
            colours.remove(0);
        } else {
            v = PaletteManager.getCurrentPalette().getPalette().getRandomRGBValue();
        }
        Object obj = this.allocatedColours.get(v);
        if (obj != null && obj instanceof Color) {
            c = (Color)obj;
        } else {
            c = new Color((Device)Display.getDefault(), v);
            this.allocatedColours.put(v, c);
        }
        return c;
    }

    public void resetMarkupsAndKinds() {
        this.markups = new Hashtable();
        this.markupKinds = new TreeSet();
    }

    public void resetColours() {
        this.availableColours = new HashMap();
        this.colourMemory = new HashMap();
    }

    private void disposeColors() {
        Iterator iter = this.allocatedColours.keySet().iterator();
        while (iter.hasNext()) {
            Color c = (Color)this.allocatedColours.get(iter.next());
            c.dispose();
        }
        this.allocatedColours = new HashMap();
    }

    public boolean processMouseclick(IMember member, Stripe stripe, int buttonClicked) {
        return true;
    }

    public void activate() {
    }

    public void deactivate() {
        this.resetColours();
        this.disposeColors();
    }
}

