/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver;

public enum RuntimeVersion {
    V1_2("1.2"),
    V1_5("1.5"),
    V1_6_10("1.6.10"),
    V1_9("1.9");

    private String[] aliases = null;

    private RuntimeVersion(String ... aliases) {
        this.aliases = aliases;
    }

    public static RuntimeVersion getVersionFor(String version) {
        RuntimeVersion[] runtimeVersionArray = RuntimeVersion.values();
        int n = runtimeVersionArray.length;
        int n2 = 0;
        while (n2 < n) {
            RuntimeVersion candidateVersion = runtimeVersionArray[n2];
            if (candidateVersion.name().equals(version)) {
                return candidateVersion;
            }
            if (candidateVersion.aliases != null) {
                String[] stringArray = candidateVersion.aliases;
                int n3 = candidateVersion.aliases.length;
                int n4 = 0;
                while (n4 < n3) {
                    String alias = stringArray[n4];
                    if (alias.equals(version)) {
                        return candidateVersion;
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return null;
    }

    public boolean isThisVersionOrLater(RuntimeVersion version) {
        return this.compareTo(version) >= 0;
    }
}

