/*
 * Decompiled with CFR 0.152.
 */
package fr.kairos.timesquare.ccsl.simple;

import fr.kairos.timesquare.ccsl.IDefinition;
import fr.kairos.timesquare.ccsl.IRelation;
import fr.kairos.timesquare.ccsl.ISpecification;
import java.util.ArrayList;

public class Specification
implements ISpecification {
    private String name;
    private ArrayList<String> clocks = new ArrayList();
    private ArrayList<IDefinition> definitions = new ArrayList();
    private ArrayList<IRelation> relations = new ArrayList();

    public Specification(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void addClock(String name) {
        this.clocks.add(name);
    }

    public int getClockNumber() {
        return this.clocks.size();
    }

    @Override
    public void add(IDefinition definition) {
        this.definitions.add(definition);
    }

    @Override
    public void add(IRelation relation) {
        this.relations.add(relation);
    }

    @Override
    public boolean isConstraintSupported(String name) {
        return true;
    }

    public void visit(ISpecification spec) {
        for (String clock : this.clocks) {
            spec.addClock(clock);
        }
        for (IDefinition def : this.definitions) {
            spec.add(def);
        }
        for (IRelation rel : this.relations) {
            spec.add(rel);
        }
    }
}

