/*
 * Decompiled with CFR 0.152.
 */
package fr.kairos.timesquare.ccsl.graph;

import fr.kairos.timesquare.ccsl.ISimpleSpecification;
import fr.kairos.timesquare.ccsl.graph.DigraphBuilder;

public final class BuildCausalityGraph
implements ISimpleSpecification {
    private DigraphBuilder builder;
    private boolean showDerived = false;

    public BuildCausalityGraph(boolean showDerived) {
        this(showDerived, new DigraphBuilder());
    }

    public BuildCausalityGraph(boolean showDerived, DigraphBuilder builder) {
        this.builder = builder;
        this.showDerived = showDerived;
        this.builder.setParam("causality");
    }

    private void addArc(String tail, String head) {
        this.builder.addArc(tail, head);
    }

    public DigraphBuilder getBuilder() {
        return this.builder;
    }

    @Override
    public void addClock(String name) {
    }

    @Override
    public void subclock(String left, String right) {
        if (left.equals(right)) {
            return;
        }
        if (this.showDerived) {
            this.addArc(right, left);
        }
    }

    @Override
    public void exclusion(String left, String right) {
    }

    @Override
    public void precedence(String left, String right) {
        this.addArc(left, right);
    }

    @Override
    public void precedence(String left, String right, int min, int max) {
        this.addArc(left, right);
    }

    @Override
    public void causality(String left, String right) {
        if (left.equals(right)) {
            return;
        }
        this.addArc(left, right);
    }

    @Override
    public void causality(String left, String right, int min, int max) {
        if (left.equals(right)) {
            return;
        }
        this.addArc(left, right);
    }

    @Override
    public void inf(String defClock, String ... clocks) {
        String[] stringArray = clocks;
        int n = clocks.length;
        int n2 = 0;
        while (n2 < n) {
            String c = stringArray[n2];
            this.causality(defClock, c);
            ++n2;
        }
    }

    @Override
    public void sup(String defClock, String ... clocks) {
        String[] stringArray = clocks;
        int n = clocks.length;
        int n2 = 0;
        while (n2 < n) {
            String c = stringArray[n2];
            this.causality(c, defClock);
            ++n2;
        }
    }

    @Override
    public void union(String defClock, String ... clocks) {
        if (!this.showDerived) {
            return;
        }
        String[] stringArray = clocks;
        int n = clocks.length;
        int n2 = 0;
        while (n2 < n) {
            String c = stringArray[n2];
            this.addArc(defClock, c);
            ++n2;
        }
    }

    @Override
    public void intersection(String defClock, String ... clocks) {
        if (!this.showDerived) {
            return;
        }
        String[] stringArray = clocks;
        int n = clocks.length;
        int n2 = 0;
        while (n2 < n) {
            String c = stringArray[n2];
            this.addArc(c, defClock);
            ++n2;
        }
    }

    @Override
    public void minus(String defClock, String ... clocks) {
        if (!this.showDerived) {
            return;
        }
        this.addArc(clocks[0], defClock);
    }

    @Override
    public void periodic(String defClock, String ref, int period, int from, int upto) {
        if (!this.showDerived) {
            return;
        }
        this.addArc(ref, defClock);
    }

    @Override
    public void delayFor(String defClock, String ref, int from, int upTo, String base) {
        if (!this.showDerived) {
            return;
        }
        this.addArc(ref, defClock);
        if (base != null && !base.equals(ref)) {
            this.addArc(base, defClock);
        }
    }
}

