/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.kairos.timesquare.grph.viewer;

import fr.inria.aoste.utils.grph.FindAllCycles;
import fr.inria.kairos.timesquare.grph.viewer.GrphView;
import grph.Grph;
import grph.in_memory.InMemoryGrph;
import grph.path.Path;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.Iterator;
import javafx.concurrent.Worker;
import toools.text.TextUtilities;

public class GrphViewControler {
    public GrphView view;
    public Grph model;
    private ArrayList<String> selectedElements = new ArrayList();
    private FindAllCycles cycleProvider = null;
    private Iterator<IntArrayList> cycleIterator = null;
    private boolean hasNext;
    private int initialState;
    public ArrayList<IntSet> allInitPath = new ArrayList();
    private IntArrayList lastCycleNodes = new IntArrayList();
    private IntSet lastPath = new IntArraySet();
    private Grph g;

    public GrphViewControler(GrphView v) {
        this.view = v;
        this.model = new InMemoryGrph();
    }

    public void addNode(int v) {
        String name = "n" + v;
        this.view.addNode(name, v);
    }

    public void addEdge(int edge, String label, int source, int target, boolean directed) {
        String id = "e" + edge;
        this.view.addEdge(id, label, "n" + source, "n" + target, directed, edge);
    }

    public void doSelectElementInView() {
        this.view.selectElements(this.selectedElements);
    }

    public void addEdgeToSelectedElements(int e) {
        this.selectedElements.add("e" + e);
    }

    public void addNodeToSelectedElements(int n) {
        this.selectedElements.add("n" + n);
    }

    /*
     * Unable to fully structure code
     */
    public void addGrph(int initialState) {
        loadWorker = this.view.internalView.webEngine.getLoadWorker();
        if (loadWorker.getState() != Worker.State.FAILED) ** GOTO lbl10
        throw new RuntimeException("Web engine load worker in failed state");
lbl-1000:
        // 1 sources

        {
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            System.out.println("sleeping...");
lbl10:
            // 2 sources

            ** while (loadWorker.getState() != Worker.State.SUCCEEDED)
        }
lbl11:
        // 1 sources

        if (this.model == null) {
            return;
        }
        this.view.clearAll();
        for (Integer ic : this.model.getVertices()) {
            this.addNode(ic);
        }
        for (Integer ic : this.model.getEdges()) {
            this.addEdge(ic, this.model.getEdgeLabelProperty().getValueAsString(ic.intValue()), this.model.getDirectedSimpleEdgeTail(ic.intValue()), this.model.getDirectedSimpleEdgeHead(ic.intValue()), true);
        }
        this.view.internalView.autosize();
        this.view.layoutRun();
        this.initialState = initialState;
        this.cycleProvider = new FindAllCycles(this.model, (IntSet)this.model.getVertices(), false);
        this.cycleIterator = this.cycleProvider.iterator();
        this.hasNext = this.cycleIterator.hasNext();
    }

    public void highlightNextSchedule() {
        this.selectedElements.clear();
        this.view.unselectAll();
        this.unsetClassForVertexAndEdges(new IntArrayList((IntCollection)this.lastPath), "highlighted");
        this.lastPath.clear();
        if (this.cycleIterator == null) {
            return;
        }
        if (!this.hasNext) {
            return;
        }
        this.lastCycleNodes.clear();
        this.lastCycleNodes = this.cycleIterator.next();
        this.hasNext = this.cycleIterator.hasNext() && this.lastCycleNodes.size() > 0;
        System.out.println("cycle is " + this.lastCycleNodes);
        this.allInitPath = this.computeAllInitializationPath();
        this.highlightVertexAndEdges(this.lastCycleNodes);
        this.doSelectElementInView();
        this.lastPath = this.allInitPath.get(0);
        this.allInitPath.remove(0);
        this.setClassForVertexAndEdges(new IntArrayList((IntCollection)this.lastPath), "highlighted");
    }

    public void highlightNextDifferentSchedule(int n) {
        this.selectedElements.clear();
        this.view.unselectAll();
        this.unsetClassForVertexAndEdges(new IntArrayList((IntCollection)this.lastPath), "highlighted");
        this.lastPath.clear();
        if (this.cycleIterator == null) {
            return;
        }
        if (!this.hasNext) {
            return;
        }
        IntArrayList newCycleNodes = new IntArrayList();
        do {
            newCycleNodes.clear();
            newCycleNodes = this.cycleIterator.next();
            boolean bl = this.hasNext = this.cycleIterator.hasNext() && newCycleNodes.size() > 0;
        } while (this.hasNext && TextUtilities.computeLevenshteinDistance((String)newCycleNodes.toString(), (String)this.lastCycleNodes.toString()) < (this.lastCycleNodes.size() - n > 0 ? this.lastCycleNodes.size() - n : 1));
        System.out.println("old cycle: " + this.lastCycleNodes + "\n kept cycle is " + newCycleNodes);
        this.lastCycleNodes.clear();
        this.lastCycleNodes = newCycleNodes;
        this.allInitPath = this.computeAllInitializationPath();
        this.highlightVertexAndEdges(this.lastCycleNodes);
        this.doSelectElementInView();
        this.lastPath = this.allInitPath.get(0);
        this.allInitPath.remove(0);
        this.setClassForVertexAndEdges(new IntArrayList((IntCollection)this.lastPath), "highlighted");
    }

    private ArrayList<IntSet> computeAllInitializationPath() {
        ArrayList<IntSet> allInitPath = new ArrayList<IntSet>();
        int n = this.lastCycleNodes.getInt(0);
        Path p = this.model.getShortestPath(this.initialState, n);
        if (p != null) {
            IntSet pset = p.toVertexSet();
            pset.add(n);
            allInitPath.add(pset);
        }
        return allInitPath;
    }

    public void setClassForVertexAndEdges(IntArrayList nodes, String classs) {
        int previous = -1;
        int first = -1;
        Iterator iterator = nodes.iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            this.view.addClass("n" + n, classs);
            if (previous == -1) {
                previous = n;
                first = n;
                continue;
            }
            IntSet edges = this.model.getEdgesConnecting(previous, n);
            Iterator iterator2 = edges.iterator();
            while (iterator2.hasNext()) {
                int e = (Integer)iterator2.next();
                this.view.addClass("e" + e, classs);
            }
            previous = n;
        }
        IntSet edges = this.model.getEdgesConnecting(previous, first);
        Iterator iterator3 = edges.iterator();
        while (iterator3.hasNext()) {
            int e = (Integer)iterator3.next();
            this.view.addClass("e" + e, classs);
        }
    }

    public void unsetClassForVertexAndEdges(IntArrayList nodes, String classs) {
        int previous = -1;
        int first = -1;
        Iterator iterator = nodes.iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            this.view.removeClass("n" + n, classs);
            if (previous == -1) {
                previous = n;
                first = n;
                continue;
            }
            IntSet edges = this.model.getEdgesConnecting(previous, n);
            Iterator iterator2 = edges.iterator();
            while (iterator2.hasNext()) {
                int e = (Integer)iterator2.next();
                this.view.removeClass("e" + e, classs);
            }
            previous = n;
        }
        if (previous != -1 && first != -1) {
            IntSet edges = this.model.getEdgesConnecting(previous, first);
            Iterator iterator3 = edges.iterator();
            while (iterator3.hasNext()) {
                int e = (Integer)iterator3.next();
                this.view.removeClass("e" + e, classs);
            }
        }
    }

    private void highlightVertexAndEdges(IntArrayList nodes) {
        int previous = -1;
        int first = -1;
        Iterator iterator = nodes.iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            this.addNodeToSelectedElements(n);
            if (previous == -1) {
                previous = n;
                first = n;
                continue;
            }
            IntSet edges = this.model.getEdgesConnecting(previous, n);
            Iterator iterator2 = edges.iterator();
            while (iterator2.hasNext()) {
                int e = (Integer)iterator2.next();
                this.addEdgeToSelectedElements(e);
            }
            previous = n;
        }
        IntSet edges = this.model.getEdgesConnecting(previous, first);
        Iterator iterator3 = edges.iterator();
        while (iterator3.hasNext()) {
            int e = (Integer)iterator3.next();
            this.addEdgeToSelectedElements(e);
        }
    }

    public void clearAllInitPath() {
        this.allInitPath.clear();
    }
}

