/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.ccslkernel.runtime.simulation;

import fr.inria.aoste.timesquare.ccslkernel.runtime.elements.RuntimeClock;
import fr.inria.aoste.timesquare.ccslkernel.runtime.exceptions.NoBooleanSolution;
import fr.inria.aoste.timesquare.ccslkernel.runtime.exceptions.SimulationException;
import fr.inria.aoste.timesquare.ccslkernel.runtime.helpers.AbstractSemanticHelper;
import fr.inria.aoste.timesquare.ccslkernel.runtime.helpers.AbstractUpdateHelper;
import fr.inria.aoste.timesquare.ccslkernel.runtime.helpers.BDDHelper;
import fr.inria.aoste.timesquare.ccslkernel.runtime.helpers.SemanticHelper;
import fr.inria.aoste.timesquare.ccslkernel.runtime.helpers.UpdateHelper;
import fr.inria.aoste.timesquare.ccslkernel.runtime.simulation.AbstractStepExecutionEngine;
import fr.inria.aoste.timesquare.ccslkernel.runtime.simulation.CCSLSimulationEngine;
import fr.inria.aoste.timesquare.simulationpolicy.SimulationPolicyBase;
import fr.inria.aoste.timesquare.simulationpolicy.bitset.ClockTraceState;
import fr.inria.aoste.timesquare.simulationpolicy.bitset.ClockTraceStateSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.javabdd.BuDDyFactory;

public class CCSLStepExecutionEngine
extends AbstractStepExecutionEngine {
    private BDDHelper bddHelper = new BDDHelper();

    public CCSLStepExecutionEngine(CCSLSimulationEngine simulationEngine) {
        super(simulationEngine);
        this.initHelpers();
    }

    @Override
    protected AbstractSemanticHelper createSemanticHelper() {
        return new SemanticHelper(this, this.bddHelper);
    }

    @Override
    protected AbstractUpdateHelper createUpdateHelper() {
        return new UpdateHelper(this);
    }

    @Override
    protected void stepPreHook() {
    }

    @Override
    protected void stepPostHook() {
    }

    @Override
    protected void constructCurrentStepBDD() throws SimulationException {
        this.setSemanticBdd(this.getBuddyFactory().one());
        this.simulationEngine.getModel().semantic(this.getSemanticHelper());
        BuDDyFactory.BuDDyBDD clockDisjunction = this.buildAllClocksDisjunction();
        this.semanticBdd.andWith(clockDisjunction);
    }

    private BuDDyFactory.BuDDyBDD buildAllClocksDisjunction() {
        BuDDyFactory.BuDDyBDD clockDisjunction = this.getBuddyFactory().zero();
        for (RuntimeClock clock : this.getUsedClocks()) {
            BuDDyFactory.BuDDyBDD bddClockVar = this.getBuddyFactory().ithVar(clock.bddVariableNumber);
            clockDisjunction.orWith(bddClockVar);
        }
        return clockDisjunction;
    }

    @Override
    public List<RuntimeClock> getAllDiscreteClocks() {
        return this.simulationEngine.getModel().getAllDiscreteClocks();
    }

    public ArrayList<ArrayList<RuntimeClock>> getAllPossibleRuntimeClockSets() throws NoBooleanSolution {
        this.allClockTraceStateSet = this.getAllBDDSolutions();
        List<RuntimeClock> allClocks = this.getAllDiscreteClocks();
        ArrayList<RuntimeClock> afiredClockSet = new ArrayList<RuntimeClock>();
        ArrayList<ArrayList<RuntimeClock>> allPossibleRuntimeClockSets = new ArrayList<ArrayList<RuntimeClock>>();
        for (ClockTraceStateSet aRes : this.allClockTraceStateSet) {
            for (RuntimeClock rc : allClocks) {
                if (!this.getUsedClocks().contains(rc) || aRes.get(this.getIndexInSolution(rc.bddVariableNumber)) != ClockTraceState.F) continue;
                afiredClockSet.add(rc);
            }
            allPossibleRuntimeClockSets.add(afiredClockSet);
        }
        return allPossibleRuntimeClockSets;
    }

    @Override
    public ArrayList<ClockTraceStateSet> getAllBDDSolutions() throws NoBooleanSolution {
        if (this.getSemanticBdd().isZero()) {
            return new ArrayList<ClockTraceStateSet>();
        }
        BuDDyFactory.BuDDyBDD varSet = this.getBuddyFactory().one();
        for (Integer current : this.getBddVarToIndexInSolution().keySet()) {
            varSet = varSet.and(this.getBuddyFactory().ithVar(current.intValue()));
        }
        BuDDyFactory.BuDDyBDD.BDDIterator it = this.getSemanticBdd().iterator(varSet);
        ArrayList<ClockTraceStateSet> allSolutionsF = new ArrayList<ClockTraceStateSet>();
        int allClockSize = this.getBddVarToIndexInSolution().size();
        while (it.hasNext()) {
            ClockTraceStateSet tempF = new ClockTraceStateSet(allClockSize);
            ClockTraceStateSet tempE = new ClockTraceStateSet(allClockSize);
            BuDDyFactory.BuDDyBDD v = (BuDDyFactory.BuDDyBDD)it.next();
            for (int bddVarNumber : this.getBddVarToIndexInSolution().keySet()) {
                int index = 0;
                index = this.getBddVarToIndexInSolution().get(bddVarNumber);
                if (!v.and(this.getBuddyFactory().ithVar(bddVarNumber)).isZero()) {
                    tempF.set(index, ClockTraceState.T);
                    tempE.set(index, ClockTraceState.T);
                    continue;
                }
                tempF.set(index, ClockTraceState.F);
                tempE.set(index, ClockTraceState.F);
            }
            allSolutionsF.add(tempF);
        }
        varSet.free();
        return allSolutionsF;
    }

    @Override
    public void rewriteExpressions() throws SimulationException {
        for (RuntimeClock clock : this.getAllDiscreteClocks()) {
            if (this.getClockFiredState(clock) == ClockTraceState.T) {
                this.registerClockFiring(clock);
            }
            if (this.getClockEnabledState(clock) != ClockTraceState.T) continue;
            this.enabledClocks.add(clock);
        }
        this.simulationEngine.getModel().update(this.getUpdateHelper());
    }

    @Override
    protected void buildDeathExpressions() throws SimulationException {
        this.simulationEngine.getModel().deathSemantic(this.getSemanticHelper());
    }

    @Override
    public Map<Integer, Integer> getBddVarToIndexInSolution() {
        return this.simulationEngine.getBddVarToIndexInSolution();
    }

    @Override
    protected BuDDyFactory getBuddyFactory() {
        return this.bddHelper.getFactory();
    }

    @Override
    public SimulationPolicyBase getSimulationPolicy() {
        return ((CCSLSimulationEngine)this.simulationEngine).getSimulationPolicy();
    }

    @Override
    public Set<RuntimeClock> getDeadClocks() {
        return this.simulationEngine.getDeadClocks();
    }

    @Override
    public void addDeadClock(RuntimeClock clock) {
        this.simulationEngine.addDeadClock(clock);
    }

    @Override
    public void dealWithBlockTransition() {
        throw new RuntimeException("dealWithBlockTransition() not yet implemented in CCSLStepExecutionEngine");
    }
}

