/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.actions.visibility;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.Disposable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.business.api.query.DDiagramElementQuery;
import org.eclipse.sirius.diagram.tools.api.command.IDiagramCommandFactory;
import org.eclipse.sirius.diagram.tools.api.command.IDiagramCommandFactoryProvider;
import org.eclipse.sirius.diagram.ui.business.api.provider.AbstractDDiagramElementLabelItemProvider;
import org.eclipse.sirius.diagram.ui.business.api.provider.DEdgeBeginLabelItemProvider;
import org.eclipse.sirius.diagram.ui.business.api.provider.DEdgeEndLabelItemProvider;
import org.eclipse.sirius.diagram.ui.business.api.provider.DEdgeLabelItemProvider;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.AbstractDEdgeNameEditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.DEdgeBeginNameEditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.DEdgeEndNameEditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.DEdgeNameEditPart;
import org.eclipse.sirius.diagram.ui.provider.DiagramUIPlugin;
import org.eclipse.sirius.diagram.ui.tools.api.editor.DDiagramEditor;
import org.eclipse.sirius.diagram.ui.tools.internal.actions.visibility.TabbarRevealLabelsAction;
import org.eclipse.sirius.diagram.ui.tools.internal.editor.DiagramOutlinePage;
import org.eclipse.sirius.ecore.extender.business.api.permission.IPermissionAuthority;
import org.eclipse.sirius.ecore.extender.business.api.permission.PermissionAuthorityRegistry;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class HideDDiagramElementLabelAction
extends Action
implements IObjectActionDelegate,
Disposable {
    private static Predicate<Object> isEnabledPredicate = new Predicate<Object>(){

        public boolean apply(Object input) {
            Option<DDiagramElement> optionTarget;
            boolean result = false;
            if (input instanceof IGraphicalEditPart) {
                result = HideDDiagramElementLabelAction.isEnabled((IGraphicalEditPart)input);
            } else if (input instanceof DDiagramElement) {
                result = HideDDiagramElementLabelAction.isEnabled((DDiagramElement)input);
            } else if (input instanceof AbstractDDiagramElementLabelItemProvider && (optionTarget = ((AbstractDDiagramElementLabelItemProvider)((Object)input)).getDiagramElementTarget()).some()) {
                result = input instanceof DEdgeBeginLabelItemProvider ? HideDDiagramElementLabelAction.isEnabled((DDiagramElement)optionTarget.get(), 6002) : (input instanceof DEdgeLabelItemProvider ? HideDDiagramElementLabelAction.isEnabled((DDiagramElement)optionTarget.get(), 6001) : (input instanceof DEdgeEndLabelItemProvider ? HideDDiagramElementLabelAction.isEnabled((DDiagramElement)optionTarget.get(), 6003) : HideDDiagramElementLabelAction.isEnabled((DDiagramElement)optionTarget.get())));
            }
            return result;
        }
    };
    private ISelection selection;
    private TabbarRevealLabelsAction oppositeAction;
    private Map<EObject, List<Integer>> semanticToLabelsVisualIDToHideMap = new HashMap<EObject, List<Integer>>();

    public HideDDiagramElementLabelAction() {
    }

    public HideDDiagramElementLabelAction(String text) {
        this(text, DiagramUIPlugin.Implementation.getBundledImageDescriptor("icons/categoryLabelHidden.gif"));
    }

    public HideDDiagramElementLabelAction(String text, ImageDescriptor image) {
        super(text, image);
        this.setId(text);
    }

    public boolean isEnabled() {
        if (this.selection instanceof IStructuredSelection) {
            return HideDDiagramElementLabelAction.isEnabled(((IStructuredSelection)this.selection).toList());
        }
        return super.isEnabled();
    }

    public static boolean isEnabled(Collection<?> elementsToCheck) {
        return Iterables.any(elementsToCheck, isEnabledPredicate);
    }

    private static boolean isEnabled(IGraphicalEditPart graphicalEditPart) {
        if (graphicalEditPart.isActive() && graphicalEditPart.resolveSemanticElement() instanceof DDiagramElement) {
            return HideDDiagramElementLabelAction.isEnabled((DDiagramElement)graphicalEditPart.resolveSemanticElement());
        }
        return false;
    }

    private static boolean isEnabled(DDiagramElement diagramElement) {
        DDiagram dDiagram = diagramElement.getParentDiagram();
        DDiagramElementQuery query = new DDiagramElementQuery(diagramElement);
        return dDiagram != null && HideDDiagramElementLabelAction.isEditable(dDiagram) && query.canHideLabel() && !query.isLabelHidden();
    }

    private static boolean isEnabled(DDiagramElement diagramElement, int labelVisualID) {
        DDiagram dDiagram = diagramElement.getParentDiagram();
        DDiagramElementQuery query = new DDiagramElementQuery(diagramElement);
        return dDiagram != null && HideDDiagramElementLabelAction.isEditable(dDiagram) && query.canHideLabel() && !query.isLabelHidden(labelVisualID);
    }

    private static boolean isEditable(DDiagram diagram) {
        boolean isEditable = false;
        Resource resource = diagram.eResource();
        if (resource != null) {
            IPermissionAuthority permissionAuthority = PermissionAuthorityRegistry.getDefault().getPermissionAuthority(resource.getResourceSet());
            isEditable = permissionAuthority.canEditInstance((EObject)diagram);
        }
        return isEditable;
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        IStructuredSelection structuredSelection;
        HashSet<Object> minimizedSelection;
        if (this.selection instanceof IStructuredSelection && (minimizedSelection = new HashSet<Object>(Arrays.asList((structuredSelection = (IStructuredSelection)this.selection).toArray()))).size() > 0) {
            Object nextSelected = minimizedSelection.iterator().next();
            if (nextSelected instanceof EditPart) {
                RootEditPart root = ((EditPart)nextSelected).getRoot();
                DDiagramEditor diagramEditor = (DDiagramEditor)((EditPart)nextSelected).getViewer().getProperty("org.eclipse.sirius.diagram.ui.part.SiriusDiagramEditorID");
                List<Object> selectionList = Arrays.asList(structuredSelection.toArray());
                if (this.containsEdgeLabelsInSelection(selectionList)) {
                    Set<EObject> partsToSemantic = this.partsToSemantic(selectionList);
                    this.runHideLabelSelectionCommand(root, diagramEditor, partsToSemantic, this.collectLabelsToHideVisualIds(partsToSemantic, selectionList));
                } else {
                    this.semanticToLabelsVisualIDToHideMap.clear();
                    this.runHideLabelCommand(root, diagramEditor, this.partsToSemantic(selectionList));
                }
            } else if (nextSelected instanceof DDiagramElement || nextSelected instanceof AbstractDDiagramElementLabelItemProvider) {
                this.runForNoEditPartSelection(minimizedSelection);
            }
            if (this.oppositeAction != null) {
                this.oppositeAction.setEnabled(this.oppositeAction.isEnabled());
            }
            this.setEnabled(this.isEnabled());
        }
    }

    private Map<EObject, List<Integer>> collectLabelsToHideVisualIds(Set<EObject> partsToSemantic, List<Object> edgeLabelsEditParts) {
        for (EObject eObject : partsToSemantic) {
            this.semanticToLabelsVisualIDToHideMap.put(eObject, new LinkedList());
        }
        for (IGraphicalEditPart object : edgeLabelsEditParts.stream().filter(IGraphicalEditPart.class::isInstance).map(IGraphicalEditPart.class::cast).collect(Collectors.toSet())) {
            EObject element = object.resolveSemanticElement();
            if (object instanceof DEdgeBeginNameEditPart) {
                this.semanticToLabelsVisualIDToHideMap.get(element).add(6002);
                continue;
            }
            if (object instanceof DEdgeNameEditPart) {
                this.semanticToLabelsVisualIDToHideMap.get(element).add(6001);
                continue;
            }
            if (!(object instanceof DEdgeEndNameEditPart)) continue;
            this.semanticToLabelsVisualIDToHideMap.get(element).add(6003);
        }
        return this.semanticToLabelsVisualIDToHideMap;
    }

    private boolean containsEdgeLabelsInSelection(List<Object> asList) {
        for (Object object : asList) {
            if (!(object instanceof AbstractDEdgeNameEditPart)) continue;
            return true;
        }
        return false;
    }

    private void runForNoEditPartSelection(Set<Object> minimizedSelection) {
        HashSet<EObject> eObjectSelection = new HashSet<EObject>();
        Iterator<Object> it = minimizedSelection.iterator();
        this.semanticToLabelsVisualIDToHideMap.clear();
        while (it.hasNext()) {
            Object obj = it.next();
            if (!isEnabledPredicate.apply(obj)) continue;
            if (obj instanceof EObject) {
                eObjectSelection.add((EObject)obj);
                continue;
            }
            if (!(obj instanceof AbstractDDiagramElementLabelItemProvider) || !((AbstractDDiagramElementLabelItemProvider)((Object)obj)).getDiagramElementTarget().some()) continue;
            DDiagramElement dDiagramElement = (DDiagramElement)((AbstractDDiagramElementLabelItemProvider)((Object)obj)).getDiagramElementTarget().get();
            eObjectSelection.add((EObject)dDiagramElement);
            if (!(obj instanceof DEdgeBeginLabelItemProvider) && !(obj instanceof DEdgeLabelItemProvider) && !(obj instanceof DEdgeEndLabelItemProvider)) continue;
            if (!this.semanticToLabelsVisualIDToHideMap.keySet().contains(dDiagramElement)) {
                this.semanticToLabelsVisualIDToHideMap.put((EObject)dDiagramElement, new LinkedList());
            }
            if (obj instanceof DEdgeBeginLabelItemProvider) {
                this.semanticToLabelsVisualIDToHideMap.get(dDiagramElement).add(6002);
                continue;
            }
            if (obj instanceof DEdgeLabelItemProvider) {
                this.semanticToLabelsVisualIDToHideMap.get(dDiagramElement).add(6001);
                continue;
            }
            if (!(obj instanceof DEdgeEndLabelItemProvider)) continue;
            this.semanticToLabelsVisualIDToHideMap.get(dDiagramElement).add(6003);
        }
        this.run(eObjectSelection);
    }

    public void run() {
        this.selection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getSelection();
        this.run((IAction)this);
    }

    private void run(Set<EObject> minimizedSelection) {
        if (this.selection instanceof DiagramOutlinePage.TreeSelectionWrapper) {
            DiagramOutlinePage.TreeSelectionWrapper wrapper = (DiagramOutlinePage.TreeSelectionWrapper)this.selection;
            RootEditPart root = wrapper.getRoot();
            DDiagramEditor diagramEditor = (DDiagramEditor)wrapper.getViewer().getProperty("org.eclipse.sirius.diagram.ui.part.SiriusDiagramEditorID");
            this.runHideLabelCommand(root, diagramEditor, minimizedSelection);
        }
    }

    private void runHideLabelCommand(RootEditPart root, DDiagramEditor editor, Set<EObject> elements) {
        Object adapter = editor.getAdapter(IDiagramCommandFactoryProvider.class);
        IDiagramCommandFactoryProvider cmdFactoryProvider = (IDiagramCommandFactoryProvider)adapter;
        TransactionalEditingDomain transactionalEditingDomain = TransactionUtil.getEditingDomain((ResourceSet)editor.getEditingDomain().getResourceSet());
        IDiagramCommandFactory emfCommandFactory = cmdFactoryProvider.getCommandFactory(transactionalEditingDomain);
        Command cmd = this.semanticToLabelsVisualIDToHideMap.isEmpty() ? emfCommandFactory.buildHideLabelCommand(elements) : emfCommandFactory.buildHideLabelSelectionCommand(elements, this.semanticToLabelsVisualIDToHideMap);
        ((TransactionalEditingDomain)editor.getAdapter(EditingDomain.class)).getCommandStack().execute(cmd);
    }

    private void runHideLabelSelectionCommand(RootEditPart root, DDiagramEditor editor, Set<EObject> elements, Map<EObject, List<Integer>> selectedLabelVisualIds) {
        Object adapter = editor.getAdapter(IDiagramCommandFactoryProvider.class);
        IDiagramCommandFactoryProvider cmdFactoryProvider = (IDiagramCommandFactoryProvider)adapter;
        TransactionalEditingDomain transactionalEditingDomain = TransactionUtil.getEditingDomain((ResourceSet)editor.getEditingDomain().getResourceSet());
        IDiagramCommandFactory emfCommandFactory = cmdFactoryProvider.getCommandFactory(transactionalEditingDomain);
        Command cmd = emfCommandFactory.buildHideLabelSelectionCommand(elements, selectedLabelVisualIds);
        ((TransactionalEditingDomain)editor.getAdapter(EditingDomain.class)).getCommandStack().execute(cmd);
    }

    private Set<EObject> partsToSemantic(List<Object> asList) {
        HashSet<EObject> result = new HashSet<EObject>();
        for (Object obj : asList) {
            IGraphicalEditPart part;
            EObject element;
            if (!(obj instanceof IGraphicalEditPart) || (element = (part = (IGraphicalEditPart)obj).resolveSemanticElement()) == null) continue;
            result.add(element);
        }
        return result;
    }

    public void selectionChanged(IAction action, ISelection s) {
        this.selection = s;
        this.setEnabled(true);
        if (s instanceof DiagramOutlinePage.TreeSelectionWrapper) {
            this.setEnabled(HideDDiagramElementLabelAction.isEnabled(((DiagramOutlinePage.TreeSelectionWrapper)s).toList()));
        } else if (s instanceof IStructuredSelection) {
            this.setEnabled(HideDDiagramElementLabelAction.isEnabled(((IStructuredSelection)s).toList()));
        }
    }

    public void dispose() {
        this.selection = null;
        this.oppositeAction = null;
    }

    public void setOppositeRevealAction(TabbarRevealLabelsAction revealOutlineLabelsAction) {
        this.oppositeAction = revealOutlineLabelsAction;
    }
}

