/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.mgmt.framework.internal;

import java.util.HashMap;
import java.util.Map;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.TabularDataSupport;
import org.eclipse.gemini.mgmt.framework.CustomBundleWiringStateMBean;
import org.eclipse.gemini.mgmt.internal.OSGiProperties;
import org.osgi.framework.wiring.BundleRequirement;

public class OSGiBundleRequirement {
    private final BundleRequirement bundleRequirement;

    public OSGiBundleRequirement(BundleRequirement bundleRequirement) {
        this.bundleRequirement = bundleRequirement;
    }

    public CompositeData asCompositeData() {
        try {
            TabularDataSupport tabularAttributes = new TabularDataSupport(CustomBundleWiringStateMBean.ATTRIBUTES_TYPE);
            Map attributes = this.bundleRequirement.getAttributes();
            for (Map.Entry attribute : attributes.entrySet()) {
                tabularAttributes.put(OSGiProperties.encode((String)attribute.getKey(), attribute.getValue()));
            }
            TabularDataSupport tabularDirectives = new TabularDataSupport(CustomBundleWiringStateMBean.DIRECTIVES_TYPE);
            Map directives = this.bundleRequirement.getDirectives();
            for (Map.Entry directive : directives.entrySet()) {
                tabularDirectives.put(new CompositeDataSupport(CustomBundleWiringStateMBean.PROPERTY_TYPE, OSGiProperties.getDirectiveKeyValueItem((String)directive.getKey(), directive.getValue())));
            }
            HashMap<String, Object> items = new HashMap<String, Object>();
            items.put("Attributes", tabularAttributes);
            items.put("Directives", tabularDirectives);
            items.put("Namespace", this.bundleRequirement.getNamespace());
            return new CompositeDataSupport(CustomBundleWiringStateMBean.BUNDLE_REQUIREMENT_TYPE, items);
        }
        catch (OpenDataException e) {
            throw new IllegalStateException("Cannot form bundle requirment open data", e);
        }
    }
}

