/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.ui.common.base.editor;

import com.google.common.collect.Sets;
import java.util.Set;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListenerImpl;
import org.eclipse.emf.transaction.TransactionalEditingDomain;

public class ModificationTrackingEnabler
extends ResourceSetListenerImpl {
    private final Set<String> fileExtensions = Sets.newHashSet((Object[])new String[]{"structure", "behavior", "room"});

    public void setTarget(TransactionalEditingDomain domain) {
        super.setTarget(domain);
        this.setTrackingModification();
    }

    public void resourceSetChanged(ResourceSetChangeEvent event) {
        super.resourceSetChanged(event);
        this.setTrackingModification();
    }

    protected void setTrackingModification() {
        ResourceSet rs = this.getTarget().getResourceSet();
        for (Resource r : rs.getResources()) {
            if (!this.shouldTrack(r) || r.isTrackingModification()) continue;
            r.setTrackingModification(true);
        }
    }

    protected boolean shouldTrack(Resource resource) {
        String fileExt = resource.getURI().fileExtension();
        return this.fileExtensions.contains(fileExt.toLowerCase());
    }
}

